/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.applications;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.widget.LinearLayout;

public class LinearColorBar
extends LinearLayout {
    static final int LEFT_COLOR = -6250336;
    static final int MIDDLE_COLOR = -6250336;
    static final int RIGHT_COLOR = -6242144;
    private float mRedRatio;
    private float mYellowRatio;
    private float mGreenRatio;
    private boolean mShowingGreen;
    final Rect mRect = new Rect();
    final Paint mPaint = new Paint();
    int mLastInterestingLeft;
    int mLastInterestingRight;
    int mLineWidth;
    final Path mColorPath = new Path();
    final Path mEdgePath = new Path();
    final Paint mColorGradientPaint = new Paint();
    final Paint mEdgeGradientPaint = new Paint();

    public LinearColorBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setWillNotDraw(false);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mColorGradientPaint.setStyle(Paint.Style.FILL);
        this.mColorGradientPaint.setAntiAlias(true);
        this.mEdgeGradientPaint.setStyle(Paint.Style.STROKE);
        this.mLineWidth = this.getResources().getDisplayMetrics().densityDpi >= 240 ? 2 : 1;
        this.mEdgeGradientPaint.setStrokeWidth((float)this.mLineWidth);
        this.mEdgeGradientPaint.setAntiAlias(true);
    }

    public void setRatios(float red, float yellow, float green) {
        this.mRedRatio = red;
        this.mYellowRatio = yellow;
        this.mGreenRatio = green;
        this.invalidate();
    }

    public void setShowingGreen(boolean showingGreen) {
        if (this.mShowingGreen != showingGreen) {
            this.mShowingGreen = showingGreen;
            this.updateIndicator();
            this.invalidate();
        }
    }

    private void updateIndicator() {
        int off = this.getPaddingTop() - this.getPaddingBottom();
        if (off < 0) {
            off = 0;
        }
        this.mRect.top = off;
        this.mRect.bottom = this.getHeight();
        if (this.mShowingGreen) {
            this.mColorGradientPaint.setShader((Shader)new LinearGradient(0.0f, 0.0f, 0.0f, (float)(off - 2), 0xA0C0A0, -6242144, Shader.TileMode.CLAMP));
        } else {
            this.mColorGradientPaint.setShader((Shader)new LinearGradient(0.0f, 0.0f, 0.0f, (float)(off - 2), 0xA0A0A0, -6250336, Shader.TileMode.CLAMP));
        }
        this.mEdgeGradientPaint.setShader((Shader)new LinearGradient(0.0f, 0.0f, 0.0f, (float)(off / 2), 0xA0A0A0, -6250336, Shader.TileMode.CLAMP));
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.updateIndicator();
    }

    protected void onDraw(Canvas canvas) {
        int indicatorRight;
        int indicatorLeft;
        super.onDraw(canvas);
        int width = this.getWidth();
        int left = 0;
        int right = left + (int)((float)width * this.mRedRatio);
        int right2 = right + (int)((float)width * this.mYellowRatio);
        int right3 = right2 + (int)((float)width * this.mGreenRatio);
        if (this.mShowingGreen) {
            indicatorLeft = right2;
            indicatorRight = right3;
        } else {
            indicatorLeft = right;
            indicatorRight = right2;
        }
        if (this.mLastInterestingLeft != indicatorLeft || this.mLastInterestingRight != indicatorRight) {
            this.mColorPath.reset();
            this.mEdgePath.reset();
            if (indicatorLeft < indicatorRight) {
                int midTopY = this.mRect.top;
                boolean midBottomY = false;
                int xoff = 2;
                this.mColorPath.moveTo((float)indicatorLeft, (float)this.mRect.top);
                this.mColorPath.cubicTo((float)indicatorLeft, 0.0f, -2.0f, (float)midTopY, -2.0f, 0.0f);
                this.mColorPath.lineTo((float)(width + 2 - 1), 0.0f);
                this.mColorPath.cubicTo((float)(width + 2 - 1), (float)midTopY, (float)indicatorRight, 0.0f, (float)indicatorRight, (float)this.mRect.top);
                this.mColorPath.close();
                float lineOffset = (float)this.mLineWidth + 0.5f;
                this.mEdgePath.moveTo(-2.0f + lineOffset, 0.0f);
                this.mEdgePath.cubicTo(-2.0f + lineOffset, (float)midTopY, (float)indicatorLeft + lineOffset, 0.0f, (float)indicatorLeft + lineOffset, (float)this.mRect.top);
                this.mEdgePath.moveTo((float)(width + 2 - 1) - lineOffset, 0.0f);
                this.mEdgePath.cubicTo((float)(width + 2 - 1) - lineOffset, (float)midTopY, (float)indicatorRight - lineOffset, 0.0f, (float)indicatorRight - lineOffset, (float)this.mRect.top);
            }
            this.mLastInterestingLeft = indicatorLeft;
            this.mLastInterestingRight = indicatorRight;
        }
        if (!this.mEdgePath.isEmpty()) {
            canvas.drawPath(this.mEdgePath, this.mEdgeGradientPaint);
            canvas.drawPath(this.mColorPath, this.mColorGradientPaint);
        }
        if (left < right) {
            this.mRect.left = left;
            this.mRect.right = right;
            this.mPaint.setColor(-6250336);
            canvas.drawRect(this.mRect, this.mPaint);
            width -= right - left;
            left = right;
        }
        if (left < (right = right2)) {
            this.mRect.left = left;
            this.mRect.right = right;
            this.mPaint.setColor(-6250336);
            canvas.drawRect(this.mRect, this.mPaint);
            width -= right - left;
            left = right;
        }
        if (left < (right = left + width)) {
            this.mRect.left = left;
            this.mRect.right = right;
            this.mPaint.setColor(-6242144);
            canvas.drawRect(this.mRect, this.mPaint);
        }
    }
}

