/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.applications;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageMoveObserver;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.hardware.usb.IUsbManager;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.text.format.Formatter;
import android.util.Log;
import android.view.View;
import android.widget.AppSecurityPermissions;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.android.settings.applications.ApplicationsState;
import com.android.settings.applications.CanBeOnSdCardChecker;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstalledAppDetails
extends Activity
implements View.OnClickListener,
ApplicationsState.Callbacks {
    private static final String TAG = "InstalledAppDetails";
    static final boolean SUPPORT_DISABLE_APPS = false;
    private static final boolean localLOGV = false;
    private PackageManager mPm;
    private IUsbManager mUsbManager;
    private ApplicationsState mState;
    private ApplicationsState.AppEntry mAppEntry;
    private PackageInfo mPackageInfo;
    private CanBeOnSdCardChecker mCanBeOnSdCardChecker;
    private Button mUninstallButton;
    private boolean mMoveInProgress = false;
    private boolean mUpdatedSysApp = false;
    private Button mActivitiesButton;
    private boolean mCanClearData = true;
    private TextView mAppVersion;
    private TextView mTotalSize;
    private TextView mAppSize;
    private TextView mDataSize;
    private ClearUserDataObserver mClearDataObserver;
    private TextView mCacheSize;
    private Button mClearCacheButton;
    private ClearCacheObserver mClearCacheObserver;
    private Button mForceStopButton;
    private Button mClearDataButton;
    private Button mMoveAppButton;
    private int mMoveErrorCode;
    private PackageMoveObserver mPackageMoveObserver;
    private boolean mHaveSizes = false;
    private long mLastCodeSize = -1L;
    private long mLastDataSize = -1L;
    private long mLastCacheSize = -1L;
    private long mLastTotalSize = -1L;
    private static final int OP_SUCCESSFUL = 1;
    private static final int OP_FAILED = 2;
    private static final int CLEAR_USER_DATA = 1;
    private static final int CLEAR_CACHE = 3;
    private static final int PACKAGE_MOVE = 4;
    private static final int SIZE_INVALID = -1;
    private CharSequence mInvalidSizeStr;
    private CharSequence mComputingStr;
    private static final int DLG_BASE = 0;
    private static final int DLG_CLEAR_DATA = 1;
    private static final int DLG_FACTORY_RESET = 2;
    private static final int DLG_APP_NOT_FOUND = 3;
    private static final int DLG_CANNOT_CLEAR_DATA = 4;
    private static final int DLG_FORCE_STOP = 5;
    private static final int DLG_MOVE_FAILED = 6;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (InstalledAppDetails.this.isFinishing()) {
                return;
            }
            switch (msg.what) {
                case 1: {
                    InstalledAppDetails.this.processClearMsg(msg);
                    break;
                }
                case 3: {
                    InstalledAppDetails.this.mState.requestSize(((InstalledAppDetails)InstalledAppDetails.this).mAppEntry.info.packageName);
                    break;
                }
                case 4: {
                    InstalledAppDetails.this.processMoveMsg(msg);
                    break;
                }
            }
        }
    };
    private final BroadcastReceiver mCheckKillProcessesReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            InstalledAppDetails.this.mForceStopButton.setEnabled(this.getResultCode() != 0);
            InstalledAppDetails.this.mForceStopButton.setOnClickListener((View.OnClickListener)InstalledAppDetails.this);
        }
    };

    private String getSizeStr(long size) {
        if (size == -1L) {
            return ((Object)this.mInvalidSizeStr).toString();
        }
        return Formatter.formatFileSize((Context)this, (long)size);
    }

    private void initDataButtons() {
        if ((this.mAppEntry.info.flags & 0x41) == 1) {
            this.mClearDataButton.setText(2131231459);
            this.mClearDataButton.setEnabled(false);
            this.mCanClearData = false;
        } else {
            if (this.mAppEntry.info.manageSpaceActivityName != null) {
                this.mClearDataButton.setText(2131231469);
            } else {
                this.mClearDataButton.setText(2131231459);
            }
            this.mClearDataButton.setOnClickListener((View.OnClickListener)this);
        }
    }

    private CharSequence getMoveErrMsg(int errCode) {
        switch (errCode) {
            case -1: {
                return this.getString(2131231501);
            }
            case -2: {
                return this.getString(2131231502);
            }
            case -4: {
                return this.getString(2131231503);
            }
            case -5: {
                return this.getString(2131231504);
            }
            case -3: {
                return this.getString(2131231505);
            }
            case -6: {
                return "";
            }
        }
        return "";
    }

    private void initMoveButton() {
        boolean dataOnly = false;
        dataOnly = this.mPackageInfo == null && this.mAppEntry != null;
        boolean moveDisable = true;
        if (dataOnly) {
            this.mMoveAppButton.setText(2131231497);
        } else if ((this.mAppEntry.info.flags & 0x40000) != 0) {
            this.mMoveAppButton.setText(2131231498);
            moveDisable = false;
        } else {
            this.mMoveAppButton.setText(2131231499);
            this.mCanBeOnSdCardChecker.init();
            boolean bl = moveDisable = !this.mCanBeOnSdCardChecker.check(this.mAppEntry.info);
        }
        if (moveDisable) {
            this.mMoveAppButton.setEnabled(false);
        } else {
            this.mMoveAppButton.setOnClickListener((View.OnClickListener)this);
            this.mMoveAppButton.setEnabled(true);
        }
    }

    private void initUninstallButtons() {
        this.mUpdatedSysApp = (this.mAppEntry.info.flags & 0x80) != 0;
        boolean enabled = true;
        if (this.mUpdatedSysApp) {
            this.mUninstallButton.setText(2131231460);
        } else if ((this.mAppEntry.info.flags & 1) != 0) {
            enabled = false;
        } else {
            this.mUninstallButton.setText(2131231456);
        }
        this.mUninstallButton.setEnabled(enabled);
        if (enabled) {
            this.mUninstallButton.setOnClickListener((View.OnClickListener)this);
        }
    }

    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.mState = ApplicationsState.getInstance(this.getApplication());
        this.mPm = this.getPackageManager();
        IBinder b = ServiceManager.getService((String)"usb");
        this.mUsbManager = IUsbManager.Stub.asInterface((IBinder)b);
        this.mCanBeOnSdCardChecker = new CanBeOnSdCardChecker();
        this.setContentView(2130903063);
        this.mComputingStr = this.getText(2131231493);
        this.mTotalSize = (TextView)this.findViewById(2131427391);
        this.mAppSize = (TextView)this.findViewById(2131427393);
        this.mDataSize = (TextView)this.findViewById(2131427396);
        View btnPanel = this.findViewById(2131427388);
        this.mForceStopButton = (Button)btnPanel.findViewById(2131427517);
        this.mForceStopButton.setText(2131231452);
        this.mUninstallButton = (Button)btnPanel.findViewById(2131427518);
        this.mForceStopButton.setEnabled(false);
        View data_buttons_panel = this.findViewById(2131427397);
        this.mClearDataButton = (Button)data_buttons_panel.findViewById(2131427517);
        this.mMoveAppButton = (Button)data_buttons_panel.findViewById(2131427518);
        this.mCacheSize = (TextView)this.findViewById(2131427401);
        this.mClearCacheButton = (Button)this.findViewById(2131427402);
        this.mActivitiesButton = (Button)this.findViewById(2131427404);
    }

    private void setAppLabelAndIcon(PackageInfo pkgInfo) {
        View appSnippet = this.findViewById(2131427387);
        ImageView icon = (ImageView)appSnippet.findViewById(2131427422);
        this.mState.ensureIcon(this.mAppEntry);
        icon.setImageDrawable(this.mAppEntry.icon);
        TextView label = (TextView)appSnippet.findViewById(2131427423);
        label.setText((CharSequence)this.mAppEntry.label);
        this.mAppVersion = (TextView)appSnippet.findViewById(2131427424);
        if (pkgInfo != null && pkgInfo.versionName != null) {
            this.mAppVersion.setVisibility(0);
            this.mAppVersion.setText((CharSequence)this.getString(2131231496, new Object[]{String.valueOf(pkgInfo.versionName)}));
        } else {
            this.mAppVersion.setVisibility(4);
        }
    }

    public void onResume() {
        super.onResume();
        this.mState.resume(this);
        if (!this.refreshUi()) {
            this.setIntentAndFinish(true, true);
        }
    }

    public void onPause() {
        super.onPause();
        this.mState.pause();
    }

    @Override
    public void onAllSizesComputed() {
    }

    @Override
    public void onPackageIconChanged() {
    }

    @Override
    public void onPackageListChanged() {
        this.refreshUi();
    }

    @Override
    public void onRebuildComplete(ArrayList<ApplicationsState.AppEntry> apps) {
    }

    @Override
    public void onPackageSizeChanged(String packageName) {
        if (packageName.equals(this.mAppEntry.info.packageName)) {
            this.refreshSizeInfo();
        }
    }

    @Override
    public void onRunningStateChanged(boolean running) {
    }

    private boolean refreshUi() {
        if (this.mMoveInProgress) {
            return true;
        }
        Intent intent = this.getIntent();
        String packageName = intent.getData().getSchemeSpecificPart();
        this.mAppEntry = this.mState.getEntry(packageName);
        if (this.mAppEntry == null) {
            return false;
        }
        try {
            this.mPackageInfo = this.mPm.getPackageInfo(this.mAppEntry.info.packageName, 8768);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)("Exception when retrieving package:" + this.mAppEntry.info.packageName), (Throwable)e);
            return false;
        }
        ArrayList prefActList = new ArrayList();
        ArrayList intentList = new ArrayList();
        this.mPm.getPreferredActivities(intentList, prefActList, packageName);
        boolean hasUsbDefaults = false;
        try {
            hasUsbDefaults = this.mUsbManager.hasDefaults(packageName);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"mUsbManager.hasDefaults", (Throwable)e);
        }
        TextView autoLaunchView = (TextView)this.findViewById(2131427403);
        if (prefActList.size() <= 0 && !hasUsbDefaults) {
            autoLaunchView.setText(2131231462);
            this.mActivitiesButton.setEnabled(false);
        } else {
            autoLaunchView.setText(2131231461);
            this.mActivitiesButton.setEnabled(true);
            this.mActivitiesButton.setOnClickListener((View.OnClickListener)this);
        }
        LinearLayout permsView = (LinearLayout)this.findViewById(2131427405);
        AppSecurityPermissions asp = new AppSecurityPermissions((Context)this, packageName);
        if (asp.getPermissionCount() > 0) {
            permsView.setVisibility(0);
            LinearLayout securityList = (LinearLayout)permsView.findViewById(2131427406);
            securityList.removeAllViews();
            securityList.addView(asp.getPermissionsView());
        } else {
            permsView.setVisibility(8);
        }
        this.checkForceStop();
        this.setAppLabelAndIcon(this.mPackageInfo);
        this.refreshButtons();
        this.refreshSizeInfo();
        return true;
    }

    private void setIntentAndFinish(boolean finish, boolean appChanged) {
        Intent intent = new Intent();
        intent.putExtra("chg", appChanged);
        this.setResult(-1, intent);
        if (finish) {
            this.finish();
        }
    }

    private void refreshSizeInfo() {
        if (this.mAppEntry.size == -2L || this.mAppEntry.size == -1L) {
            this.mLastTotalSize = -1L;
            this.mLastCacheSize = -1L;
            this.mLastDataSize = -1L;
            this.mLastCodeSize = -1L;
            if (!this.mHaveSizes) {
                this.mAppSize.setText(this.mComputingStr);
                this.mDataSize.setText(this.mComputingStr);
                this.mCacheSize.setText(this.mComputingStr);
                this.mTotalSize.setText(this.mComputingStr);
            }
            this.mClearDataButton.setEnabled(false);
            this.mClearCacheButton.setEnabled(false);
        } else {
            this.mHaveSizes = true;
            if (this.mLastCodeSize != this.mAppEntry.codeSize) {
                this.mLastCodeSize = this.mAppEntry.codeSize;
                this.mAppSize.setText((CharSequence)this.getSizeStr(this.mAppEntry.codeSize));
            }
            if (this.mLastDataSize != this.mAppEntry.dataSize) {
                this.mLastDataSize = this.mAppEntry.dataSize;
                this.mDataSize.setText((CharSequence)this.getSizeStr(this.mAppEntry.dataSize));
            }
            if (this.mLastCacheSize != this.mAppEntry.cacheSize) {
                this.mLastCacheSize = this.mAppEntry.cacheSize;
                this.mCacheSize.setText((CharSequence)this.getSizeStr(this.mAppEntry.cacheSize));
            }
            if (this.mLastTotalSize != this.mAppEntry.size) {
                this.mLastTotalSize = this.mAppEntry.size;
                this.mTotalSize.setText((CharSequence)this.getSizeStr(this.mAppEntry.size));
            }
            if (this.mAppEntry.dataSize <= 0L || !this.mCanClearData) {
                this.mClearDataButton.setEnabled(false);
            } else {
                this.mClearDataButton.setEnabled(true);
                this.mClearDataButton.setOnClickListener((View.OnClickListener)this);
            }
            if (this.mAppEntry.cacheSize <= 0L) {
                this.mClearCacheButton.setEnabled(false);
            } else {
                this.mClearCacheButton.setEnabled(true);
                this.mClearCacheButton.setOnClickListener((View.OnClickListener)this);
            }
        }
    }

    private void processClearMsg(Message msg) {
        int result = msg.arg1;
        String packageName = this.mAppEntry.info.packageName;
        this.mClearDataButton.setText(2131231459);
        if (result == 1) {
            Log.i((String)TAG, (String)("Cleared user data for package : " + packageName));
            this.mState.requestSize(this.mAppEntry.info.packageName);
        } else {
            this.mClearDataButton.setEnabled(true);
        }
        this.checkForceStop();
    }

    private void refreshButtons() {
        if (!this.mMoveInProgress) {
            this.initUninstallButtons();
            this.initDataButtons();
            this.initMoveButton();
        } else {
            this.mMoveAppButton.setText(2131231500);
            this.mMoveAppButton.setEnabled(false);
            this.mUninstallButton.setEnabled(false);
        }
    }

    private void processMoveMsg(Message msg) {
        int result = msg.arg1;
        String packageName = this.mAppEntry.info.packageName;
        this.mMoveInProgress = false;
        if (result == 1) {
            Log.i((String)TAG, (String)("Moved resources for " + packageName));
            this.mState.requestSize(this.mAppEntry.info.packageName);
        } else {
            this.mMoveErrorCode = result;
            this.showDialogInner(6);
        }
        this.refreshUi();
    }

    private void initiateClearUserData() {
        ActivityManager am;
        boolean res;
        this.mClearDataButton.setEnabled(false);
        String packageName = this.mAppEntry.info.packageName;
        Log.i((String)TAG, (String)("Clearing user data for package : " + packageName));
        if (this.mClearDataObserver == null) {
            this.mClearDataObserver = new ClearUserDataObserver();
        }
        if (!(res = (am = (ActivityManager)this.getSystemService("activity")).clearApplicationUserData(packageName, (IPackageDataObserver)this.mClearDataObserver))) {
            Log.i((String)TAG, (String)("Couldnt clear application user data for package:" + packageName));
            this.showDialogInner(4);
        } else {
            this.mClearDataButton.setText(2131231480);
        }
    }

    private void showDialogInner(int id2) {
        this.showDialog(id2);
    }

    public Dialog onCreateDialog(int id2, Bundle args) {
        switch (id2) {
            case 1: {
                return new AlertDialog.Builder((Context)this).setTitle((CharSequence)this.getString(2131231481)).setIcon(17301543).setMessage((CharSequence)this.getString(2131231482)).setPositiveButton(2131231483, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        InstalledAppDetails.this.initiateClearUserData();
                    }
                }).setNegativeButton(2131231484, null).create();
            }
            case 2: {
                return new AlertDialog.Builder((Context)this).setTitle((CharSequence)this.getString(2131231488)).setIcon(17301543).setMessage((CharSequence)this.getString(2131231489)).setPositiveButton(2131231483, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        InstalledAppDetails.this.uninstallPkg(((InstalledAppDetails)InstalledAppDetails.this).mAppEntry.info.packageName);
                    }
                }).setNegativeButton(2131231484, null).create();
            }
            case 3: {
                return new AlertDialog.Builder((Context)this).setTitle((CharSequence)this.getString(2131231485)).setIcon(17301543).setMessage((CharSequence)this.getString(2131231485)).setNeutralButton((CharSequence)this.getString(2131231483), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        InstalledAppDetails.this.setIntentAndFinish(true, true);
                    }
                }).create();
            }
            case 4: {
                return new AlertDialog.Builder((Context)this).setTitle((CharSequence)this.getString(2131231490)).setIcon(17301543).setMessage((CharSequence)this.getString(2131231491)).setNeutralButton(2131231483, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        InstalledAppDetails.this.mClearDataButton.setEnabled(false);
                        InstalledAppDetails.this.setIntentAndFinish(false, false);
                    }
                }).create();
            }
            case 5: {
                return new AlertDialog.Builder((Context)this).setTitle((CharSequence)this.getString(2131231506)).setIcon(17301543).setMessage((CharSequence)this.getString(2131231507)).setPositiveButton(2131231483, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        InstalledAppDetails.this.forceStopPackage(((InstalledAppDetails)InstalledAppDetails.this).mAppEntry.info.packageName);
                    }
                }).setNegativeButton(2131231484, null).create();
            }
            case 6: {
                String msg = this.getString(2131231509, new Object[]{this.getMoveErrMsg(this.mMoveErrorCode)});
                return new AlertDialog.Builder((Context)this).setTitle((CharSequence)this.getString(2131231508)).setIcon(17301543).setMessage((CharSequence)msg).setNeutralButton(2131231483, null).create();
            }
        }
        return null;
    }

    private void uninstallPkg(String packageName) {
        Uri packageURI = Uri.parse((String)("package:" + packageName));
        Intent uninstallIntent = new Intent("android.intent.action.DELETE", packageURI);
        this.startActivity(uninstallIntent);
        this.setIntentAndFinish(true, true);
    }

    private void forceStopPackage(String pkgName) {
        ActivityManager am = (ActivityManager)this.getSystemService("activity");
        am.forceStopPackage(pkgName);
        this.checkForceStop();
    }

    private void checkForceStop() {
        Intent intent = new Intent("android.intent.action.QUERY_PACKAGE_RESTART", Uri.fromParts((String)"package", (String)this.mAppEntry.info.packageName, null));
        intent.putExtra("android.intent.extra.PACKAGES", new String[]{this.mAppEntry.info.packageName});
        intent.putExtra("android.intent.extra.UID", this.mAppEntry.info.uid);
        this.sendOrderedBroadcast(intent, null, this.mCheckKillProcessesReceiver, null, 0, null, null);
    }

    public void onClick(View v) {
        String packageName = this.mAppEntry.info.packageName;
        if (v == this.mUninstallButton) {
            if (this.mUpdatedSysApp) {
                this.showDialogInner(2);
            } else if ((this.mAppEntry.info.flags & 1) != 0) {
                new DisableChanger(this, this.mAppEntry.info, this.mAppEntry.info.enabled ? 2 : 0).execute(new Object[]{null});
            } else {
                this.uninstallPkg(packageName);
            }
        } else if (v == this.mActivitiesButton) {
            this.mPm.clearPackagePreferredActivities(packageName);
            try {
                this.mUsbManager.clearDefaults(packageName);
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)"mUsbManager.clearDefaults", (Throwable)e);
            }
            this.mActivitiesButton.setEnabled(false);
        } else if (v == this.mClearDataButton) {
            if (this.mAppEntry.info.manageSpaceActivityName != null) {
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setClassName(this.mAppEntry.info.packageName, this.mAppEntry.info.manageSpaceActivityName);
                this.startActivityForResult(intent, -1);
            } else {
                this.showDialogInner(1);
            }
        } else if (v == this.mClearCacheButton) {
            if (this.mClearCacheObserver == null) {
                this.mClearCacheObserver = new ClearCacheObserver();
            }
            this.mPm.deleteApplicationCacheFiles(packageName, (IPackageDataObserver)this.mClearCacheObserver);
        } else if (v == this.mForceStopButton) {
            this.showDialogInner(5);
        } else if (v == this.mMoveAppButton) {
            if (this.mPackageMoveObserver == null) {
                this.mPackageMoveObserver = new PackageMoveObserver();
            }
            int moveFlags = (this.mAppEntry.info.flags & 0x40000) != 0 ? 1 : 2;
            this.mMoveInProgress = true;
            this.refreshButtons();
            this.mPm.movePackage(this.mAppEntry.info.packageName, (IPackageMoveObserver)this.mPackageMoveObserver, moveFlags);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DisableChanger
    extends AsyncTask<Object, Object, Object> {
        final PackageManager mPm;
        final WeakReference<InstalledAppDetails> mActivity;
        final ApplicationInfo mInfo;
        final int mState;

        DisableChanger(InstalledAppDetails activity, ApplicationInfo info, int state) {
            this.mPm = activity.mPm;
            this.mActivity = new WeakReference<InstalledAppDetails>(activity);
            this.mInfo = info;
            this.mState = state;
        }

        protected Object doInBackground(Object ... params) {
            this.mPm.setApplicationEnabledSetting(this.mInfo.packageName, this.mState, 0);
            return null;
        }
    }

    class PackageMoveObserver
    extends IPackageMoveObserver.Stub {
        PackageMoveObserver() {
        }

        public void packageMoved(String packageName, int returnCode) throws RemoteException {
            Message msg = InstalledAppDetails.this.mHandler.obtainMessage(4);
            msg.arg1 = returnCode;
            InstalledAppDetails.this.mHandler.sendMessage(msg);
        }
    }

    class ClearCacheObserver
    extends IPackageDataObserver.Stub {
        ClearCacheObserver() {
        }

        public void onRemoveCompleted(String packageName, boolean succeeded) {
            Message msg = InstalledAppDetails.this.mHandler.obtainMessage(3);
            msg.arg1 = succeeded ? 1 : 2;
            InstalledAppDetails.this.mHandler.sendMessage(msg);
        }
    }

    class ClearUserDataObserver
    extends IPackageDataObserver.Stub {
        ClearUserDataObserver() {
        }

        public void onRemoveCompleted(String packageName, boolean succeeded) {
            Message msg = InstalledAppDetails.this.mHandler.obtainMessage(1);
            msg.arg1 = succeeded ? 1 : 2;
            InstalledAppDetails.this.mHandler.sendMessage(msg);
        }
    }
}

