/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.applications;

import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;

final class CanBeOnSdCardChecker {
    final IPackageManager mPm = IPackageManager.Stub.asInterface((IBinder)ServiceManager.getService((String)"package"));
    int mInstallLocation;

    CanBeOnSdCardChecker() {
    }

    void init() {
        try {
            this.mInstallLocation = this.mPm.getInstallLocation();
        }
        catch (RemoteException e) {
            Log.e((String)"CanBeOnSdCardChecker", (String)"Is Package Manager running?");
            return;
        }
    }

    boolean check(ApplicationInfo info) {
        boolean canBe = false;
        if ((info.flags & 0x40000) != 0) {
            canBe = true;
        } else if ((info.flags & 0x20000000) == 0 && (info.flags & 1) == 0) {
            if (info.installLocation == 2 || info.installLocation == 0) {
                canBe = true;
            } else if (info.installLocation == -1 && this.mInstallLocation == 2) {
                canBe = true;
            }
        }
        return canBe;
    }
}

