/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.applications;

import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageStatsObserver;
import android.content.pm.PackageManager;
import android.content.pm.PackageStats;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.SystemClock;
import android.text.format.Formatter;
import com.android.settings.applications.CanBeOnSdCardChecker;
import java.io.File;
import java.text.Collator;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationsState {
    static final String TAG = "ApplicationsState";
    static final boolean DEBUG = false;
    static final boolean DEBUG_LOCKING = false;
    static final int SIZE_UNKNOWN = -1;
    static final int SIZE_INVALID = -2;
    static final Pattern REMOVE_DIACRITICALS_PATTERN = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
    public static final Comparator<AppEntry> ALPHA_COMPARATOR = new Comparator<AppEntry>(){
        private final Collator sCollator = Collator.getInstance();

        @Override
        public int compare(AppEntry object1, AppEntry object2) {
            return this.sCollator.compare(object1.label, object2.label);
        }
    };
    public static final Comparator<AppEntry> SIZE_COMPARATOR = new Comparator<AppEntry>(){
        private final Collator sCollator = Collator.getInstance();

        @Override
        public int compare(AppEntry object1, AppEntry object2) {
            if (object1.size < object2.size) {
                return 1;
            }
            if (object1.size > object2.size) {
                return -1;
            }
            return this.sCollator.compare(object1.label, object2.label);
        }
    };
    public static final AppFilter THIRD_PARTY_FILTER = new AppFilter(){

        public void init() {
        }

        public boolean filterApp(ApplicationInfo info) {
            if ((info.flags & 0x80) != 0) {
                return true;
            }
            return (info.flags & 1) == 0;
        }
    };
    public static final AppFilter ON_SD_CARD_FILTER = new AppFilter(){
        final CanBeOnSdCardChecker mCanBeOnSdCardChecker = new CanBeOnSdCardChecker();

        public void init() {
            this.mCanBeOnSdCardChecker.init();
        }

        public boolean filterApp(ApplicationInfo info) {
            return this.mCanBeOnSdCardChecker.check(info);
        }
    };
    final Context mContext;
    final PackageManager mPm;
    PackageIntentReceiver mPackageIntentReceiver;
    boolean mResumed;
    Callbacks mCurCallbacks;
    final HashMap<String, AppEntry> mEntriesMap = new HashMap();
    final ArrayList<AppEntry> mAppEntries = new ArrayList();
    List<ApplicationInfo> mApplications = new ArrayList<ApplicationInfo>();
    long mCurId = 1L;
    String mCurComputingSizePkg;
    final Object mRebuildSync = new Object();
    boolean mRebuildRequested;
    boolean mRebuildAsync;
    AppFilter mRebuildFilter;
    Comparator<AppEntry> mRebuildComparator;
    ArrayList<AppEntry> mRebuildResult;
    final MainHandler mMainHandler = new MainHandler();
    static final Object sLock = new Object();
    static ApplicationsState sInstance;
    final HandlerThread mThread;
    final BackgroundHandler mBackgroundHandler;

    public static String normalize(String str) {
        String tmp = Normalizer.normalize(str, Normalizer.Form.NFD);
        return REMOVE_DIACRITICALS_PATTERN.matcher(tmp).replaceAll("").toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ApplicationsState getInstance(Application app) {
        Object object = sLock;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new ApplicationsState(app);
            }
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApplicationsState(Application app) {
        this.mContext = app;
        this.mPm = this.mContext.getPackageManager();
        this.mThread = new HandlerThread("ApplicationsState.Loader", 10);
        this.mThread.start();
        this.mBackgroundHandler = new BackgroundHandler(this.mThread.getLooper());
        HashMap<String, AppEntry> hashMap = this.mEntriesMap;
        synchronized (hashMap) {
            try {
                this.mEntriesMap.wait(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resume(Callbacks callbacks) {
        HashMap<String, AppEntry> hashMap = this.mEntriesMap;
        synchronized (hashMap) {
            int i;
            this.mCurCallbacks = callbacks;
            this.mResumed = true;
            if (this.mPackageIntentReceiver == null) {
                this.mPackageIntentReceiver = new PackageIntentReceiver();
                this.mPackageIntentReceiver.registerReceiver();
            }
            this.mApplications = this.mPm.getInstalledApplications(8704);
            if (this.mApplications == null) {
                this.mApplications = new ArrayList<ApplicationInfo>();
            }
            for (i = 0; i < this.mAppEntries.size(); ++i) {
                this.mAppEntries.get((int)i).sizeStale = true;
            }
            for (i = 0; i < this.mApplications.size(); ++i) {
                ApplicationInfo info = this.mApplications.get(i);
                AppEntry entry = this.mEntriesMap.get(info.packageName);
                if (entry == null) continue;
                entry.info = info;
            }
            this.mCurComputingSizePkg = null;
            if (!this.mBackgroundHandler.hasMessages(2)) {
                this.mBackgroundHandler.sendEmptyMessage(2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pause() {
        HashMap<String, AppEntry> hashMap = this.mEntriesMap;
        synchronized (hashMap) {
            this.mCurCallbacks = null;
            this.mResumed = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<AppEntry> rebuild(AppFilter filter, Comparator<AppEntry> comparator) {
        Object object = this.mRebuildSync;
        synchronized (object) {
            long now;
            this.mRebuildRequested = true;
            this.mRebuildAsync = false;
            this.mRebuildFilter = filter;
            this.mRebuildComparator = comparator;
            this.mRebuildResult = null;
            if (!this.mBackgroundHandler.hasMessages(1)) {
                this.mBackgroundHandler.sendEmptyMessage(1);
            }
            long waitend = SystemClock.uptimeMillis() + 250L;
            while (this.mRebuildResult == null && (now = SystemClock.uptimeMillis()) < waitend) {
                try {
                    this.mRebuildSync.wait(waitend - now);
                }
                catch (InterruptedException e) {}
            }
            this.mRebuildAsync = true;
            return this.mRebuildResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleRebuildList() {
        ArrayList<ApplicationInfo> apps;
        Comparator<AppEntry> comparator;
        AppFilter filter;
        Object object = this.mRebuildSync;
        synchronized (object) {
            if (!this.mRebuildRequested) {
                return;
            }
            filter = this.mRebuildFilter;
            comparator = this.mRebuildComparator;
            this.mRebuildRequested = false;
            this.mRebuildFilter = null;
            this.mRebuildComparator = null;
        }
        Process.setThreadPriority((int)-2);
        if (filter != null) {
            filter.init();
        }
        HashMap<String, AppEntry> hashMap = this.mEntriesMap;
        synchronized (hashMap) {
            apps = new ArrayList<ApplicationInfo>(this.mApplications);
        }
        ArrayList<AppEntry> filteredApps = new ArrayList<AppEntry>();
        for (int i = 0; i < apps.size(); ++i) {
            ApplicationInfo info = (ApplicationInfo)apps.get(i);
            if (filter != null && !filter.filterApp(info)) continue;
            HashMap<String, AppEntry> hashMap2 = this.mEntriesMap;
            synchronized (hashMap2) {
                AppEntry entry = this.getEntryLocked(info);
                entry.ensureLabel(this.mContext);
                filteredApps.add(entry);
                continue;
            }
        }
        Collections.sort(filteredApps, comparator);
        Object object2 = this.mRebuildSync;
        synchronized (object2) {
            if (!this.mRebuildRequested) {
                if (!this.mRebuildAsync) {
                    this.mRebuildResult = filteredApps;
                    this.mRebuildSync.notifyAll();
                } else if (!this.mMainHandler.hasMessages(1)) {
                    Message msg = this.mMainHandler.obtainMessage(1, filteredApps);
                    this.mMainHandler.sendMessage(msg);
                }
            }
        }
        Process.setThreadPriority((int)10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AppEntry getEntry(String packageName) {
        HashMap<String, AppEntry> hashMap = this.mEntriesMap;
        synchronized (hashMap) {
            AppEntry entry = this.mEntriesMap.get(packageName);
            if (entry == null) {
                for (int i = 0; i < this.mApplications.size(); ++i) {
                    ApplicationInfo info = this.mApplications.get(i);
                    if (!packageName.equals(info.packageName)) continue;
                    entry = this.getEntryLocked(info);
                    break;
                }
            }
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureIcon(AppEntry entry) {
        if (entry.icon != null) {
            return;
        }
        AppEntry appEntry = entry;
        synchronized (appEntry) {
            entry.ensureIconLocked(this.mContext, this.mPm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestSize(String packageName) {
        HashMap<String, AppEntry> hashMap = this.mEntriesMap;
        synchronized (hashMap) {
            AppEntry entry = this.mEntriesMap.get(packageName);
            if (entry != null) {
                this.mPm.getPackageSizeInfo(packageName, (IPackageStatsObserver)this.mBackgroundHandler.mStatsObserver);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long sumCacheSizes() {
        long sum = 0L;
        HashMap<String, AppEntry> hashMap = this.mEntriesMap;
        synchronized (hashMap) {
            for (int i = this.mAppEntries.size() - 1; i >= 0; --i) {
                sum += this.mAppEntries.get((int)i).cacheSize;
            }
        }
        return sum;
    }

    int indexOfApplicationInfoLocked(String pkgName) {
        for (int i = this.mApplications.size() - 1; i >= 0; --i) {
            if (!this.mApplications.get((int)i).packageName.equals(pkgName)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPackage(String pkgName) {
        try {
            HashMap<String, AppEntry> hashMap = this.mEntriesMap;
            synchronized (hashMap) {
                if (!this.mResumed) {
                    return;
                }
                if (this.indexOfApplicationInfoLocked(pkgName) >= 0) {
                    return;
                }
                ApplicationInfo info = this.mPm.getApplicationInfo(pkgName, 8704);
                this.mApplications.add(info);
                if (!this.mBackgroundHandler.hasMessages(2)) {
                    this.mBackgroundHandler.sendEmptyMessage(2);
                }
                if (!this.mMainHandler.hasMessages(2)) {
                    this.mMainHandler.sendEmptyMessage(2);
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePackage(String pkgName) {
        HashMap<String, AppEntry> hashMap = this.mEntriesMap;
        synchronized (hashMap) {
            int idx = this.indexOfApplicationInfoLocked(pkgName);
            if (idx >= 0) {
                AppEntry entry = this.mEntriesMap.get(pkgName);
                if (entry != null) {
                    this.mEntriesMap.remove(pkgName);
                    this.mAppEntries.remove(entry);
                }
                this.mApplications.remove(idx);
                if (!this.mMainHandler.hasMessages(2)) {
                    this.mMainHandler.sendEmptyMessage(2);
                }
            }
        }
    }

    AppEntry getEntryLocked(ApplicationInfo info) {
        AppEntry entry = this.mEntriesMap.get(info.packageName);
        if (entry == null) {
            entry = new AppEntry(this.mContext, info, this.mCurId++);
            this.mEntriesMap.put(info.packageName, entry);
            this.mAppEntries.add(entry);
        } else if (entry.info != info) {
            entry.info = info;
        }
        return entry;
    }

    private long getTotalSize(PackageStats ps) {
        if (ps != null) {
            return ps.codeSize + ps.dataSize;
        }
        return -2L;
    }

    private String getSizeStr(long size) {
        if (size >= 0L) {
            return Formatter.formatFileSize((Context)this.mContext, (long)size);
        }
        return null;
    }

    class BackgroundHandler
    extends Handler {
        static final int MSG_REBUILD_LIST = 1;
        static final int MSG_LOAD_ENTRIES = 2;
        static final int MSG_LOAD_ICONS = 3;
        static final int MSG_LOAD_SIZES = 4;
        boolean mRunning;
        final IPackageStatsObserver.Stub mStatsObserver;

        BackgroundHandler(Looper looper) {
            super(looper);
            this.mStatsObserver = new IPackageStatsObserver.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onGetStatsCompleted(PackageStats stats, boolean succeeded) {
                    boolean sizeChanged = false;
                    HashMap<String, AppEntry> hashMap = ApplicationsState.this.mEntriesMap;
                    synchronized (hashMap) {
                        AppEntry entry = ApplicationsState.this.mEntriesMap.get(stats.packageName);
                        if (entry != null) {
                            AppEntry appEntry = entry;
                            synchronized (appEntry) {
                                entry.sizeStale = false;
                                entry.sizeLoadStart = 0L;
                                long newSize = ApplicationsState.this.getTotalSize(stats);
                                if (entry.size != newSize || entry.cacheSize != stats.cacheSize || entry.codeSize != stats.codeSize || entry.dataSize != stats.dataSize) {
                                    entry.size = newSize;
                                    entry.cacheSize = stats.cacheSize;
                                    entry.codeSize = stats.codeSize;
                                    entry.dataSize = stats.dataSize;
                                    entry.sizeStr = ApplicationsState.this.getSizeStr(entry.size);
                                    sizeChanged = true;
                                }
                            }
                            if (sizeChanged) {
                                Message msg = ApplicationsState.this.mMainHandler.obtainMessage(4, stats.packageName);
                                ApplicationsState.this.mMainHandler.sendMessage(msg);
                            }
                        }
                        if (ApplicationsState.this.mCurComputingSizePkg == null || ApplicationsState.this.mCurComputingSizePkg.equals(stats.packageName)) {
                            ApplicationsState.this.mCurComputingSizePkg = null;
                            BackgroundHandler.this.sendEmptyMessage(4);
                        }
                    }
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            ApplicationsState.this.handleRebuildList();
            switch (msg.what) {
                case 1: {
                    break;
                }
                case 2: {
                    int numDone = 0;
                    HashMap<String, AppEntry> hashMap = ApplicationsState.this.mEntriesMap;
                    synchronized (hashMap) {
                        for (int i = 0; i < ApplicationsState.this.mApplications.size() && numDone < 6; ++i) {
                            if (!this.mRunning) {
                                this.mRunning = true;
                                Message m = ApplicationsState.this.mMainHandler.obtainMessage(6, 1);
                                ApplicationsState.this.mMainHandler.sendMessage(m);
                            }
                            ApplicationInfo info = ApplicationsState.this.mApplications.get(i);
                            if (ApplicationsState.this.mEntriesMap.get(info.packageName) != null) continue;
                            ++numDone;
                            ApplicationsState.this.getEntryLocked(info);
                        }
                    }
                    if (numDone >= 6) {
                        this.sendEmptyMessage(2);
                        break;
                    }
                    this.sendEmptyMessage(3);
                    break;
                }
                case 3: {
                    int numDone = 0;
                    HashMap<String, AppEntry> hashMap = ApplicationsState.this.mEntriesMap;
                    synchronized (hashMap) {
                        for (int i = 0; i < ApplicationsState.this.mAppEntries.size() && numDone < 2; ++i) {
                            AppEntry entry = ApplicationsState.this.mAppEntries.get(i);
                            if (entry.icon != null && entry.mounted) continue;
                            AppEntry appEntry = entry;
                            synchronized (appEntry) {
                                if (entry.ensureIconLocked(ApplicationsState.this.mContext, ApplicationsState.this.mPm)) {
                                    if (!this.mRunning) {
                                        this.mRunning = true;
                                        Message m = ApplicationsState.this.mMainHandler.obtainMessage(6, 1);
                                        ApplicationsState.this.mMainHandler.sendMessage(m);
                                    }
                                    ++numDone;
                                }
                                continue;
                            }
                        }
                    }
                    if (numDone > 0 && !ApplicationsState.this.mMainHandler.hasMessages(3)) {
                        ApplicationsState.this.mMainHandler.sendEmptyMessage(3);
                    }
                    if (numDone >= 2) {
                        this.sendEmptyMessage(3);
                        break;
                    }
                    this.sendEmptyMessage(4);
                    break;
                }
                case 4: {
                    HashMap<String, AppEntry> hashMap = ApplicationsState.this.mEntriesMap;
                    synchronized (hashMap) {
                        if (ApplicationsState.this.mCurComputingSizePkg != null) {
                            return;
                        }
                        long now = SystemClock.uptimeMillis();
                        for (int i = 0; i < ApplicationsState.this.mAppEntries.size(); ++i) {
                            AppEntry entry = ApplicationsState.this.mAppEntries.get(i);
                            if (entry.size != -1L && !entry.sizeStale) continue;
                            if (entry.sizeLoadStart == 0L || entry.sizeLoadStart < now - 20000L) {
                                if (!this.mRunning) {
                                    this.mRunning = true;
                                    Message m = ApplicationsState.this.mMainHandler.obtainMessage(6, 1);
                                    ApplicationsState.this.mMainHandler.sendMessage(m);
                                }
                                entry.sizeLoadStart = now;
                                ApplicationsState.this.mCurComputingSizePkg = entry.info.packageName;
                                ApplicationsState.this.mPm.getPackageSizeInfo(ApplicationsState.this.mCurComputingSizePkg, (IPackageStatsObserver)this.mStatsObserver);
                            }
                            return;
                        }
                        if (!ApplicationsState.this.mMainHandler.hasMessages(5)) {
                            ApplicationsState.this.mMainHandler.sendEmptyMessage(5);
                            this.mRunning = false;
                            Message m = ApplicationsState.this.mMainHandler.obtainMessage(6, 0);
                            ApplicationsState.this.mMainHandler.sendMessage(m);
                        }
                        break;
                    }
                }
            }
        }
    }

    class MainHandler
    extends Handler {
        static final int MSG_REBUILD_COMPLETE = 1;
        static final int MSG_PACKAGE_LIST_CHANGED = 2;
        static final int MSG_PACKAGE_ICON_CHANGED = 3;
        static final int MSG_PACKAGE_SIZE_CHANGED = 4;
        static final int MSG_ALL_SIZES_COMPUTED = 5;
        static final int MSG_RUNNING_STATE_CHANGED = 6;

        MainHandler() {
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    if (ApplicationsState.this.mCurCallbacks == null) break;
                    ApplicationsState.this.mCurCallbacks.onRebuildComplete((ArrayList)msg.obj);
                    break;
                }
                case 2: {
                    if (ApplicationsState.this.mCurCallbacks == null) break;
                    ApplicationsState.this.mCurCallbacks.onPackageListChanged();
                    break;
                }
                case 3: {
                    if (ApplicationsState.this.mCurCallbacks == null) break;
                    ApplicationsState.this.mCurCallbacks.onPackageIconChanged();
                    break;
                }
                case 4: {
                    if (ApplicationsState.this.mCurCallbacks == null) break;
                    ApplicationsState.this.mCurCallbacks.onPackageSizeChanged((String)msg.obj);
                    break;
                }
                case 5: {
                    if (ApplicationsState.this.mCurCallbacks == null) break;
                    ApplicationsState.this.mCurCallbacks.onAllSizesComputed();
                    break;
                }
                case 6: {
                    if (ApplicationsState.this.mCurCallbacks == null) break;
                    ApplicationsState.this.mCurCallbacks.onRunningStateChanged(msg.arg1 != 0);
                }
            }
        }
    }

    private class PackageIntentReceiver
    extends BroadcastReceiver {
        private PackageIntentReceiver() {
        }

        void registerReceiver() {
            IntentFilter filter = new IntentFilter("android.intent.action.PACKAGE_ADDED");
            filter.addAction("android.intent.action.PACKAGE_REMOVED");
            filter.addAction("android.intent.action.PACKAGE_CHANGED");
            filter.addDataScheme("package");
            ApplicationsState.this.mContext.registerReceiver((BroadcastReceiver)this, filter);
            IntentFilter sdFilter = new IntentFilter();
            sdFilter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE");
            sdFilter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
            ApplicationsState.this.mContext.registerReceiver((BroadcastReceiver)this, sdFilter);
        }

        public void onReceive(Context context, Intent intent) {
            String actionStr = intent.getAction();
            if ("android.intent.action.PACKAGE_ADDED".equals(actionStr)) {
                Uri data = intent.getData();
                String pkgName = data.getEncodedSchemeSpecificPart();
                ApplicationsState.this.addPackage(pkgName);
            } else if ("android.intent.action.PACKAGE_REMOVED".equals(actionStr)) {
                Uri data = intent.getData();
                String pkgName = data.getEncodedSchemeSpecificPart();
                ApplicationsState.this.removePackage(pkgName);
            } else if ("android.intent.action.PACKAGE_CHANGED".equals(actionStr)) {
                Uri data = intent.getData();
                String pkgName = data.getEncodedSchemeSpecificPart();
                ApplicationsState.this.removePackage(pkgName);
                ApplicationsState.this.addPackage(pkgName);
            } else if ("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE".equals(actionStr) || "android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE".equals(actionStr)) {
                String[] pkgList = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                if (pkgList == null || pkgList.length == 0) {
                    return;
                }
                boolean avail = "android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE".equals(actionStr);
                if (avail) {
                    for (String pkgName : pkgList) {
                        ApplicationsState.this.removePackage(pkgName);
                        ApplicationsState.this.addPackage(pkgName);
                    }
                }
            }
        }
    }

    public static class AppEntry
    extends SizeInfo {
        final File apkFile;
        final long id;
        String label;
        long size;
        boolean mounted;
        ApplicationInfo info;
        Drawable icon;
        String sizeStr;
        boolean sizeStale;
        long sizeLoadStart;
        String normalizedLabel;

        String getNormalizedLabel() {
            if (this.normalizedLabel != null) {
                return this.normalizedLabel;
            }
            this.normalizedLabel = ApplicationsState.normalize(this.label);
            return this.normalizedLabel;
        }

        AppEntry(Context context, ApplicationInfo info, long id2) {
            this.apkFile = new File(info.sourceDir);
            this.id = id2;
            this.info = info;
            this.size = -1L;
            this.sizeStale = true;
            this.ensureLabel(context);
        }

        void ensureLabel(Context context) {
            if (this.label == null || !this.mounted) {
                if (!this.apkFile.exists()) {
                    this.mounted = false;
                    this.label = this.info.packageName;
                } else {
                    this.mounted = true;
                    CharSequence label = this.info.loadLabel(context.getPackageManager());
                    this.label = label != null ? ((Object)label).toString() : this.info.packageName;
                }
            }
        }

        boolean ensureIconLocked(Context context, PackageManager pm) {
            if (this.icon == null) {
                if (this.apkFile.exists()) {
                    this.icon = this.info.loadIcon(pm);
                    return true;
                }
                this.mounted = false;
                this.icon = context.getResources().getDrawable(17302249);
            } else if (!this.mounted && this.apkFile.exists()) {
                this.mounted = true;
                this.icon = this.info.loadIcon(pm);
                return true;
            }
            return false;
        }
    }

    public static class SizeInfo {
        long cacheSize;
        long codeSize;
        long dataSize;
    }

    public static interface AppFilter {
        public void init();

        public boolean filterApp(ApplicationInfo var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Callbacks {
        public void onRunningStateChanged(boolean var1);

        public void onPackageListChanged();

        public void onRebuildComplete(ArrayList<AppEntry> var1);

        public void onPackageIconChanged();

        public void onPackageSizeChanged(String var1);

        public void onAllSizesComputed();
    }
}

