/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.app.AlarmManager;
import android.app.ListActivity;
import android.content.Context;
import android.content.res.XmlResourceParser;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.SimpleAdapter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZoneList
extends ListActivity {
    private static final String TAG = "ZoneList";
    private static final String KEY_ID = "id";
    private static final String KEY_DISPLAYNAME = "name";
    private static final String KEY_GMT = "gmt";
    private static final String KEY_OFFSET = "offset";
    private static final String XMLTAG_TIMEZONE = "timezone";
    private static final int HOURS_1 = 3600000;
    private static final int HOURS_24 = 86400000;
    private static final int HOURS_HALF = 1800000;
    private static final int MENU_TIMEZONE = 2;
    private static final int MENU_ALPHABETICAL = 1;
    private int mDefault;
    private boolean mSortedByTimezone;
    private SimpleAdapter mTimezoneSortedAdapter;
    private SimpleAdapter mAlphabeticalAdapter;

    public void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        String[] from = new String[]{KEY_DISPLAYNAME, KEY_GMT};
        int[] to = new int[]{16908308, 16908309};
        MyComparator comparator = new MyComparator(KEY_OFFSET);
        List<HashMap> timezoneSortedList = this.getZones();
        Collections.sort(timezoneSortedList, comparator);
        this.mTimezoneSortedAdapter = new SimpleAdapter((Context)this, timezoneSortedList, 17367044, from, to);
        ArrayList<HashMap> alphabeticalList = new ArrayList<HashMap>(timezoneSortedList);
        comparator.setSortingKey(KEY_DISPLAYNAME);
        Collections.sort(alphabeticalList, comparator);
        this.mAlphabeticalAdapter = new SimpleAdapter((Context)this, alphabeticalList, 17367044, from, to);
        this.setSorting(true);
        this.setSelection(this.mDefault);
        this.setResult(0);
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        menu.add(0, 1, 0, 2131230949).setIcon(17301660);
        menu.add(0, 2, 0, 2131230950).setIcon(2130837545);
        return true;
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        if (this.mSortedByTimezone) {
            menu.findItem(2).setVisible(false);
            menu.findItem(1).setVisible(true);
        } else {
            menu.findItem(2).setVisible(true);
            menu.findItem(1).setVisible(false);
        }
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2: {
                this.setSorting(true);
                return true;
            }
            case 1: {
                this.setSorting(false);
                return true;
            }
        }
        return false;
    }

    private void setSorting(boolean timezone) {
        this.setListAdapter((ListAdapter)(timezone ? this.mTimezoneSortedAdapter : this.mAlphabeticalAdapter));
        this.mSortedByTimezone = timezone;
    }

    private List<HashMap> getZones() {
        ArrayList<HashMap> myData = new ArrayList<HashMap>();
        long date = Calendar.getInstance().getTimeInMillis();
        try {
            XmlResourceParser xrp = this.getResources().getXml(2130968609);
            while (xrp.next() != 2) {
            }
            xrp.next();
            while (xrp.getEventType() != 3) {
                while (xrp.getEventType() != 2) {
                    if (xrp.getEventType() == 1) {
                        return myData;
                    }
                    xrp.next();
                }
                if (xrp.getName().equals(XMLTAG_TIMEZONE)) {
                    String id2 = xrp.getAttributeValue(0);
                    String displayName = xrp.nextText();
                    this.addItem(myData, id2, displayName, date);
                }
                while (xrp.getEventType() != 3) {
                    xrp.next();
                }
                xrp.next();
            }
            xrp.close();
        }
        catch (XmlPullParserException xppe) {
            Log.e((String)TAG, (String)"Ill-formatted timezones.xml file");
        }
        catch (IOException ioe) {
            Log.e((String)TAG, (String)"Unable to read timezones.xml file");
        }
        return myData;
    }

    protected void addItem(List<HashMap> myData, String id2, String displayName, long date) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(KEY_ID, id2);
        map.put(KEY_DISPLAYNAME, displayName);
        TimeZone tz = TimeZone.getTimeZone(id2);
        int offset = tz.getOffset(date);
        int p = Math.abs(offset);
        StringBuilder name = new StringBuilder();
        name.append("GMT");
        if (offset < 0) {
            name.append('-');
        } else {
            name.append('+');
        }
        name.append(p / 3600000);
        name.append(':');
        int min = p / 60000;
        if ((min %= 60) < 10) {
            name.append('0');
        }
        name.append(min);
        map.put(KEY_GMT, name.toString());
        map.put(KEY_OFFSET, offset);
        if (id2.equals(TimeZone.getDefault().getID())) {
            this.mDefault = myData.size();
        }
        myData.add(map);
    }

    protected void onListItemClick(ListView l, View v, int position, long id2) {
        Map map = (Map)l.getItemAtPosition(position);
        AlarmManager alarm = (AlarmManager)this.getSystemService("alarm");
        alarm.setTimeZone((String)map.get(KEY_ID));
        this.setResult(-1);
        this.finish();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyComparator
    implements Comparator<HashMap> {
        private String mSortingKey;

        public MyComparator(String sortingKey) {
            this.mSortingKey = sortingKey;
        }

        public void setSortingKey(String sortingKey) {
            this.mSortingKey = sortingKey;
        }

        @Override
        public int compare(HashMap map1, HashMap map2) {
            Object value1 = map1.get(this.mSortingKey);
            Object value2 = map2.get(this.mSortingKey);
            if (!this.isComparable(value1)) {
                return this.isComparable(value2) ? 1 : 0;
            }
            if (!this.isComparable(value2)) {
                return -1;
            }
            return ((Comparable)value1).compareTo(value2);
        }

        private boolean isComparable(Object value) {
            return value != null && value instanceof Comparable;
        }
    }
}

