/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.nfc.NfcAdapter;
import android.os.Bundle;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.preference.CheckBoxPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceScreen;
import android.provider.Settings;
import com.android.settings.AirplaneModeEnabler;
import com.android.settings.bluetooth.BluetoothEnabler;
import com.android.settings.nfc.NfcEnabler;
import com.android.settings.wifi.WifiEnabler;

public class WirelessSettings
extends PreferenceActivity {
    private static final String KEY_TOGGLE_AIRPLANE = "toggle_airplane";
    private static final String KEY_TOGGLE_BLUETOOTH = "toggle_bluetooth";
    private static final String KEY_TOGGLE_WIFI = "toggle_wifi";
    private static final String KEY_TOGGLE_NFC = "toggle_nfc";
    private static final String KEY_WIFI_SETTINGS = "wifi_settings";
    private static final String KEY_WIMAX_SETTINGS = "wimax_settings";
    private static final String KEY_BT_SETTINGS = "bt_settings";
    private static final String KEY_VPN_SETTINGS = "vpn_settings";
    private static final String KEY_TETHER_SETTINGS = "tether_settings";
    public static final String EXIT_ECM_RESULT = "exit_ecm_result";
    public static final int REQUEST_CODE_EXIT_ECM = 1;
    private AirplaneModeEnabler mAirplaneModeEnabler;
    private CheckBoxPreference mAirplaneModePreference;
    private WifiEnabler mWifiEnabler;
    private NfcEnabler mNfcEnabler;
    private BluetoothEnabler mBtEnabler;

    public boolean onPreferenceTreeClick(PreferenceScreen preferenceScreen, Preference preference) {
        if (preference == this.mAirplaneModePreference && Boolean.parseBoolean(SystemProperties.get((String)"ril.cdma.inecmmode"))) {
            this.startActivityForResult(new Intent("android.intent.action.ACTION_SHOW_NOTICE_ECM_BLOCK_OTHERS", null), 1);
            return true;
        }
        return false;
    }

    public static boolean isRadioAllowed(Context context, String type) {
        if (!AirplaneModeEnabler.isAirplaneModeOn(context)) {
            return true;
        }
        String toggleable = Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"airplane_mode_toggleable_radios");
        return toggleable != null && toggleable.contains(type);
    }

    protected void onCreate(Bundle savedInstanceState) {
        ConnectivityManager cm;
        super.onCreate(savedInstanceState);
        this.addPreferencesFromResource(2130968619);
        CheckBoxPreference airplane = (CheckBoxPreference)this.findPreference(KEY_TOGGLE_AIRPLANE);
        CheckBoxPreference wifi = (CheckBoxPreference)this.findPreference(KEY_TOGGLE_WIFI);
        CheckBoxPreference bt = (CheckBoxPreference)this.findPreference(KEY_TOGGLE_BLUETOOTH);
        CheckBoxPreference nfc = (CheckBoxPreference)this.findPreference(KEY_TOGGLE_NFC);
        this.mAirplaneModeEnabler = new AirplaneModeEnabler((Context)this, airplane);
        this.mAirplaneModePreference = (CheckBoxPreference)this.findPreference(KEY_TOGGLE_AIRPLANE);
        this.mWifiEnabler = new WifiEnabler((Context)this, wifi);
        this.mBtEnabler = new BluetoothEnabler((Context)this, bt);
        this.mNfcEnabler = new NfcEnabler((Context)this, nfc);
        String toggleable = Settings.System.getString((ContentResolver)this.getContentResolver(), (String)"airplane_mode_toggleable_radios");
        boolean isWimaxEnabled = this.getResources().getBoolean(17629210);
        if (!isWimaxEnabled) {
            PreferenceScreen root = this.getPreferenceScreen();
            Preference ps = this.findPreference(KEY_WIMAX_SETTINGS);
            if (ps != null) {
                root.removePreference(ps);
            }
        } else if (toggleable == null || !toggleable.contains("wimax") && isWimaxEnabled) {
            Preference ps = this.findPreference(KEY_WIMAX_SETTINGS);
            ps.setDependency(KEY_TOGGLE_AIRPLANE);
        }
        if (toggleable == null || !toggleable.contains("wifi")) {
            wifi.setDependency(KEY_TOGGLE_AIRPLANE);
            this.findPreference(KEY_WIFI_SETTINGS).setDependency(KEY_TOGGLE_AIRPLANE);
            this.findPreference(KEY_VPN_SETTINGS).setDependency(KEY_TOGGLE_AIRPLANE);
        }
        if (toggleable == null || !toggleable.contains("bluetooth")) {
            bt.setDependency(KEY_TOGGLE_AIRPLANE);
            this.findPreference(KEY_BT_SETTINGS).setDependency(KEY_TOGGLE_AIRPLANE);
        }
        if (ServiceManager.getService((String)"bluetooth") == null) {
            this.getPreferenceScreen().removePreference((Preference)bt);
        }
        if (NfcAdapter.getDefaultAdapter((Context)this) == null) {
            this.getPreferenceScreen().removePreference((Preference)nfc);
        }
        if (!(cm = (ConnectivityManager)this.getSystemService("connectivity")).isTetheringSupported()) {
            this.getPreferenceScreen().removePreference(this.findPreference(KEY_TETHER_SETTINGS));
        } else {
            String[] usbRegexs = cm.getTetherableUsbRegexs();
            String[] wifiRegexs = cm.getTetherableWifiRegexs();
            Preference p = this.findPreference(KEY_TETHER_SETTINGS);
            if (wifiRegexs.length == 0) {
                p.setTitle(2131231351);
                p.setSummary(2131231354);
            } else if (usbRegexs.length == 0) {
                p.setTitle(2131231352);
                p.setSummary(2131231355);
            } else {
                p.setTitle(2131231353);
                p.setSummary(2131231356);
            }
        }
    }

    protected void onResume() {
        super.onResume();
        this.mAirplaneModeEnabler.resume();
        this.mWifiEnabler.resume();
        this.mBtEnabler.resume();
        this.mNfcEnabler.resume();
    }

    protected void onPause() {
        super.onPause();
        this.mAirplaneModeEnabler.pause();
        this.mWifiEnabler.pause();
        this.mBtEnabler.pause();
        this.mNfcEnabler.pause();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1) {
            Boolean isChoiceYes = data.getBooleanExtra(EXIT_ECM_RESULT, false);
            this.mAirplaneModeEnabler.setAirplaneModeInECM(isChoiceYes, this.mAirplaneModePreference.isChecked());
        }
    }
}

