/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.Bundle;
import android.preference.ListPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceCategory;
import android.preference.PreferenceGroup;
import android.preference.PreferenceScreen;
import android.provider.Settings;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import com.android.internal.R;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VoiceInputOutputSettings
extends PreferenceActivity
implements Preference.OnPreferenceChangeListener {
    private static final String TAG = "VoiceInputOutputSettings";
    private static final String KEY_PARENT = "parent";
    private static final String KEY_VOICE_INPUT_CATEGORY = "voice_input_category";
    private static final String KEY_RECOGNIZER = "recognizer";
    private static final String KEY_RECOGNIZER_SETTINGS = "recognizer_settings";
    private PreferenceGroup mParent;
    private PreferenceCategory mVoiceInputCategory;
    private ListPreference mRecognizerPref;
    private PreferenceScreen mSettingsPref;
    private HashMap<String, ResolveInfo> mAvailableRecognizersMap;

    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.addPreferencesFromResource(2130968611);
        this.mParent = (PreferenceGroup)this.findPreference(KEY_PARENT);
        this.mVoiceInputCategory = (PreferenceCategory)this.mParent.findPreference((CharSequence)KEY_VOICE_INPUT_CATEGORY);
        this.mRecognizerPref = (ListPreference)this.mParent.findPreference((CharSequence)KEY_RECOGNIZER);
        this.mRecognizerPref.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
        this.mSettingsPref = (PreferenceScreen)this.mParent.findPreference((CharSequence)KEY_RECOGNIZER_SETTINGS);
        this.mAvailableRecognizersMap = new HashMap();
        this.populateOrRemoveRecognizerPreference();
    }

    private void populateOrRemoveRecognizerPreference() {
        List availableRecognitionServices = this.getPackageManager().queryIntentServices(new Intent("android.speech.RecognitionService"), 128);
        int numAvailable = availableRecognitionServices.size();
        if (numAvailable == 0) {
            this.removePreference((Preference)this.mVoiceInputCategory);
            this.removePreference((Preference)this.mRecognizerPref);
            this.removePreference((Preference)this.mSettingsPref);
        } else if (numAvailable == 1) {
            this.removePreference((Preference)this.mRecognizerPref);
            ResolveInfo resolveInfo = (ResolveInfo)availableRecognitionServices.get(0);
            String recognizerComponent = new ComponentName(resolveInfo.serviceInfo.packageName, resolveInfo.serviceInfo.name).flattenToShortString();
            this.mAvailableRecognizersMap.put(recognizerComponent, resolveInfo);
            String currentSetting = Settings.Secure.getString((ContentResolver)this.getContentResolver(), (String)"voice_recognition_service");
            this.updateSettingsLink(currentSetting);
        } else {
            this.populateRecognizerPreference(availableRecognitionServices);
        }
    }

    private void removePreference(Preference pref) {
        if (pref != null) {
            this.mParent.removePreference(pref);
        }
    }

    private void populateRecognizerPreference(List<ResolveInfo> recognizers) {
        int size = recognizers.size();
        CharSequence[] entries = new CharSequence[size];
        CharSequence[] values = new CharSequence[size];
        String currentSetting = Settings.Secure.getString((ContentResolver)this.getContentResolver(), (String)"voice_recognition_service");
        for (int i = 0; i < size; ++i) {
            ResolveInfo resolveInfo = recognizers.get(i);
            String recognizerComponent = new ComponentName(resolveInfo.serviceInfo.packageName, resolveInfo.serviceInfo.name).flattenToShortString();
            this.mAvailableRecognizersMap.put(recognizerComponent, resolveInfo);
            entries[i] = resolveInfo.loadLabel(this.getPackageManager());
            values[i] = recognizerComponent;
        }
        this.mRecognizerPref.setEntries(entries);
        this.mRecognizerPref.setEntryValues(values);
        this.mRecognizerPref.setDefaultValue((Object)currentSetting);
        this.mRecognizerPref.setValue(currentSetting);
        this.updateSettingsLink(currentSetting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSettingsLink(String currentSetting) {
        ResolveInfo currentRecognizer = this.mAvailableRecognizersMap.get(currentSetting);
        ServiceInfo si = currentRecognizer.serviceInfo;
        XmlResourceParser parser = null;
        String settingsActivity = null;
        try {
            int type;
            parser = si.loadXmlMetaData(this.getPackageManager(), "android.speech");
            if (parser == null) {
                throw new XmlPullParserException("No android.speech meta-data for " + si.packageName);
            }
            Resources res = this.getPackageManager().getResourcesForApplication(si.applicationInfo);
            AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String nodeName = parser.getName();
            if (!"recognition-service".equals(nodeName)) {
                throw new XmlPullParserException("Meta-data does not start with recognition-service tag");
            }
            TypedArray array2 = res.obtainAttributes(attrs, R.styleable.RecognitionService);
            settingsActivity = array2.getString(0);
            array2.recycle();
        }
        catch (XmlPullParserException e) {
            Log.e((String)TAG, (String)"error parsing recognition service meta-data", (Throwable)e);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"error parsing recognition service meta-data", (Throwable)e);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)"error parsing recognition service meta-data", (Throwable)e);
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
        if (settingsActivity == null) {
            Log.w((String)TAG, (String)("no recognizer settings available for " + si.packageName));
            this.mSettingsPref.setIntent(null);
            this.mParent.removePreference((Preference)this.mSettingsPref);
        } else {
            Intent i = new Intent("android.intent.action.MAIN");
            i.setComponent(new ComponentName(si.packageName, settingsActivity));
            this.mSettingsPref.setIntent(i);
            this.mRecognizerPref.setSummary(currentRecognizer.loadLabel(this.getPackageManager()));
        }
    }

    public boolean onPreferenceChange(Preference preference, Object newValue) {
        if (preference == this.mRecognizerPref) {
            String setting = (String)newValue;
            Settings.Secure.putString((ContentResolver)this.getContentResolver(), (String)"voice_recognition_service", (String)setting);
            this.updateSettingsLink(setting);
        }
        return true;
    }
}

