/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.SystemProperties;
import android.preference.Preference;
import android.preference.PreferenceGroup;
import java.util.List;

public class Utils {
    public static final int UPDATE_PREFERENCE_FLAG_SET_TITLE_TO_MATCHING_ACTIVITY = 1;

    public static boolean updatePreferenceToSpecificActivityOrRemove(Context context, PreferenceGroup parentPreferenceGroup, String preferenceKey, int flags) {
        Preference preference = parentPreferenceGroup.findPreference((CharSequence)preferenceKey);
        if (preference == null) {
            return false;
        }
        Intent intent = preference.getIntent();
        if (intent != null) {
            PackageManager pm = context.getPackageManager();
            List list = pm.queryIntentActivities(intent, 0);
            int listSize = list.size();
            for (int i = 0; i < listSize; ++i) {
                ResolveInfo resolveInfo = (ResolveInfo)list.get(i);
                if ((resolveInfo.activityInfo.applicationInfo.flags & 1) == 0) continue;
                preference.setIntent(new Intent().setClassName(resolveInfo.activityInfo.packageName, resolveInfo.activityInfo.name));
                if ((flags & 1) != 0) {
                    preference.setTitle(resolveInfo.loadLabel(pm));
                }
                return true;
            }
        }
        parentPreferenceGroup.removePreference(preference);
        return true;
    }

    public static boolean isMonkeyRunning() {
        return SystemProperties.getBoolean((String)"ro.monkey", (boolean)false);
    }
}

