/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.app.AlertDialog;
import android.app.Dialog;
import android.app.ListActivity;
import android.content.Context;
import android.content.DialogInterface;
import android.database.Cursor;
import android.os.Bundle;
import android.provider.UserDictionary;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.AlphabetIndexer;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.SectionIndexer;
import android.widget.SimpleCursorAdapter;
import android.widget.TextView;
import java.util.Locale;

public class UserDictionarySettings
extends ListActivity {
    private static final String INSTANCE_KEY_DIALOG_EDITING_WORD = "DIALOG_EDITING_WORD";
    private static final String INSTANCE_KEY_ADDED_WORD = "DIALOG_ADDED_WORD";
    private static final String[] QUERY_PROJECTION = new String[]{"_id", "word"};
    private static final String QUERY_SELECTION = "locale=? OR locale is null";
    private static final String DELETE_SELECTION = "word=?";
    private static final String EXTRA_WORD = "word";
    private static final int CONTEXT_MENU_EDIT = 1;
    private static final int CONTEXT_MENU_DELETE = 2;
    private static final int OPTIONS_MENU_ADD = 1;
    private static final int DIALOG_ADD_OR_EDIT = 0;
    private String mDialogEditingWord;
    private Cursor mCursor;
    private boolean mAddedWordAlready;
    private boolean mAutoReturn;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2130903065);
        this.mCursor = this.createCursor();
        this.setListAdapter(this.createAdapter());
        TextView emptyView = (TextView)this.findViewById(2131427413);
        emptyView.setText(2131231568);
        ListView listView = this.getListView();
        listView.setFastScrollEnabled(true);
        listView.setEmptyView((View)emptyView);
        this.registerForContextMenu((View)listView);
    }

    protected void onResume() {
        super.onResume();
        if (!this.mAddedWordAlready && this.getIntent().getAction().equals("com.android.settings.USER_DICTIONARY_INSERT")) {
            String word = this.getIntent().getStringExtra(EXTRA_WORD);
            this.mAutoReturn = true;
            if (word != null) {
                this.showAddOrEditDialog(word);
            }
        }
    }

    protected void onRestoreInstanceState(Bundle state) {
        super.onRestoreInstanceState(state);
        this.mDialogEditingWord = state.getString(INSTANCE_KEY_DIALOG_EDITING_WORD);
        this.mAddedWordAlready = state.getBoolean(INSTANCE_KEY_ADDED_WORD, false);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString(INSTANCE_KEY_DIALOG_EDITING_WORD, this.mDialogEditingWord);
        outState.putBoolean(INSTANCE_KEY_ADDED_WORD, this.mAddedWordAlready);
    }

    private Cursor createCursor() {
        String currentLocale = Locale.getDefault().toString();
        return this.managedQuery(UserDictionary.Words.CONTENT_URI, QUERY_PROJECTION, QUERY_SELECTION, new String[]{currentLocale}, "UPPER(word)");
    }

    private ListAdapter createAdapter() {
        return new MyAdapter((Context)this, 17367043, this.mCursor, new String[]{EXTRA_WORD}, new int[]{16908308});
    }

    protected void onListItemClick(ListView l, View v, int position, long id2) {
        this.openContextMenu(v);
    }

    public void onCreateContextMenu(ContextMenu menu, View v, ContextMenu.ContextMenuInfo menuInfo) {
        if (!(menuInfo instanceof AdapterView.AdapterContextMenuInfo)) {
            return;
        }
        AdapterView.AdapterContextMenuInfo adapterMenuInfo = (AdapterView.AdapterContextMenuInfo)menuInfo;
        menu.setHeaderTitle((CharSequence)this.getWord(adapterMenuInfo.position));
        menu.add(0, 1, 0, 2131231566);
        menu.add(0, 2, 0, 2131231567);
    }

    public boolean onContextItemSelected(MenuItem item) {
        ContextMenu.ContextMenuInfo menuInfo = item.getMenuInfo();
        if (!(menuInfo instanceof AdapterView.AdapterContextMenuInfo)) {
            return false;
        }
        AdapterView.AdapterContextMenuInfo adapterMenuInfo = (AdapterView.AdapterContextMenuInfo)menuInfo;
        String word = this.getWord(adapterMenuInfo.position);
        if (word == null) {
            return true;
        }
        switch (item.getItemId()) {
            case 2: {
                this.deleteWord(word);
                return true;
            }
            case 1: {
                this.showAddOrEditDialog(word);
                return true;
            }
        }
        return false;
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        menu.add(0, 1, 0, 2131231563).setIcon(2130837546);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        this.showAddOrEditDialog(null);
        return true;
    }

    private void showAddOrEditDialog(String editingWord) {
        this.mDialogEditingWord = editingWord;
        this.showDialog(0);
    }

    private String getWord(int position) {
        this.mCursor.moveToPosition(position);
        if (this.mCursor.isAfterLast()) {
            return null;
        }
        return this.mCursor.getString(this.mCursor.getColumnIndexOrThrow(EXTRA_WORD));
    }

    protected Dialog onCreateDialog(int id2) {
        View content = this.getLayoutInflater().inflate(2130903061, null);
        final EditText editText = (EditText)content.findViewById(2131427382);
        editText.setInputType(65537);
        AlertDialog dialog = new AlertDialog.Builder((Context)this).setTitle(this.mDialogEditingWord != null ? 2131231565 : 2131231564).setView(content).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                UserDictionarySettings.this.onAddOrEditFinished(editText.getText().toString());
                if (UserDictionarySettings.this.mAutoReturn) {
                    UserDictionarySettings.this.finish();
                }
            }
        }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (UserDictionarySettings.this.mAutoReturn) {
                    UserDictionarySettings.this.finish();
                }
            }
        }).create();
        dialog.getWindow().setSoftInputMode(20);
        return dialog;
    }

    protected void onPrepareDialog(int id2, Dialog d) {
        AlertDialog dialog = (AlertDialog)d;
        d.setTitle(this.mDialogEditingWord != null ? 2131231565 : 2131231564);
        EditText editText = (EditText)dialog.findViewById(2131427382);
        editText.setText((CharSequence)this.mDialogEditingWord);
    }

    private void onAddOrEditFinished(String word) {
        if (this.mDialogEditingWord != null) {
            this.deleteWord(this.mDialogEditingWord);
        }
        this.deleteWord(word);
        UserDictionary.Words.addWord((Context)this, (String)word.toString(), (int)250, (int)0);
        this.mCursor.requery();
        this.mAddedWordAlready = true;
    }

    private void deleteWord(String word) {
        this.getContentResolver().delete(UserDictionary.Words.CONTENT_URI, DELETE_SELECTION, new String[]{word});
    }

    private static class MyAdapter
    extends SimpleCursorAdapter
    implements SectionIndexer {
        private AlphabetIndexer mIndexer;

        public MyAdapter(Context context, int layout2, Cursor c, String[] from, int[] to) {
            super(context, layout2, c, from, to);
            int wordColIndex = c.getColumnIndexOrThrow(UserDictionarySettings.EXTRA_WORD);
            String alphabet = context.getString(17040198);
            this.mIndexer = new AlphabetIndexer(c, wordColIndex, (CharSequence)alphabet);
        }

        public int getPositionForSection(int section) {
            return this.mIndexer.getPositionForSection(section);
        }

        public int getSectionForPosition(int position) {
            return this.mIndexer.getSectionForPosition(position);
        }

        public Object[] getSections() {
            return this.mIndexer.getSections();
        }
    }
}

