/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.app.Activity;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.Spinner;
import android.widget.TextView;
import com.android.internal.app.IUsageStats;
import com.android.internal.os.PkgUsageStats;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsageStats
extends Activity
implements AdapterView.OnItemSelectedListener {
    private static final String TAG = "UsageStatsActivity";
    private static final boolean localLOGV = true;
    private Spinner mTypeSpinner;
    private ListView mListView;
    private IUsageStats mUsageStatsService;
    private LayoutInflater mInflater;
    private UsageStatsAdapter mAdapter;
    private PackageManager mPm;

    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.mUsageStatsService = IUsageStats.Stub.asInterface((IBinder)ServiceManager.getService((String)"usagestats"));
        if (this.mUsageStatsService == null) {
            Log.e((String)TAG, (String)"Failed to retrieve usagestats service");
            return;
        }
        this.mInflater = (LayoutInflater)this.getSystemService("layout_inflater");
        this.mPm = this.getPackageManager();
        this.setContentView(2130903100);
        this.mTypeSpinner = (Spinner)this.findViewById(2131427519);
        this.mTypeSpinner.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)this);
        this.mListView = (ListView)this.findViewById(2131427520);
        this.mAdapter = new UsageStatsAdapter();
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
    }

    public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
        this.mAdapter.sortList(position);
    }

    public void onNothingSelected(AdapterView<?> parent) {
    }

    class UsageStatsAdapter
    extends BaseAdapter {
        private static final int _DISPLAY_ORDER_USAGE_TIME = 0;
        private static final int _DISPLAY_ORDER_LAUNCH_COUNT = 1;
        private static final int _DISPLAY_ORDER_APP_NAME = 2;
        private int mDisplayOrder = 0;
        private List<PkgUsageStats> mUsageStats = new ArrayList<PkgUsageStats>();
        private LaunchCountComparator mLaunchCountComparator;
        private UsageTimeComparator mUsageTimeComparator;
        private AppNameComparator mAppLabelComparator;
        private HashMap<String, CharSequence> mAppLabelMap = new HashMap();

        UsageStatsAdapter() {
            PkgUsageStats[] stats;
            try {
                stats = UsageStats.this.mUsageStatsService.getAllPkgUsageStats();
            }
            catch (RemoteException e) {
                Log.e((String)UsageStats.TAG, (String)"Failed initializing usage stats service");
                return;
            }
            if (stats == null) {
                return;
            }
            for (PkgUsageStats ps : stats) {
                CharSequence label;
                this.mUsageStats.add(ps);
                try {
                    ApplicationInfo appInfo = UsageStats.this.mPm.getApplicationInfo(ps.packageName, 0);
                    label = appInfo.loadLabel(UsageStats.this.mPm);
                }
                catch (PackageManager.NameNotFoundException e) {
                    label = ps.packageName;
                }
                this.mAppLabelMap.put(ps.packageName, label);
            }
            this.mLaunchCountComparator = new LaunchCountComparator();
            this.mUsageTimeComparator = new UsageTimeComparator();
            this.mAppLabelComparator = new AppNameComparator(this.mAppLabelMap);
            this.sortList();
        }

        public int getCount() {
            return this.mUsageStats.size();
        }

        public Object getItem(int position) {
            return this.mUsageStats.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            AppViewHolder holder;
            if (convertView == null) {
                convertView = UsageStats.this.mInflater.inflate(2130903101, null);
                holder = new AppViewHolder();
                holder.pkgName = (TextView)convertView.findViewById(2131427521);
                holder.launchCount = (TextView)convertView.findViewById(2131427522);
                holder.usageTime = (TextView)convertView.findViewById(2131427523);
                convertView.setTag((Object)holder);
            } else {
                holder = (AppViewHolder)convertView.getTag();
            }
            PkgUsageStats pkgStats = this.mUsageStats.get(position);
            if (pkgStats != null) {
                CharSequence label = this.mAppLabelMap.get(pkgStats.packageName);
                holder.pkgName.setText(label);
                holder.launchCount.setText((CharSequence)String.valueOf(pkgStats.launchCount));
                holder.usageTime.setText((CharSequence)(String.valueOf(pkgStats.usageTime) + " ms"));
            } else {
                Log.w((String)UsageStats.TAG, (String)("No usage stats info for package:" + position));
            }
            return convertView;
        }

        void sortList(int sortOrder) {
            if (this.mDisplayOrder == sortOrder) {
                return;
            }
            this.mDisplayOrder = sortOrder;
            this.sortList();
        }

        private void sortList() {
            if (this.mDisplayOrder == 0) {
                Log.i((String)UsageStats.TAG, (String)"Sorting by usage time");
                Collections.sort(this.mUsageStats, this.mUsageTimeComparator);
            } else if (this.mDisplayOrder == 1) {
                Log.i((String)UsageStats.TAG, (String)"Sorting launch count");
                Collections.sort(this.mUsageStats, this.mLaunchCountComparator);
            } else if (this.mDisplayOrder == 2) {
                Log.i((String)UsageStats.TAG, (String)"Sorting by application name");
                Collections.sort(this.mUsageStats, this.mAppLabelComparator);
            }
            this.notifyDataSetChanged();
        }
    }

    static class AppViewHolder {
        TextView pkgName;
        TextView launchCount;
        TextView usageTime;

        AppViewHolder() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UsageTimeComparator
    implements Comparator<PkgUsageStats> {
        @Override
        public final int compare(PkgUsageStats a, PkgUsageStats b) {
            long ret = a.usageTime - b.usageTime;
            if (ret == 0L) {
                return 0;
            }
            if (ret < 0L) {
                return 1;
            }
            return -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LaunchCountComparator
    implements Comparator<PkgUsageStats> {
        @Override
        public final int compare(PkgUsageStats a, PkgUsageStats b) {
            return b.launchCount - a.launchCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AppNameComparator
    implements Comparator<PkgUsageStats> {
        Map<String, CharSequence> mAppLabelList;

        AppNameComparator(Map<String, CharSequence> appList) {
            this.mAppLabelList = appList;
        }

        @Override
        public final int compare(PkgUsageStats a, PkgUsageStats b) {
            String alabel = ((Object)this.mAppLabelList.get(a.packageName)).toString();
            String blabel = ((Object)this.mAppLabelList.get(b.packageName)).toString();
            return alabel.compareTo(blabel);
        }
    }
}

