/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.app.AlertDialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.preference.CheckBoxPreference;
import android.preference.ListPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceGroup;
import android.preference.PreferenceScreen;
import android.provider.Settings;
import android.speech.tts.TextToSpeech;
import android.util.Log;
import com.android.settings.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

public class TextToSpeechSettings
extends PreferenceActivity
implements Preference.OnPreferenceChangeListener,
Preference.OnPreferenceClickListener,
TextToSpeech.OnInitListener {
    private static final String TAG = "TextToSpeechSettings";
    private static final String SYSTEM_TTS = "com.svox.pico";
    private static final String KEY_TTS_PLAY_EXAMPLE = "tts_play_example";
    private static final String KEY_TTS_INSTALL_DATA = "tts_install_data";
    private static final String KEY_TTS_USE_DEFAULT = "toggle_use_default_tts_settings";
    private static final String KEY_TTS_DEFAULT_RATE = "tts_default_rate";
    private static final String KEY_TTS_DEFAULT_LANG = "tts_default_lang";
    private static final String KEY_TTS_DEFAULT_COUNTRY = "tts_default_country";
    private static final String KEY_TTS_DEFAULT_VARIANT = "tts_default_variant";
    private static final String KEY_TTS_DEFAULT_SYNTH = "tts_default_synth";
    private static final String KEY_PLUGIN_ENABLED_PREFIX = "ENABLED_";
    private static final String KEY_PLUGIN_SETTINGS_PREFIX = "SETTINGS_";
    private static final String DEFAULT_LANG_VAL = "eng";
    private static final String DEFAULT_COUNTRY_VAL = "USA";
    private static final String DEFAULT_VARIANT_VAL = "";
    private static final String LOCALE_DELIMITER = "-";
    private static final String FALLBACK_TTS_DEFAULT_SYNTH = "com.svox.pico";
    private Preference mPlayExample = null;
    private Preference mInstallData = null;
    private CheckBoxPreference mUseDefaultPref = null;
    private ListPreference mDefaultRatePref = null;
    private ListPreference mDefaultLocPref = null;
    private ListPreference mDefaultSynthPref = null;
    private String mDefaultLanguage = null;
    private String mDefaultCountry = null;
    private String mDefaultLocVariant = null;
    private String mDefaultEng = "";
    private int mDefaultRate = 100;
    private String[] mDemoStrings;
    private int mDemoStringIndex = 0;
    private boolean mEnableDemo = false;
    private boolean mVoicesMissing = false;
    private TextToSpeech mTts = null;
    private boolean mTtsStarted = false;
    private static final int VOICE_DATA_INTEGRITY_CHECK = 1977;
    private static final int GET_SAMPLE_TEXT = 1983;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.addPreferencesFromResource(2130968610);
        this.addEngineSpecificSettings();
        this.mDemoStrings = this.getResources().getStringArray(2131034125);
        this.setVolumeControlStream(3);
        this.mEnableDemo = false;
        this.mTtsStarted = false;
        Locale currentLocale = Locale.getDefault();
        this.mDefaultLanguage = currentLocale.getISO3Language();
        this.mDefaultCountry = currentLocale.getISO3Country();
        this.mDefaultLocVariant = currentLocale.getVariant();
        this.mTts = new TextToSpeech((Context)this, (TextToSpeech.OnInitListener)this);
    }

    protected void onStart() {
        super.onStart();
        if (this.mTtsStarted) {
            this.initClickers();
            this.updateWidgetState();
            this.checkVoiceData();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mTts != null) {
            this.mTts.shutdown();
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.mDefaultRatePref != null && this.mDefaultRatePref.getDialog() != null) {
            this.mDefaultRatePref.getDialog().dismiss();
        }
        if (this.mDefaultLocPref != null && this.mDefaultLocPref.getDialog() != null) {
            this.mDefaultLocPref.getDialog().dismiss();
        }
        if (this.mDefaultSynthPref != null && this.mDefaultSynthPref.getDialog() != null) {
            this.mDefaultSynthPref.getDialog().dismiss();
        }
    }

    private void addEngineSpecificSettings() {
        PreferenceGroup enginesCategory = (PreferenceGroup)this.findPreference("tts_engines_section");
        Intent intent = new Intent("android.intent.action.START_TTS_ENGINE");
        ResolveInfo[] enginesArray = new ResolveInfo[]{};
        PackageManager pm = this.getPackageManager();
        enginesArray = pm.queryIntentActivities(intent, 0).toArray(enginesArray);
        for (int i = 0; i < enginesArray.length; ++i) {
            String prefKey = DEFAULT_VARIANT_VAL;
            final String pluginPackageName = enginesArray[i].activityInfo.packageName;
            if (!enginesArray[i].activityInfo.packageName.equals("com.svox.pico")) {
                CheckBoxPreference chkbxPref = new CheckBoxPreference((Context)this);
                prefKey = KEY_PLUGIN_ENABLED_PREFIX + pluginPackageName;
                chkbxPref.setKey(prefKey);
                chkbxPref.setTitle(enginesArray[i].loadLabel(pm));
                enginesCategory.addPreference((Preference)chkbxPref);
            }
            if (!this.pluginHasSettings(pluginPackageName)) continue;
            Preference pref = new Preference((Context)this);
            prefKey = KEY_PLUGIN_SETTINGS_PREFIX + pluginPackageName;
            pref.setKey(prefKey);
            pref.setTitle(enginesArray[i].loadLabel(pm));
            String settingsLabel = this.getResources().getString(2131231725, new Object[]{enginesArray[i].loadLabel(pm)});
            pref.setSummary((CharSequence)settingsLabel);
            pref.setOnPreferenceClickListener(new Preference.OnPreferenceClickListener(){

                public boolean onPreferenceClick(Preference preference) {
                    Intent i = new Intent();
                    i.setClassName(pluginPackageName, pluginPackageName + ".EngineSettings");
                    TextToSpeechSettings.this.startActivity(i);
                    return true;
                }
            });
            enginesCategory.addPreference(pref);
        }
    }

    private boolean pluginHasSettings(String pluginPackageName) {
        PackageManager pm = this.getPackageManager();
        Intent i = new Intent();
        i.setClassName(pluginPackageName, pluginPackageName + ".EngineSettings");
        return pm.resolveActivity(i, 65536) != null;
    }

    private void initClickers() {
        this.mPlayExample = this.findPreference(KEY_TTS_PLAY_EXAMPLE);
        this.mPlayExample.setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        this.mInstallData = this.findPreference(KEY_TTS_INSTALL_DATA);
        this.mInstallData.setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
    }

    private void initDefaultSettings() {
        ContentResolver resolver = this.getContentResolver();
        int useDefault = 0;
        this.mUseDefaultPref = (CheckBoxPreference)this.findPreference(KEY_TTS_USE_DEFAULT);
        try {
            useDefault = Settings.Secure.getInt((ContentResolver)resolver, (String)"tts_use_defaults");
        }
        catch (Settings.SettingNotFoundException e) {
            useDefault = 0;
            Settings.Secure.putInt((ContentResolver)resolver, (String)"tts_use_defaults", (int)useDefault);
        }
        this.mUseDefaultPref.setChecked(useDefault == 1);
        this.mUseDefaultPref.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
        this.mDefaultSynthPref = (ListPreference)this.findPreference(KEY_TTS_DEFAULT_SYNTH);
        this.loadEngines();
        this.mDefaultSynthPref.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
        String engine = Settings.Secure.getString((ContentResolver)resolver, (String)KEY_TTS_DEFAULT_SYNTH);
        if (engine == null) {
            engine = "com.svox.pico";
            Settings.Secure.putString((ContentResolver)resolver, (String)KEY_TTS_DEFAULT_SYNTH, (String)engine);
        }
        this.mDefaultEng = engine;
        this.mDefaultRatePref = (ListPreference)this.findPreference(KEY_TTS_DEFAULT_RATE);
        try {
            this.mDefaultRate = Settings.Secure.getInt((ContentResolver)resolver, (String)KEY_TTS_DEFAULT_RATE);
        }
        catch (Settings.SettingNotFoundException e) {
            this.mDefaultRate = 100;
            Settings.Secure.putInt((ContentResolver)resolver, (String)KEY_TTS_DEFAULT_RATE, (int)this.mDefaultRate);
        }
        this.mDefaultRatePref.setValue(String.valueOf(this.mDefaultRate));
        this.mDefaultRatePref.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
        this.mDefaultLocPref = (ListPreference)this.findPreference(KEY_TTS_DEFAULT_LANG);
        this.initDefaultLang();
        this.mDefaultLocPref.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
    }

    private void checkVoiceData() {
        PackageManager pm = this.getPackageManager();
        Intent intent = new Intent();
        intent.setAction("android.speech.tts.engine.CHECK_TTS_DATA");
        List resolveInfos = pm.queryIntentActivities(intent, 0);
        for (int i = 0; i < resolveInfos.size(); ++i) {
            ActivityInfo currentActivityInfo = ((ResolveInfo)resolveInfos.get((int)i)).activityInfo;
            if (!this.mDefaultEng.equals(currentActivityInfo.packageName)) continue;
            intent.setClassName(this.mDefaultEng, currentActivityInfo.name);
            this.startActivityForResult(intent, 1977);
        }
    }

    private void installVoiceData() {
        PackageManager pm = this.getPackageManager();
        Intent intent = new Intent();
        intent.setAction("android.speech.tts.engine.INSTALL_TTS_DATA");
        intent.addFlags(0x10000000);
        List resolveInfos = pm.queryIntentActivities(intent, 0);
        for (int i = 0; i < resolveInfos.size(); ++i) {
            ActivityInfo currentActivityInfo = ((ResolveInfo)resolveInfos.get((int)i)).activityInfo;
            if (!this.mDefaultEng.equals(currentActivityInfo.packageName)) continue;
            intent.setClassName(this.mDefaultEng, currentActivityInfo.name);
            this.startActivity(intent);
        }
    }

    private void getSampleText() {
        PackageManager pm = this.getPackageManager();
        Intent intent = new Intent();
        intent.setAction("android.speech.tts.engine.GET_SAMPLE_TEXT");
        intent.putExtra("language", this.mDefaultLanguage);
        intent.putExtra("country", this.mDefaultCountry);
        intent.putExtra("variant", this.mDefaultLocVariant);
        List resolveInfos = pm.queryIntentActivities(intent, 0);
        for (int i = 0; i < resolveInfos.size(); ++i) {
            ActivityInfo currentActivityInfo = ((ResolveInfo)resolveInfos.get((int)i)).activityInfo;
            if (!this.mDefaultEng.equals(currentActivityInfo.packageName)) continue;
            intent.setClassName(this.mDefaultEng, currentActivityInfo.name);
            this.startActivityForResult(intent, 1983);
        }
    }

    public void onInit(int status) {
        if (status == 0) {
            this.mEnableDemo = true;
            if (this.mDefaultLanguage == null) {
                this.mDefaultLanguage = Locale.getDefault().getISO3Language();
            }
            if (this.mDefaultCountry == null) {
                this.mDefaultCountry = Locale.getDefault().getISO3Country();
            }
            if (this.mDefaultLocVariant == null) {
                this.mDefaultLocVariant = new String();
            }
            this.mTts.setLanguage(new Locale(this.mDefaultLanguage, this.mDefaultCountry, this.mDefaultLocVariant));
            this.mTts.setSpeechRate((float)this.mDefaultRate / 100.0f);
            this.initDefaultSettings();
            this.initClickers();
            this.updateWidgetState();
            this.checkVoiceData();
            this.mTtsStarted = true;
            Log.v((String)TAG, (String)"TTS engine for settings screen initialized.");
        } else {
            Log.v((String)TAG, (String)"TTS engine for settings screen failed to initialize successfully.");
            this.mEnableDemo = false;
        }
        this.updateWidgetState();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1977) {
            if (data == null) {
                this.mEnableDemo = false;
                this.mVoicesMissing = false;
                this.updateWidgetState();
                return;
            }
            ArrayList available = data.getStringArrayListExtra("availableVoices");
            ArrayList unavailable = data.getStringArrayListExtra("unavailableVoices");
            if (available == null || unavailable == null) {
                this.mEnableDemo = false;
                this.mVoicesMissing = false;
                this.updateWidgetState();
                return;
            }
            if (available.size() > 0) {
                if (this.mTts == null) {
                    this.mTts = new TextToSpeech((Context)this, (TextToSpeech.OnInitListener)this);
                }
                ListPreference ttsLanguagePref = (ListPreference)this.findPreference(KEY_TTS_DEFAULT_LANG);
                CharSequence[] entries = new CharSequence[available.size()];
                CharSequence[] entryValues = new CharSequence[available.size()];
                int selectedLanguageIndex = -1;
                String selectedLanguagePref = this.mDefaultLanguage;
                if (this.mDefaultCountry.length() > 0) {
                    selectedLanguagePref = selectedLanguagePref + LOCALE_DELIMITER + this.mDefaultCountry;
                }
                if (this.mDefaultLocVariant.length() > 0) {
                    selectedLanguagePref = selectedLanguagePref + LOCALE_DELIMITER + this.mDefaultLocVariant;
                }
                for (int i = 0; i < available.size(); ++i) {
                    String[] langCountryVariant = ((String)available.get(i)).split(LOCALE_DELIMITER);
                    Locale loc = null;
                    if (langCountryVariant.length == 1) {
                        loc = new Locale(langCountryVariant[0]);
                    } else if (langCountryVariant.length == 2) {
                        loc = new Locale(langCountryVariant[0], langCountryVariant[1]);
                    } else if (langCountryVariant.length == 3) {
                        loc = new Locale(langCountryVariant[0], langCountryVariant[1], langCountryVariant[2]);
                    }
                    if (loc == null) continue;
                    entries[i] = loc.getDisplayName();
                    entryValues[i] = (CharSequence)available.get(i);
                    if (!entryValues[i].equals(selectedLanguagePref)) continue;
                    selectedLanguageIndex = i;
                }
                ttsLanguagePref.setEntries(entries);
                ttsLanguagePref.setEntryValues(entryValues);
                if (selectedLanguageIndex > -1) {
                    ttsLanguagePref.setValueIndex(selectedLanguageIndex);
                }
                this.mEnableDemo = true;
                int languageResult = this.mTts.setLanguage(new Locale(this.mDefaultLanguage, this.mDefaultCountry, this.mDefaultLocVariant));
                if (languageResult < 0) {
                    Locale currentLocale = Locale.getDefault();
                    this.mDefaultLanguage = currentLocale.getISO3Language();
                    this.mDefaultCountry = currentLocale.getISO3Country();
                    this.mDefaultLocVariant = currentLocale.getVariant();
                    languageResult = this.mTts.setLanguage(new Locale(this.mDefaultLanguage, this.mDefaultCountry, this.mDefaultLocVariant));
                    if (languageResult < 0) {
                        this.parseLocaleInfo(((Object)ttsLanguagePref.getEntryValues()[0]).toString());
                        this.mTts.setLanguage(new Locale(this.mDefaultLanguage, this.mDefaultCountry, this.mDefaultLocVariant));
                    }
                    ContentResolver resolver = this.getContentResolver();
                    Settings.Secure.putString((ContentResolver)resolver, (String)KEY_TTS_DEFAULT_LANG, (String)this.mDefaultLanguage);
                    Settings.Secure.putString((ContentResolver)resolver, (String)KEY_TTS_DEFAULT_COUNTRY, (String)this.mDefaultCountry);
                    Settings.Secure.putString((ContentResolver)resolver, (String)KEY_TTS_DEFAULT_VARIANT, (String)this.mDefaultLocVariant);
                }
            } else {
                this.mEnableDemo = false;
            }
            this.mVoicesMissing = unavailable.size() > 0;
            this.updateWidgetState();
        } else if (requestCode == 1983) {
            if (resultCode == 0) {
                String sample = this.getString(2131231718);
                if (data != null && data.getStringExtra("sampleText") != null) {
                    sample = data.getStringExtra("sampleText");
                }
                if (this.mTts != null) {
                    this.mTts.speak(sample, 0, null);
                }
            } else {
                Log.e((String)TAG, (String)"Did not have a sample string for the requested language");
            }
        }
    }

    public boolean onPreferenceChange(Preference preference, Object objValue) {
        if (KEY_TTS_USE_DEFAULT.equals(preference.getKey())) {
            int value = (Boolean)objValue != false ? 1 : 0;
            Settings.Secure.putInt((ContentResolver)this.getContentResolver(), (String)"tts_use_defaults", (int)value);
            Log.i((String)TAG, (String)("TTS use default settings is " + objValue.toString()));
        } else if (KEY_TTS_DEFAULT_RATE.equals(preference.getKey())) {
            this.mDefaultRate = Integer.parseInt((String)objValue);
            try {
                Settings.Secure.putInt((ContentResolver)this.getContentResolver(), (String)KEY_TTS_DEFAULT_RATE, (int)this.mDefaultRate);
                if (this.mTts != null) {
                    this.mTts.setSpeechRate((float)this.mDefaultRate / 100.0f);
                }
                Log.i((String)TAG, (String)("TTS default rate is " + this.mDefaultRate));
            }
            catch (NumberFormatException e) {
                Log.e((String)TAG, (String)"could not persist default TTS rate setting", (Throwable)e);
            }
        } else if (KEY_TTS_DEFAULT_LANG.equals(preference.getKey())) {
            ContentResolver resolver = this.getContentResolver();
            this.parseLocaleInfo((String)objValue);
            Settings.Secure.putString((ContentResolver)resolver, (String)KEY_TTS_DEFAULT_LANG, (String)this.mDefaultLanguage);
            Settings.Secure.putString((ContentResolver)resolver, (String)KEY_TTS_DEFAULT_COUNTRY, (String)this.mDefaultCountry);
            Settings.Secure.putString((ContentResolver)resolver, (String)KEY_TTS_DEFAULT_VARIANT, (String)this.mDefaultLocVariant);
            Log.v((String)TAG, (String)("TTS default lang/country/variant set to " + this.mDefaultLanguage + "/" + this.mDefaultCountry + "/" + this.mDefaultLocVariant));
            if (this.mTts != null) {
                this.mTts.setLanguage(new Locale(this.mDefaultLanguage, this.mDefaultCountry, this.mDefaultLocVariant));
            }
            int newIndex = this.mDefaultLocPref.findIndexOfValue((String)objValue);
            Log.v((String)"Settings", (String)(" selected is " + newIndex));
            this.mDemoStringIndex = newIndex > -1 ? newIndex : 0;
        } else if (KEY_TTS_DEFAULT_SYNTH.equals(preference.getKey())) {
            this.mDefaultEng = objValue.toString();
            Settings.Secure.putString((ContentResolver)this.getContentResolver(), (String)KEY_TTS_DEFAULT_SYNTH, (String)this.mDefaultEng);
            if (this.mTts != null) {
                this.mTts.setEngineByPackageName(this.mDefaultEng);
                this.mEnableDemo = false;
                this.mVoicesMissing = false;
                this.updateWidgetState();
                this.checkVoiceData();
            }
            Log.v((String)"Settings", (String)("The default synth is: " + objValue.toString()));
        }
        return true;
    }

    public boolean onPreferenceClick(Preference preference) {
        if (preference == this.mPlayExample) {
            this.getSampleText();
            return true;
        }
        if (preference == this.mInstallData) {
            this.installVoiceData();
            this.finish();
            return true;
        }
        return false;
    }

    public boolean onPreferenceTreeClick(PreferenceScreen preferenceScreen, Preference preference) {
        CheckBoxPreference chkPref;
        if (Utils.isMonkeyRunning()) {
            return false;
        }
        if (preference instanceof CheckBoxPreference && !(chkPref = (CheckBoxPreference)preference).getKey().equals(KEY_TTS_USE_DEFAULT)) {
            if (chkPref.isChecked()) {
                chkPref.setChecked(false);
                AlertDialog d = new AlertDialog.Builder((Context)this).setTitle(0x1040014).setIcon(17301543).setMessage((CharSequence)this.getString(2131231723, new Object[]{chkPref.getTitle()})).setCancelable(true).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        chkPref.setChecked(true);
                        TextToSpeechSettings.this.loadEngines();
                    }
                }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                    }
                }).create();
                d.show();
            } else {
                this.loadEngines();
            }
            return true;
        }
        return false;
    }

    private void updateWidgetState() {
        this.mPlayExample.setEnabled(this.mEnableDemo);
        this.mUseDefaultPref.setEnabled(this.mEnableDemo);
        this.mDefaultRatePref.setEnabled(this.mEnableDemo);
        this.mDefaultLocPref.setEnabled(this.mEnableDemo);
        this.mInstallData.setEnabled(this.mVoicesMissing);
    }

    private void parseLocaleInfo(String locale) {
        StringTokenizer tokenizer = new StringTokenizer(locale, LOCALE_DELIMITER);
        this.mDefaultLanguage = DEFAULT_VARIANT_VAL;
        this.mDefaultCountry = DEFAULT_VARIANT_VAL;
        this.mDefaultLocVariant = DEFAULT_VARIANT_VAL;
        if (tokenizer.hasMoreTokens()) {
            this.mDefaultLanguage = tokenizer.nextToken().trim();
        }
        if (tokenizer.hasMoreTokens()) {
            this.mDefaultCountry = tokenizer.nextToken().trim();
        }
        if (tokenizer.hasMoreTokens()) {
            this.mDefaultLocVariant = tokenizer.nextToken().trim();
        }
    }

    private void initDefaultLang() {
        if (!this.hasLangPref()) {
            if (this.isCurrentLocSupported()) {
                this.useCurrentLocAsDefault();
            } else {
                this.useSupportedLocAsDefault();
            }
        }
        ContentResolver resolver = this.getContentResolver();
        this.mDefaultLanguage = Settings.Secure.getString((ContentResolver)resolver, (String)KEY_TTS_DEFAULT_LANG);
        this.mDefaultCountry = Settings.Secure.getString((ContentResolver)resolver, (String)KEY_TTS_DEFAULT_COUNTRY);
        this.mDefaultLocVariant = Settings.Secure.getString((ContentResolver)resolver, (String)KEY_TTS_DEFAULT_VARIANT);
        this.mDemoStringIndex = this.mDefaultLocPref.findIndexOfValue(this.mDefaultLanguage + LOCALE_DELIMITER + this.mDefaultCountry);
        if (this.mDemoStringIndex > -1) {
            this.mDefaultLocPref.setValueIndex(this.mDemoStringIndex);
        }
    }

    private boolean hasLangPref() {
        ContentResolver resolver = this.getContentResolver();
        String language = Settings.Secure.getString((ContentResolver)resolver, (String)KEY_TTS_DEFAULT_LANG);
        if (language == null || language.length() < 1) {
            return false;
        }
        String country = Settings.Secure.getString((ContentResolver)resolver, (String)KEY_TTS_DEFAULT_COUNTRY);
        if (country == null) {
            return false;
        }
        String variant = Settings.Secure.getString((ContentResolver)resolver, (String)KEY_TTS_DEFAULT_VARIANT);
        return variant != null;
    }

    private boolean isCurrentLocSupported() {
        String currentLocID = Locale.getDefault().getISO3Language() + LOCALE_DELIMITER + Locale.getDefault().getISO3Country();
        return this.mDefaultLocPref.findIndexOfValue(currentLocID) > -1;
    }

    private void useCurrentLocAsDefault() {
        Locale currentLocale = Locale.getDefault();
        ContentResolver resolver = this.getContentResolver();
        Settings.Secure.putString((ContentResolver)resolver, (String)KEY_TTS_DEFAULT_LANG, (String)currentLocale.getISO3Language());
        Settings.Secure.putString((ContentResolver)resolver, (String)KEY_TTS_DEFAULT_COUNTRY, (String)currentLocale.getISO3Country());
        Settings.Secure.putString((ContentResolver)resolver, (String)KEY_TTS_DEFAULT_VARIANT, (String)currentLocale.getVariant());
    }

    private void useSupportedLocAsDefault() {
        ContentResolver resolver = this.getContentResolver();
        Settings.Secure.putString((ContentResolver)resolver, (String)KEY_TTS_DEFAULT_LANG, (String)DEFAULT_LANG_VAL);
        Settings.Secure.putString((ContentResolver)resolver, (String)KEY_TTS_DEFAULT_COUNTRY, (String)DEFAULT_COUNTRY_VAL);
        Settings.Secure.putString((ContentResolver)resolver, (String)KEY_TTS_DEFAULT_VARIANT, (String)DEFAULT_VARIANT_VAL);
    }

    private void loadEngines() {
        this.mDefaultSynthPref = (ListPreference)this.findPreference(KEY_TTS_DEFAULT_SYNTH);
        Intent intent = new Intent("android.intent.action.START_TTS_ENGINE");
        ResolveInfo[] enginesArray = new ResolveInfo[]{};
        PackageManager pm = this.getPackageManager();
        enginesArray = pm.queryIntentActivities(intent, 0).toArray(enginesArray);
        ArrayList<CharSequence> entries = new ArrayList<CharSequence>();
        ArrayList<String> values = new ArrayList<String>();
        String enabledEngines = DEFAULT_VARIANT_VAL;
        for (int i = 0; i < enginesArray.length; ++i) {
            String pluginPackageName = enginesArray[i].activityInfo.packageName;
            if (pluginPackageName.equals("com.svox.pico")) {
                entries.add(enginesArray[i].loadLabel(pm));
                values.add(pluginPackageName);
                continue;
            }
            CheckBoxPreference pref = (CheckBoxPreference)this.findPreference(KEY_PLUGIN_ENABLED_PREFIX + pluginPackageName);
            if (pref == null || !pref.isChecked()) continue;
            entries.add(enginesArray[i].loadLabel(pm));
            values.add(pluginPackageName);
            enabledEngines = enabledEngines + pluginPackageName + " ";
        }
        ContentResolver resolver = this.getContentResolver();
        Settings.Secure.putString((ContentResolver)resolver, (String)"tts_enabled_plugins", (String)enabledEngines);
        CharSequence[] entriesArray = new CharSequence[entries.size()];
        CharSequence[] valuesArray = new CharSequence[values.size()];
        this.mDefaultSynthPref.setEntries(entries.toArray(entriesArray));
        this.mDefaultSynthPref.setEntryValues(values.toArray(valuesArray));
        String selectedEngine = Settings.Secure.getString((ContentResolver)this.getContentResolver(), (String)KEY_TTS_DEFAULT_SYNTH);
        int selectedEngineIndex = this.mDefaultSynthPref.findIndexOfValue(selectedEngine);
        if (selectedEngineIndex == -1) {
            selectedEngineIndex = this.mDefaultSynthPref.findIndexOfValue("com.svox.pico");
        }
        this.mDefaultSynthPref.setValueIndex(selectedEngineIndex);
    }
}

