/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.AssetManager;
import android.net.ConnectivityManager;
import android.os.Bundle;
import android.os.Environment;
import android.preference.CheckBoxPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceScreen;
import android.view.View;
import android.webkit.WebView;
import com.android.settings.Utils;
import com.android.settings.wifi.WifiApEnabler;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;

public class TetherSettings
extends PreferenceActivity {
    private static final String USB_TETHER_SETTINGS = "usb_tether_settings";
    private static final String ENABLE_WIFI_AP = "enable_wifi_ap";
    private static final String WIFI_AP_SETTINGS = "wifi_ap_settings";
    private static final String TETHERING_HELP = "tethering_help";
    private static final String USB_HELP_MODIFIER = "usb_";
    private static final String WIFI_HELP_MODIFIER = "wifi_";
    private static final String HELP_URL = "file:///android_asset/html/%y%z/tethering_%xhelp.html";
    private static final String HELP_PATH = "html/%y%z/tethering_help.html";
    private static final int DIALOG_TETHER_HELP = 1;
    private WebView mView;
    private CheckBoxPreference mUsbTether;
    private CheckBoxPreference mEnableWifiAp;
    private PreferenceScreen mWifiApSettings;
    private WifiApEnabler mWifiApEnabler;
    private PreferenceScreen mTetherHelp;
    private BroadcastReceiver mTetherChangeReceiver;
    private String[] mUsbRegexs;
    private ArrayList mUsbIfaces;
    private String[] mWifiRegexs;

    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.addPreferencesFromResource(2130968608);
        this.mEnableWifiAp = (CheckBoxPreference)this.findPreference(ENABLE_WIFI_AP);
        this.mWifiApSettings = (PreferenceScreen)this.findPreference(WIFI_AP_SETTINGS);
        this.mUsbTether = (CheckBoxPreference)this.findPreference(USB_TETHER_SETTINGS);
        this.mTetherHelp = (PreferenceScreen)this.findPreference(TETHERING_HELP);
        ConnectivityManager cm = (ConnectivityManager)this.getSystemService("connectivity");
        this.mUsbRegexs = cm.getTetherableUsbRegexs();
        if (this.mUsbRegexs.length == 0 || Utils.isMonkeyRunning()) {
            this.getPreferenceScreen().removePreference((Preference)this.mUsbTether);
            this.setTitle(2131231352);
        }
        this.mWifiRegexs = cm.getTetherableWifiRegexs();
        if (this.mWifiRegexs.length == 0) {
            this.getPreferenceScreen().removePreference((Preference)this.mEnableWifiAp);
            this.getPreferenceScreen().removePreference((Preference)this.mWifiApSettings);
            this.setTitle(2131231351);
        } else if (this.mUsbRegexs.length != 0) {
            this.setTitle(2131231353);
        }
        this.mWifiApEnabler = new WifiApEnabler((Context)this, this.mEnableWifiAp);
        this.mView = new WebView((Context)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dialog onCreateDialog(int id2) {
        if (id2 == 1) {
            Locale locale = Locale.getDefault();
            AssetManager am = this.getAssets();
            String path = HELP_PATH.replace("%y", locale.getLanguage().toLowerCase());
            path = path.replace("%z", "_" + locale.getCountry().toLowerCase());
            boolean useCountry = true;
            InputStream is = null;
            try {
                is = am.open(path);
            }
            catch (Exception e) {
                useCountry = false;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {}
                }
            }
            String url = HELP_URL.replace("%y", locale.getLanguage().toLowerCase());
            url = url.replace("%z", useCountry ? "_" + locale.getCountry().toLowerCase() : "");
            url = this.mUsbRegexs.length != 0 && this.mWifiRegexs.length == 0 ? url.replace("%x", USB_HELP_MODIFIER) : (this.mWifiRegexs.length != 0 && this.mUsbRegexs.length == 0 ? url.replace("%x", WIFI_HELP_MODIFIER) : url.replace("%x", ""));
            this.mView.loadUrl(url);
            return new AlertDialog.Builder((Context)this).setCancelable(true).setTitle(2131231364).setView((View)this.mView).create();
        }
        return null;
    }

    protected void onResume() {
        super.onResume();
        IntentFilter filter = new IntentFilter("android.net.conn.TETHER_STATE_CHANGED");
        this.mTetherChangeReceiver = new TetherChangeReceiver();
        Intent intent = this.registerReceiver(this.mTetherChangeReceiver, filter);
        filter = new IntentFilter();
        filter.addAction("android.intent.action.MEDIA_SHARED");
        filter.addAction("android.intent.action.MEDIA_UNSHARED");
        filter.addDataScheme("file");
        this.registerReceiver(this.mTetherChangeReceiver, filter);
        if (intent != null) {
            this.mTetherChangeReceiver.onReceive((Context)this, intent);
        }
        this.mWifiApEnabler.resume();
    }

    protected void onPause() {
        super.onPause();
        this.unregisterReceiver(this.mTetherChangeReceiver);
        this.mTetherChangeReceiver = null;
        this.mWifiApEnabler.pause();
    }

    private void updateState() {
        ConnectivityManager cm = (ConnectivityManager)this.getSystemService("connectivity");
        Object[] available = cm.getTetherableIfaces();
        Object[] tethered = cm.getTetheredIfaces();
        Object[] errored = cm.getTetheringErroredIfaces();
        this.updateState(available, tethered, errored);
    }

    private void updateState(Object[] available, Object[] tethered, Object[] errored) {
        String s;
        ConnectivityManager cm = (ConnectivityManager)this.getSystemService("connectivity");
        boolean usbTethered = false;
        boolean usbAvailable = false;
        int usbError = 0;
        boolean usbErrored = false;
        boolean massStorageActive = "shared".equals(Environment.getExternalStorageState());
        for (Object o : available) {
            s = (String)o;
            for (String regex : this.mUsbRegexs) {
                if (!s.matches(regex)) continue;
                usbAvailable = true;
                if (usbError != 0) continue;
                usbError = cm.getLastTetherError(s);
            }
        }
        for (Object o : tethered) {
            s = (String)o;
            for (String regex : this.mUsbRegexs) {
                if (!s.matches(regex)) continue;
                usbTethered = true;
            }
        }
        for (Object o : errored) {
            s = (String)o;
            for (String regex : this.mUsbRegexs) {
                if (!s.matches(regex)) continue;
                usbErrored = true;
            }
        }
        if (usbTethered) {
            this.mUsbTether.setSummary(2131231360);
            this.mUsbTether.setEnabled(true);
            this.mUsbTether.setChecked(true);
        } else if (usbAvailable) {
            if (usbError == 0) {
                this.mUsbTether.setSummary(2131231359);
            } else {
                this.mUsbTether.setSummary(2131231363);
            }
            this.mUsbTether.setEnabled(true);
            this.mUsbTether.setChecked(false);
        } else if (usbErrored) {
            this.mUsbTether.setSummary(2131231363);
            this.mUsbTether.setEnabled(false);
            this.mUsbTether.setChecked(false);
        } else if (massStorageActive) {
            this.mUsbTether.setSummary(2131231361);
            this.mUsbTether.setEnabled(false);
            this.mUsbTether.setChecked(false);
        } else {
            this.mUsbTether.setSummary(2131231362);
            this.mUsbTether.setEnabled(false);
            this.mUsbTether.setChecked(false);
        }
    }

    public boolean onPreferenceTreeClick(PreferenceScreen preferenceScreen, Preference preference) {
        if (preference == this.mUsbTether) {
            boolean newState = this.mUsbTether.isChecked();
            ConnectivityManager cm = (ConnectivityManager)this.getSystemService("connectivity");
            if (newState) {
                String[] available = cm.getTetherableIfaces();
                String usbIface = this.findIface(available, this.mUsbRegexs);
                if (usbIface == null) {
                    this.updateState();
                    return true;
                }
                if (cm.tether(usbIface) != 0) {
                    this.mUsbTether.setChecked(false);
                    this.mUsbTether.setSummary(2131231363);
                    return true;
                }
                this.mUsbTether.setSummary((CharSequence)"");
            } else {
                String[] tethered = cm.getTetheredIfaces();
                String usbIface = this.findIface(tethered, this.mUsbRegexs);
                if (usbIface == null) {
                    this.updateState();
                    return true;
                }
                if (cm.untether(usbIface) != 0) {
                    this.mUsbTether.setSummary(2131231363);
                    return true;
                }
                this.mUsbTether.setSummary((CharSequence)"");
            }
        } else if (preference == this.mTetherHelp) {
            this.showDialog(1);
        }
        return false;
    }

    private String findIface(String[] ifaces, String[] regexes) {
        for (String iface : ifaces) {
            for (String regex : regexes) {
                if (!iface.matches(regex)) continue;
                return iface;
            }
        }
        return null;
    }

    private class TetherChangeReceiver
    extends BroadcastReceiver {
        private TetherChangeReceiver() {
        }

        public void onReceive(Context content, Intent intent) {
            if (intent.getAction().equals("android.net.conn.TETHER_STATE_CHANGED")) {
                ArrayList available = intent.getStringArrayListExtra("availableArray");
                ArrayList active = intent.getStringArrayListExtra("activeArray");
                ArrayList errored = intent.getStringArrayListExtra("erroredArray");
                TetherSettings.this.updateState(available.toArray(), active.toArray(), errored.toArray());
            } else if (intent.getAction().equals("android.intent.action.MEDIA_SHARED") || intent.getAction().equals("android.intent.action.MEDIA_UNSHARED")) {
                TetherSettings.this.updateState();
            }
        }
    }
}

