/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.Bundle;
import android.preference.CheckBoxPreference;
import android.preference.ListPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceGroup;
import android.preference.PreferenceScreen;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.Log;

public class SoundSettings
extends PreferenceActivity
implements Preference.OnPreferenceChangeListener {
    private static final String TAG = "SoundAndDisplaysSettings";
    private static final int FALLBACK_SCREEN_TIMEOUT_VALUE = 30000;
    private static final int FALLBACK_EMERGENCY_TONE_VALUE = 0;
    private static final String KEY_SILENT = "silent";
    private static final String KEY_VIBRATE = "vibrate";
    private static final String KEY_DTMF_TONE = "dtmf_tone";
    private static final String KEY_SOUND_EFFECTS = "sound_effects";
    private static final String KEY_HAPTIC_FEEDBACK = "haptic_feedback";
    private static final String KEY_EMERGENCY_TONE = "emergency_tone";
    private static final String KEY_SOUND_SETTINGS = "sound_settings";
    private static final String KEY_NOTIFICATION_PULSE = "notification_pulse";
    private static final String KEY_LOCK_SOUNDS = "lock_sounds";
    private static final String VALUE_VIBRATE_NEVER = "never";
    private static final String VALUE_VIBRATE_ALWAYS = "always";
    private static final String VALUE_VIBRATE_ONLY_SILENT = "silent";
    private static final String VALUE_VIBRATE_UNLESS_SILENT = "notsilent";
    private CheckBoxPreference mSilent;
    private ListPreference mVibrate;
    private CheckBoxPreference mDtmfTone;
    private CheckBoxPreference mSoundEffects;
    private CheckBoxPreference mHapticFeedback;
    private CheckBoxPreference mNotificationPulse;
    private CheckBoxPreference mLockSounds;
    private AudioManager mAudioManager;
    private BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.media.RINGER_MODE_CHANGED")) {
                SoundSettings.this.updateState(false);
            }
        }
    };
    private PreferenceGroup mSoundSettings;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ContentResolver resolver = this.getContentResolver();
        int activePhoneType = TelephonyManager.getDefault().getPhoneType();
        this.mAudioManager = (AudioManager)this.getSystemService("audio");
        this.addPreferencesFromResource(2130968605);
        if (2 != activePhoneType) {
            this.getPreferenceScreen().removePreference(this.findPreference(KEY_EMERGENCY_TONE));
        }
        this.mSilent = (CheckBoxPreference)this.findPreference("silent");
        this.mVibrate = (ListPreference)this.findPreference(KEY_VIBRATE);
        this.mVibrate.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
        this.mDtmfTone = (CheckBoxPreference)this.findPreference(KEY_DTMF_TONE);
        this.mDtmfTone.setPersistent(false);
        this.mDtmfTone.setChecked(Settings.System.getInt((ContentResolver)resolver, (String)KEY_DTMF_TONE, (int)1) != 0);
        this.mSoundEffects = (CheckBoxPreference)this.findPreference(KEY_SOUND_EFFECTS);
        this.mSoundEffects.setPersistent(false);
        this.mSoundEffects.setChecked(Settings.System.getInt((ContentResolver)resolver, (String)"sound_effects_enabled", (int)0) != 0);
        this.mHapticFeedback = (CheckBoxPreference)this.findPreference(KEY_HAPTIC_FEEDBACK);
        this.mHapticFeedback.setPersistent(false);
        this.mHapticFeedback.setChecked(Settings.System.getInt((ContentResolver)resolver, (String)"haptic_feedback_enabled", (int)0) != 0);
        this.mLockSounds = (CheckBoxPreference)this.findPreference(KEY_LOCK_SOUNDS);
        this.mLockSounds.setPersistent(false);
        this.mLockSounds.setChecked(Settings.System.getInt((ContentResolver)resolver, (String)"lockscreen_sounds_enabled", (int)1) != 0);
        if (2 == activePhoneType) {
            ListPreference emergencyTonePreference = (ListPreference)this.findPreference(KEY_EMERGENCY_TONE);
            emergencyTonePreference.setValue(String.valueOf(Settings.System.getInt((ContentResolver)resolver, (String)KEY_EMERGENCY_TONE, (int)0)));
            emergencyTonePreference.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
        }
        this.mSoundSettings = (PreferenceGroup)this.findPreference(KEY_SOUND_SETTINGS);
        this.mNotificationPulse = (CheckBoxPreference)this.mSoundSettings.findPreference((CharSequence)KEY_NOTIFICATION_PULSE);
        if (this.mNotificationPulse != null && !this.getResources().getBoolean(2131099648)) {
            this.mSoundSettings.removePreference((Preference)this.mNotificationPulse);
        } else {
            try {
                this.mNotificationPulse.setChecked(Settings.System.getInt((ContentResolver)resolver, (String)"notification_light_pulse") == 1);
                this.mNotificationPulse.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
            }
            catch (Settings.SettingNotFoundException snfe) {
                Log.e((String)TAG, (String)"notification_light_pulse not found");
            }
        }
    }

    protected void onResume() {
        super.onResume();
        this.updateState(true);
        IntentFilter filter = new IntentFilter("android.media.RINGER_MODE_CHANGED");
        this.registerReceiver(this.mReceiver, filter);
    }

    protected void onPause() {
        super.onPause();
        this.unregisterReceiver(this.mReceiver);
    }

    private String getPhoneVibrateSettingValue() {
        boolean vibeInSilent = Settings.System.getInt((ContentResolver)this.getContentResolver(), (String)"vibrate_in_silent", (int)1) == 1;
        int callsVibrateSetting = this.mAudioManager.getVibrateSetting(0);
        if (vibeInSilent) {
            if (callsVibrateSetting == 0) {
                this.mAudioManager.setVibrateSetting(0, 2);
            }
            if (callsVibrateSetting == 1) {
                return VALUE_VIBRATE_ALWAYS;
            }
            return "silent";
        }
        if (callsVibrateSetting == 2) {
            this.mAudioManager.setVibrateSetting(0, 0);
        }
        if (callsVibrateSetting == 1) {
            return VALUE_VIBRATE_UNLESS_SILENT;
        }
        return VALUE_VIBRATE_NEVER;
    }

    private void setPhoneVibrateSettingValue(String value) {
        boolean vibeInSilent;
        int callsVibrateSetting;
        if (value.equals(VALUE_VIBRATE_UNLESS_SILENT)) {
            callsVibrateSetting = 1;
            vibeInSilent = false;
        } else if (value.equals(VALUE_VIBRATE_NEVER)) {
            callsVibrateSetting = 0;
            vibeInSilent = false;
        } else if (value.equals("silent")) {
            callsVibrateSetting = 2;
            vibeInSilent = true;
        } else {
            callsVibrateSetting = 1;
            vibeInSilent = true;
        }
        Settings.System.putInt((ContentResolver)this.getContentResolver(), (String)"vibrate_in_silent", (int)(vibeInSilent ? 1 : 0));
        if (this.mSilent.isChecked()) {
            this.mAudioManager.setRingerMode(vibeInSilent ? 1 : 0);
        }
        this.mAudioManager.setVibrateSetting(0, callsVibrateSetting);
    }

    private void updateState(boolean force) {
        String phoneVibrateSetting;
        boolean silentOrVibrateMode;
        int ringerMode = this.mAudioManager.getRingerMode();
        boolean bl = silentOrVibrateMode = ringerMode != 2;
        if (silentOrVibrateMode != this.mSilent.isChecked() || force) {
            this.mSilent.setChecked(silentOrVibrateMode);
        }
        if (!(phoneVibrateSetting = this.getPhoneVibrateSettingValue()).equals(this.mVibrate.getValue()) || force) {
            this.mVibrate.setValue(phoneVibrateSetting);
        }
        this.mVibrate.setSummary(this.mVibrate.getEntry());
        int silentModeStreams = Settings.System.getInt((ContentResolver)this.getContentResolver(), (String)"mode_ringer_streams_affected", (int)0);
        boolean isAlarmInclSilentMode = (silentModeStreams & 0x10) != 0;
        this.mSilent.setSummary(isAlarmInclSilentMode ? 2131231156 : 2131231155);
    }

    public boolean onPreferenceTreeClick(PreferenceScreen preferenceScreen, Preference preference) {
        if (preference == this.mSilent) {
            if (this.mSilent.isChecked()) {
                boolean vibeInSilent = 1 == Settings.System.getInt((ContentResolver)this.getContentResolver(), (String)"vibrate_in_silent", (int)1);
                this.mAudioManager.setRingerMode(vibeInSilent ? 1 : 0);
            } else {
                this.mAudioManager.setRingerMode(2);
            }
            this.updateState(false);
        } else if (preference == this.mDtmfTone) {
            Settings.System.putInt((ContentResolver)this.getContentResolver(), (String)KEY_DTMF_TONE, (int)(this.mDtmfTone.isChecked() ? 1 : 0));
        } else if (preference == this.mSoundEffects) {
            if (this.mSoundEffects.isChecked()) {
                this.mAudioManager.loadSoundEffects();
            } else {
                this.mAudioManager.unloadSoundEffects();
            }
            Settings.System.putInt((ContentResolver)this.getContentResolver(), (String)"sound_effects_enabled", (int)(this.mSoundEffects.isChecked() ? 1 : 0));
        } else if (preference == this.mHapticFeedback) {
            Settings.System.putInt((ContentResolver)this.getContentResolver(), (String)"haptic_feedback_enabled", (int)(this.mHapticFeedback.isChecked() ? 1 : 0));
        } else if (preference == this.mLockSounds) {
            Settings.System.putInt((ContentResolver)this.getContentResolver(), (String)"lockscreen_sounds_enabled", (int)(this.mLockSounds.isChecked() ? 1 : 0));
        } else if (preference == this.mNotificationPulse) {
            boolean value = this.mNotificationPulse.isChecked();
            Settings.System.putInt((ContentResolver)this.getContentResolver(), (String)"notification_light_pulse", (int)(value ? 1 : 0));
        }
        return true;
    }

    public boolean onPreferenceChange(Preference preference, Object objValue) {
        String key = preference.getKey();
        if (KEY_EMERGENCY_TONE.equals(key)) {
            int value = Integer.parseInt((String)objValue);
            try {
                Settings.System.putInt((ContentResolver)this.getContentResolver(), (String)KEY_EMERGENCY_TONE, (int)value);
            }
            catch (NumberFormatException e) {
                Log.e((String)TAG, (String)"could not persist emergency tone setting", (Throwable)e);
            }
        } else if (preference == this.mVibrate) {
            this.setPhoneVibrateSettingValue(objValue.toString());
            this.updateState(false);
        }
        return true;
    }
}

