/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.content.Context;
import android.os.Bundle;
import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;
import com.android.internal.app.AlertActivity;
import com.android.internal.app.AlertController;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;

public class SettingsLicenseActivity
extends AlertActivity {
    private static final String TAG = "SettingsLicenseActivity";
    private static final boolean LOGV = false;
    private static final String DEFAULT_LICENSE_PATH = "/system/etc/NOTICE.html.gz";
    private static final String PROPERTY_LICENSE_PATH = "ro.config.license_path";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        String fileName = SystemProperties.get((String)PROPERTY_LICENSE_PATH, (String)DEFAULT_LICENSE_PATH);
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            Log.e((String)TAG, (String)"The system property for the license file is empty.");
            this.showErrorAndFinish();
            return;
        }
        InputStreamReader inputReader = null;
        StringBuilder data = null;
        try {
            int numRead;
            data = new StringBuilder(2048);
            char[] tmp = new char[2048];
            inputReader = fileName.endsWith(".gz") ? new InputStreamReader(new GZIPInputStream(new FileInputStream(fileName))) : new FileReader(fileName);
            while ((numRead = inputReader.read(tmp)) >= 0) {
                data.append(tmp, 0, numRead);
            }
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)("License HTML file not found at " + fileName), (Throwable)e);
            this.showErrorAndFinish();
            return;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Error reading license HTML file at " + fileName), (Throwable)e);
            this.showErrorAndFinish();
            return;
        }
        finally {
            try {
                if (inputReader != null) {
                    inputReader.close();
                }
            }
            catch (IOException e) {}
        }
        if (TextUtils.isEmpty((CharSequence)data)) {
            Log.e((String)TAG, (String)("License HTML is empty (from " + fileName + ")"));
            this.showErrorAndFinish();
            return;
        }
        WebView webView = new WebView((Context)this);
        webView.loadDataWithBaseURL(null, data.toString(), "text/html", "utf-8", null);
        webView.setWebViewClient(new WebViewClient(){

            public void onPageFinished(WebView view, String url) {
                SettingsLicenseActivity.this.mAlert.setTitle((CharSequence)SettingsLicenseActivity.this.getString(2131231386));
            }
        });
        AlertController.AlertParams p = this.mAlertParams;
        p.mTitle = this.getString(2131231388);
        p.mView = webView;
        p.mForceInverseBackground = true;
        this.setupAlert();
    }

    private void showErrorAndFinish() {
        Toast.makeText((Context)this, (int)2131231387, (int)1).show();
        this.finish();
    }
}

