/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.admin.DevicePolicyManager;
import android.content.ContentQueryMap;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.os.Bundle;
import android.os.SystemProperties;
import android.preference.CheckBoxPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceCategory;
import android.preference.PreferenceManager;
import android.preference.PreferenceScreen;
import android.provider.Settings;
import android.security.Credentials;
import android.security.KeyStore;
import android.telephony.TelephonyManager;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import com.android.internal.widget.LockPatternUtils;
import com.android.settings.ChooseLockGeneric;
import com.android.settings.ChooseLockSettingsHelper;
import com.android.settings.DeviceAdminSettings;
import java.util.Observable;
import java.util.Observer;

public class SecuritySettings
extends PreferenceActivity {
    private static final String KEY_UNLOCK_SET_OR_CHANGE = "unlock_set_or_change";
    private static final String PACKAGE = "com.android.settings";
    private static final String ICC_LOCK_SETTINGS = "com.android.settings.IccLockSettings";
    private static final String KEY_LOCK_ENABLED = "lockenabled";
    private static final String KEY_VISIBLE_PATTERN = "visiblepattern";
    private static final String KEY_TACTILE_FEEDBACK_ENABLED = "unlock_tactile_feedback";
    private static final String PROPERTY_EFS_ENABLED = "persist.security.efs.enabled";
    private static final String PROPERTY_EFS_TRANSITION = "persist.security.efs.trans";
    private CheckBoxPreference mVisiblePattern;
    private CheckBoxPreference mTactileFeedback;
    private CheckBoxPreference mShowPassword;
    private static final String LOCATION_NETWORK = "location_network";
    private static final String LOCATION_GPS = "location_gps";
    private static final String ASSISTED_GPS = "assisted_gps";
    private static final int SET_OR_CHANGE_LOCK_METHOD_REQUEST = 123;
    private CredentialStorage mCredentialStorage = new CredentialStorage();
    private CheckBoxPreference mEncryptedFSEnabled;
    private CheckBoxPreference mNetwork;
    private CheckBoxPreference mGps;
    private CheckBoxPreference mAssistedGps;
    DevicePolicyManager mDPM;
    private ContentQueryMap mContentQueryMap;
    private ChooseLockSettingsHelper mChooseLockSettingsHelper;
    private LockPatternUtils mLockPatternUtils;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mLockPatternUtils = new LockPatternUtils((Context)this);
        this.mDPM = (DevicePolicyManager)this.getSystemService("device_policy");
        this.mChooseLockSettingsHelper = new ChooseLockSettingsHelper((Activity)this);
        this.createPreferenceHierarchy();
        this.updateToggles();
        Cursor settingsCursor = this.getContentResolver().query(Settings.Secure.CONTENT_URI, null, "(name=?)", new String[]{"location_providers_allowed"}, null);
        this.mContentQueryMap = new ContentQueryMap(settingsCursor, "name", true, null);
        this.mContentQueryMap.addObserver((Observer)new SettingsObserver());
    }

    private PreferenceScreen createPreferenceHierarchy() {
        PreferenceScreen root = this.getPreferenceScreen();
        if (root != null) {
            root.removeAll();
        }
        this.addPreferencesFromResource(2130968597);
        root = this.getPreferenceScreen();
        this.mNetwork = (CheckBoxPreference)this.getPreferenceScreen().findPreference((CharSequence)LOCATION_NETWORK);
        this.mGps = (CheckBoxPreference)this.getPreferenceScreen().findPreference((CharSequence)LOCATION_GPS);
        this.mAssistedGps = (CheckBoxPreference)this.getPreferenceScreen().findPreference((CharSequence)ASSISTED_GPS);
        PreferenceManager pm = this.getPreferenceManager();
        if (!this.mLockPatternUtils.isSecure()) {
            this.addPreferencesFromResource(2130968598);
        } else {
            switch (this.mLockPatternUtils.getKeyguardStoredPasswordQuality()) {
                case 65536: {
                    this.addPreferencesFromResource(2130968600);
                    break;
                }
                case 131072: {
                    this.addPreferencesFromResource(2130968602);
                    break;
                }
                case 262144: 
                case 327680: {
                    this.addPreferencesFromResource(2130968599);
                }
            }
        }
        this.mVisiblePattern = (CheckBoxPreference)pm.findPreference((CharSequence)KEY_VISIBLE_PATTERN);
        this.mTactileFeedback = (CheckBoxPreference)pm.findPreference((CharSequence)KEY_TACTILE_FEEDBACK_ENABLED);
        int activePhoneType = TelephonyManager.getDefault().getPhoneType();
        if (2 != activePhoneType) {
            PreferenceScreen simLockPreferences = this.getPreferenceManager().createPreferenceScreen((Context)this);
            simLockPreferences.setTitle(2131231221);
            simLockPreferences.setIntent(new Intent().setClassName(PACKAGE, ICC_LOCK_SETTINGS));
            PreferenceCategory simLockCat = new PreferenceCategory((Context)this);
            simLockCat.setTitle(2131231222);
            root.addPreference((Preference)simLockCat);
            simLockCat.addPreference((Preference)simLockPreferences);
        }
        PreferenceCategory passwordsCat = new PreferenceCategory((Context)this);
        passwordsCat.setTitle(2131230955);
        root.addPreference((Preference)passwordsCat);
        CheckBoxPreference showPassword = this.mShowPassword = new CheckBoxPreference((Context)this);
        showPassword.setKey("show_password");
        showPassword.setTitle(2131231557);
        showPassword.setSummary(2131231558);
        showPassword.setPersistent(false);
        passwordsCat.addPreference((Preference)showPassword);
        PreferenceCategory devicePoliciesCat = new PreferenceCategory((Context)this);
        devicePoliciesCat.setTitle(2131230990);
        root.addPreference((Preference)devicePoliciesCat);
        Preference deviceAdminButton = new Preference((Context)this);
        deviceAdminButton.setTitle(2131230991);
        deviceAdminButton.setSummary(2131230992);
        Intent deviceAdminIntent = new Intent();
        deviceAdminIntent.setClass((Context)this, DeviceAdminSettings.class);
        deviceAdminButton.setIntent(deviceAdminIntent);
        devicePoliciesCat.addPreference(deviceAdminButton);
        PreferenceCategory credentialsCat = new PreferenceCategory((Context)this);
        credentialsCat.setTitle(2131231816);
        root.addPreference((Preference)credentialsCat);
        this.mCredentialStorage.createPreferences(credentialsCat, 0);
        PreferenceCategory encryptedfsCat = new PreferenceCategory((Context)this);
        encryptedfsCat.setTitle(2131231842);
        this.mCredentialStorage.createPreferences(encryptedfsCat, 1);
        return root;
    }

    protected void onResume() {
        super.onResume();
        LockPatternUtils lockPatternUtils = this.mChooseLockSettingsHelper.utils();
        if (this.mVisiblePattern != null) {
            this.mVisiblePattern.setChecked(lockPatternUtils.isVisiblePatternEnabled());
        }
        if (this.mTactileFeedback != null) {
            this.mTactileFeedback.setChecked(lockPatternUtils.isTactileFeedbackEnabled());
        }
        this.mShowPassword.setChecked(Settings.System.getInt((ContentResolver)this.getContentResolver(), (String)"show_password", (int)1) != 0);
        this.mCredentialStorage.resume();
    }

    public boolean onPreferenceTreeClick(PreferenceScreen preferenceScreen, Preference preference) {
        String key = preference.getKey();
        LockPatternUtils lockPatternUtils = this.mChooseLockSettingsHelper.utils();
        if (KEY_UNLOCK_SET_OR_CHANGE.equals(key)) {
            Intent intent = new Intent((Context)this, ChooseLockGeneric.class);
            this.startActivityForResult(intent, 123);
        } else if (KEY_LOCK_ENABLED.equals(key)) {
            lockPatternUtils.setLockPatternEnabled(this.isToggled(preference));
        } else if (KEY_VISIBLE_PATTERN.equals(key)) {
            lockPatternUtils.setVisiblePatternEnabled(this.isToggled(preference));
        } else if (KEY_TACTILE_FEEDBACK_ENABLED.equals(key)) {
            lockPatternUtils.setTactileFeedbackEnabled(this.isToggled(preference));
        } else if (preference == this.mShowPassword) {
            Settings.System.putInt((ContentResolver)this.getContentResolver(), (String)"show_password", (int)(this.mShowPassword.isChecked() ? 1 : 0));
        } else if (preference == this.mNetwork) {
            Settings.Secure.setLocationProviderEnabled((ContentResolver)this.getContentResolver(), (String)"network", (boolean)this.mNetwork.isChecked());
        } else if (preference == this.mGps) {
            boolean enabled = this.mGps.isChecked();
            Settings.Secure.setLocationProviderEnabled((ContentResolver)this.getContentResolver(), (String)"gps", (boolean)enabled);
            if (this.mAssistedGps != null) {
                this.mAssistedGps.setEnabled(enabled);
            }
        } else if (preference == this.mAssistedGps) {
            Settings.Secure.putInt((ContentResolver)this.getContentResolver(), (String)"assisted_gps_enabled", (int)(this.mAssistedGps.isChecked() ? 1 : 0));
        }
        return false;
    }

    private void updateToggles() {
        ContentResolver res = this.getContentResolver();
        boolean gpsEnabled = Settings.Secure.isLocationProviderEnabled((ContentResolver)res, (String)"gps");
        this.mNetwork.setChecked(Settings.Secure.isLocationProviderEnabled((ContentResolver)res, (String)"network"));
        this.mGps.setChecked(gpsEnabled);
        if (this.mAssistedGps != null) {
            this.mAssistedGps.setChecked(Settings.Secure.getInt((ContentResolver)res, (String)"assisted_gps_enabled", (int)2) == 1);
            this.mAssistedGps.setEnabled(gpsEnabled);
        }
    }

    private boolean isToggled(Preference pref) {
        return ((CheckBoxPreference)pref).isChecked();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        this.createPreferenceHierarchy();
    }

    private class CredentialStorage
    implements DialogInterface.OnClickListener,
    DialogInterface.OnDismissListener,
    Preference.OnPreferenceChangeListener,
    Preference.OnPreferenceClickListener {
        private static final int MINIMUM_PASSWORD_LENGTH = 8;
        private static final int TYPE_KEYSTORE = 0;
        private static final int TYPE_ENCRYPTEDFS = 1;
        private static final int DLG_BASE = 0;
        private static final int DLG_UNLOCK = 1;
        private static final int DLG_PASSWORD = 2;
        private static final int DLG_RESET = 3;
        private static final int DLG_ENABLE_EFS = 4;
        private KeyStore mKeyStore = KeyStore.getInstance();
        private int mState;
        private boolean mSubmit = false;
        private boolean mExternal = false;
        private boolean mWillEnableEncryptedFS;
        private int mShowingDialog = 0;
        private CheckBoxPreference mAccessCheckBox;
        private Preference mInstallButton;
        private Preference mPasswordButton;
        private Preference mResetButton;
        private CheckBoxPreference mEncryptedFSEnabled;

        private CredentialStorage() {
        }

        void resume() {
            this.mState = this.mKeyStore.test();
            this.updatePreferences(this.mState);
            Intent intent = SecuritySettings.this.getIntent();
            if (!this.mExternal && intent != null && "android.credentials.UNLOCK".equals(intent.getAction())) {
                this.mExternal = true;
                if (this.mState == 3) {
                    this.showPasswordDialog();
                } else if (this.mState == 2) {
                    this.showUnlockDialog();
                } else {
                    SecuritySettings.this.finish();
                }
            }
        }

        private void initialize(String password) {
            this.mKeyStore.password(password);
            this.updatePreferences(1);
        }

        private void reset() {
            this.mKeyStore.reset();
            this.updatePreferences(3);
        }

        private void lock() {
            this.mKeyStore.lock();
            this.updatePreferences(2);
        }

        private int unlock(String password) {
            this.mKeyStore.unlock(password);
            return this.mKeyStore.getLastError();
        }

        private int changePassword(String oldPassword, String newPassword) {
            this.mKeyStore.password(oldPassword, newPassword);
            return this.mKeyStore.getLastError();
        }

        public boolean onPreferenceChange(Preference preference, Object value) {
            if (preference == this.mAccessCheckBox) {
                if (((Boolean)value).booleanValue()) {
                    this.showUnlockDialog();
                } else {
                    this.lock();
                }
                return true;
            }
            if (preference == this.mEncryptedFSEnabled) {
                Boolean bval = (Boolean)value;
                this.mWillEnableEncryptedFS = bval;
                this.showSwitchEncryptedFSDialog();
            }
            return true;
        }

        public boolean onPreferenceClick(Preference preference) {
            if (preference == this.mInstallButton) {
                Credentials.getInstance().installFromSdCard((Context)SecuritySettings.this);
            } else if (preference == this.mPasswordButton) {
                this.showPasswordDialog();
            } else if (preference == this.mResetButton) {
                this.showResetDialog();
            } else {
                return false;
            }
            return true;
        }

        public void onClick(DialogInterface dialog, int button) {
            if (this.mShowingDialog != 4) {
                boolean bl = this.mSubmit = button == -1;
                if (button == -3) {
                    this.reset();
                }
            } else if (button == -1) {
                Intent intent = new Intent("android.intent.action.MASTER_CLEAR");
                intent.putExtra("enableEFS", this.mWillEnableEncryptedFS);
                SecuritySettings.this.sendBroadcast(intent);
                this.updatePreferences(this.mState);
            } else if (button == -2) {
                Toast.makeText((Context)SecuritySettings.this, (int)2131231850, (int)0).show();
                this.updatePreferences(this.mState);
            } else {
                return;
            }
        }

        public void onDismiss(DialogInterface dialog) {
            if (this.mSubmit && !SecuritySettings.this.isFinishing()) {
                this.mSubmit = false;
                if (!this.checkPassword((Dialog)dialog)) {
                    ((Dialog)dialog).show();
                    return;
                }
            }
            this.updatePreferences(this.mState);
            if (this.mExternal) {
                SecuritySettings.this.finish();
            }
        }

        private boolean checkPassword(Dialog dialog) {
            String oldPassword = this.getText(dialog, 2131427367);
            String newPassword = this.getText(dialog, 2131427368);
            String confirmPassword = this.getText(dialog, 2131427369);
            if (oldPassword != null && oldPassword.length() == 0) {
                this.showError(dialog, 2131231837, new Object[0]);
                return false;
            }
            if (newPassword == null) {
                return !this.checkError(dialog, this.unlock(oldPassword));
            }
            if (newPassword.length() == 0 || confirmPassword.length() == 0) {
                this.showError(dialog, 2131231836, new Object[0]);
            } else if (newPassword.length() < 8) {
                this.showError(dialog, 2131231838, new Object[0]);
            } else if (!newPassword.equals(confirmPassword)) {
                this.showError(dialog, 2131231835, new Object[0]);
            } else {
                if (oldPassword == null) {
                    this.initialize(newPassword);
                    return true;
                }
                return !this.checkError(dialog, this.changePassword(oldPassword, newPassword));
            }
            return false;
        }

        private boolean checkError(Dialog dialog, int error) {
            if (error == 1) {
                this.updatePreferences(1);
                return false;
            }
            if (error == 3) {
                this.updatePreferences(3);
                return false;
            }
            if (error < 10) {
                return false;
            }
            int count = error - 10 + 1;
            if (count > 3) {
                this.showError(dialog, 2131231832, new Object[0]);
            } else if (count == 1) {
                this.showError(dialog, 2131231833, new Object[0]);
            } else {
                this.showError(dialog, 2131231834, count);
            }
            return true;
        }

        private String getText(Dialog dialog, int viewId) {
            TextView view = (TextView)dialog.findViewById(viewId);
            return view == null || view.getVisibility() == 8 ? null : ((Object)view.getText()).toString();
        }

        private void showError(Dialog dialog, int stringId, Object ... formatArgs) {
            TextView view = (TextView)dialog.findViewById(2131427365);
            if (view != null) {
                if (formatArgs == null || formatArgs.length == 0) {
                    view.setText(stringId);
                } else {
                    view.setText((CharSequence)dialog.getContext().getString(stringId, formatArgs));
                }
                view.setVisibility(0);
            }
        }

        private void createPreferences(PreferenceCategory category, int type) {
            switch (type) {
                case 0: {
                    this.mAccessCheckBox = new CheckBoxPreference((Context)SecuritySettings.this);
                    this.mAccessCheckBox.setTitle(2131231817);
                    this.mAccessCheckBox.setSummary(2131231818);
                    this.mAccessCheckBox.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
                    category.addPreference((Preference)this.mAccessCheckBox);
                    this.mInstallButton = new Preference((Context)SecuritySettings.this);
                    this.mInstallButton.setTitle(2131231821);
                    this.mInstallButton.setSummary(2131231822);
                    this.mInstallButton.setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
                    category.addPreference(this.mInstallButton);
                    this.mPasswordButton = new Preference((Context)SecuritySettings.this);
                    this.mPasswordButton.setTitle(2131231823);
                    this.mPasswordButton.setSummary(2131231824);
                    this.mPasswordButton.setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
                    category.addPreference(this.mPasswordButton);
                    this.mResetButton = new Preference((Context)SecuritySettings.this);
                    this.mResetButton.setTitle(2131231825);
                    this.mResetButton.setSummary(2131231826);
                    this.mResetButton.setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
                    category.addPreference(this.mResetButton);
                    break;
                }
                case 1: {
                    this.mEncryptedFSEnabled = new CheckBoxPreference((Context)SecuritySettings.this);
                    this.mEncryptedFSEnabled.setTitle(2131231843);
                    this.mEncryptedFSEnabled.setSummary(2131231844);
                    this.mEncryptedFSEnabled.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
                }
            }
        }

        private void updatePreferences(int state) {
            this.mAccessCheckBox.setChecked(state == 1);
            boolean encFSEnabled = SystemProperties.getBoolean((String)SecuritySettings.PROPERTY_EFS_ENABLED, (boolean)false);
            this.mResetButton.setEnabled(!encFSEnabled && state != 3);
            this.mAccessCheckBox.setEnabled(state != 3 && !encFSEnabled);
            this.mEncryptedFSEnabled.setChecked(encFSEnabled);
            if (this.mState == state) {
                return;
            }
            if (state == 1) {
                Toast.makeText((Context)SecuritySettings.this, (int)2131231840, (int)0).show();
            } else if (state == 3) {
                Toast.makeText((Context)SecuritySettings.this, (int)2131231839, (int)0).show();
            } else if (state == 2) {
                Toast.makeText((Context)SecuritySettings.this, (int)2131231841, (int)0).show();
            }
            this.mState = state;
        }

        private void showUnlockDialog() {
            View view = View.inflate((Context)SecuritySettings.this, (int)2130903056, null);
            if (this.mExternal) {
                view.findViewById(2131427364).setVisibility(0);
            }
            AlertDialog dialog = new AlertDialog.Builder((Context)SecuritySettings.this).setView(view).setTitle(2131231819).setPositiveButton(17039370, (DialogInterface.OnClickListener)this).setNegativeButton(0x1040000, (DialogInterface.OnClickListener)this).create();
            dialog.setOnDismissListener((DialogInterface.OnDismissListener)this);
            this.mShowingDialog = 1;
            dialog.show();
        }

        private void showPasswordDialog() {
            View view = View.inflate((Context)SecuritySettings.this, (int)2130903055, null);
            if (this.mState == 3) {
                view.findViewById(2131427364).setVisibility(0);
            } else {
                view.findViewById(2131427366).setVisibility(0);
                view.findViewById(2131427367).setVisibility(0);
            }
            AlertDialog dialog = new AlertDialog.Builder((Context)SecuritySettings.this).setView(view).setTitle(2131231823).setPositiveButton(17039370, (DialogInterface.OnClickListener)this).setNegativeButton(0x1040000, (DialogInterface.OnClickListener)this).create();
            dialog.setOnDismissListener((DialogInterface.OnDismissListener)this);
            this.mShowingDialog = 2;
            dialog.show();
        }

        private void showResetDialog() {
            this.mShowingDialog = 3;
            new AlertDialog.Builder((Context)SecuritySettings.this).setTitle(0x1040014).setIcon(17301543).setMessage(2131231827).setNeutralButton((CharSequence)SecuritySettings.this.getString(17039370), (DialogInterface.OnClickListener)this).setNegativeButton((CharSequence)SecuritySettings.this.getString(0x1040000), (DialogInterface.OnClickListener)this).create().show();
        }

        private void showSwitchEncryptedFSDialog() {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)SecuritySettings.this).setCancelable(false).setTitle(2131231851);
            this.mShowingDialog = 4;
            if (this.mWillEnableEncryptedFS) {
                builder.setMessage(2131231845).setPositiveButton(2131231847, (DialogInterface.OnClickListener)this).setNegativeButton(2131231849, (DialogInterface.OnClickListener)this).create().show();
            } else {
                builder.setMessage(2131231846).setPositiveButton(2131231848, (DialogInterface.OnClickListener)this).setNegativeButton(2131231849, (DialogInterface.OnClickListener)this).create().show();
            }
        }
    }

    private final class SettingsObserver
    implements Observer {
        private SettingsObserver() {
        }

        public void update(Observable o, Object arg) {
            SecuritySettings.this.updateToggles();
        }
    }
}

