/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.app.Dialog;
import android.content.ContentResolver;
import android.content.Context;
import android.media.AudioManager;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.Preference;
import android.preference.VolumePreference;
import android.provider.Settings;
import android.util.AttributeSet;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.SeekBar;
import android.widget.TextView;

public class RingerVolumePreference
extends VolumePreference
implements CompoundButton.OnCheckedChangeListener {
    private static final String TAG = "RingerVolumePreference";
    private CheckBox mNotificationsUseRingVolumeCheckbox;
    private VolumePreference.SeekBarVolumizer[] mSeekBarVolumizer;
    private static final int[] SEEKBAR_ID = new int[]{2131427451, 2131427447, 2131427448};
    private static final int[] SEEKBAR_TYPE = new int[]{5, 3, 4};
    private TextView mNotificationVolumeTitle;

    public RingerVolumePreference(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setStreamType(2);
        this.setDialogLayoutResource(2130903083);
        this.setDialogIcon(2130837569);
        this.mSeekBarVolumizer = new VolumePreference.SeekBarVolumizer[SEEKBAR_ID.length];
    }

    protected void onBindDialogView(View view) {
        super.onBindDialogView(view);
        for (int i = 0; i < SEEKBAR_ID.length; ++i) {
            SeekBar seekBar = (SeekBar)view.findViewById(SEEKBAR_ID[i]);
            this.mSeekBarVolumizer[i] = new VolumePreference.SeekBarVolumizer((VolumePreference)this, this.getContext(), seekBar, SEEKBAR_TYPE[i]);
        }
        this.mNotificationVolumeTitle = (TextView)view.findViewById(2131427450);
        this.mNotificationsUseRingVolumeCheckbox = (CheckBox)view.findViewById(2131427449);
        this.mNotificationsUseRingVolumeCheckbox.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        this.mNotificationsUseRingVolumeCheckbox.setChecked(Settings.System.getInt((ContentResolver)this.getContext().getContentResolver(), (String)"notifications_use_ring_volume", (int)1) == 1);
        this.setNotificationVolumeVisibility(!this.mNotificationsUseRingVolumeCheckbox.isChecked());
    }

    protected void onDialogClosed(boolean positiveResult) {
        super.onDialogClosed(positiveResult);
        if (!positiveResult) {
            for (VolumePreference.SeekBarVolumizer vol : this.mSeekBarVolumizer) {
                if (vol == null) continue;
                vol.revertVolume();
            }
        }
        this.cleanup();
    }

    public void onActivityStop() {
        super.onActivityStop();
        this.cleanup();
    }

    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        this.setNotificationVolumeVisibility(!isChecked);
        Settings.System.putInt((ContentResolver)this.getContext().getContentResolver(), (String)"notifications_use_ring_volume", (int)(isChecked ? 1 : 0));
        if (isChecked) {
            AudioManager audioManager = (AudioManager)this.getContext().getSystemService("audio");
            audioManager.setStreamVolume(5, audioManager.getStreamVolume(2), 0);
        }
    }

    protected void onSampleStarting(VolumePreference.SeekBarVolumizer volumizer) {
        super.onSampleStarting(volumizer);
        for (VolumePreference.SeekBarVolumizer vol : this.mSeekBarVolumizer) {
            if (vol == null || vol == volumizer) continue;
            vol.stopSample();
        }
    }

    private void setNotificationVolumeVisibility(boolean visible) {
        if (this.mSeekBarVolumizer[0] != null) {
            this.mSeekBarVolumizer[0].getSeekBar().setVisibility(visible ? 0 : 8);
        }
        this.mNotificationVolumeTitle.setVisibility(visible ? 0 : 8);
    }

    private void cleanup() {
        for (int i = 0; i < SEEKBAR_ID.length; ++i) {
            if (this.mSeekBarVolumizer[i] == null) continue;
            Dialog dialog = this.getDialog();
            if (dialog != null && dialog.isShowing()) {
                this.mSeekBarVolumizer[i].revertVolume();
            }
            this.mSeekBarVolumizer[i].stop();
            this.mSeekBarVolumizer[i] = null;
        }
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        if (this.isPersistent()) {
            return superState;
        }
        SavedState myState = new SavedState(superState);
        VolumePreference.VolumeStore[] volumeStore = myState.getVolumeStore(SEEKBAR_ID.length);
        for (int i = 0; i < SEEKBAR_ID.length; ++i) {
            VolumePreference.SeekBarVolumizer vol = this.mSeekBarVolumizer[i];
            if (vol == null) continue;
            vol.onSaveInstanceState(volumeStore[i]);
        }
        return myState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state == null || !state.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState myState = (SavedState)state;
        super.onRestoreInstanceState(myState.getSuperState());
        VolumePreference.VolumeStore[] volumeStore = myState.getVolumeStore(SEEKBAR_ID.length);
        for (int i = 0; i < SEEKBAR_ID.length; ++i) {
            VolumePreference.SeekBarVolumizer vol = this.mSeekBarVolumizer[i];
            if (vol == null) continue;
            vol.onRestoreInstanceState(volumeStore[i]);
        }
    }

    private static class SavedState
    extends Preference.BaseSavedState {
        VolumePreference.VolumeStore[] mVolumeStore;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcel source) {
            super(source);
            this.mVolumeStore = new VolumePreference.VolumeStore[SEEKBAR_ID.length];
            for (int i = 0; i < SEEKBAR_ID.length; ++i) {
                this.mVolumeStore[i] = new VolumePreference.VolumeStore();
                this.mVolumeStore[i].volume = source.readInt();
                this.mVolumeStore[i].originalVolume = source.readInt();
            }
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            for (int i = 0; i < SEEKBAR_ID.length; ++i) {
                dest.writeInt(this.mVolumeStore[i].volume);
                dest.writeInt(this.mVolumeStore[i].originalVolume);
            }
        }

        VolumePreference.VolumeStore[] getVolumeStore(int count) {
            if (this.mVolumeStore == null || this.mVolumeStore.length != count) {
                this.mVolumeStore = new VolumePreference.VolumeStore[count];
                for (int i = 0; i < count; ++i) {
                    this.mVolumeStore[i] = new VolumePreference.VolumeStore();
                }
            }
            return this.mVolumeStore;
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }
    }
}

