/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.INetStatService;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.telephony.CellLocation;
import android.telephony.NeighboringCellInfo;
import android.telephony.PhoneStateListener;
import android.telephony.ServiceState;
import android.telephony.TelephonyManager;
import android.telephony.cdma.CdmaCellLocation;
import android.telephony.gsm.GsmCellLocation;
import android.text.format.DateUtils;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import com.android.internal.telephony.DataConnection;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.PhoneStateIntentReceiver;
import com.android.internal.telephony.gsm.GsmDataConnection;
import com.android.settings.BandMode;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadioInfo
extends Activity {
    private final String TAG = "phone";
    private static final int EVENT_PHONE_STATE_CHANGED = 100;
    private static final int EVENT_SIGNAL_STRENGTH_CHANGED = 200;
    private static final int EVENT_SERVICE_STATE_CHANGED = 300;
    private static final int EVENT_CFI_CHANGED = 302;
    private static final int EVENT_QUERY_PREFERRED_TYPE_DONE = 1000;
    private static final int EVENT_SET_PREFERRED_TYPE_DONE = 1001;
    private static final int EVENT_QUERY_NEIGHBORING_CIDS_DONE = 1002;
    private static final int EVENT_QUERY_SMSC_DONE = 1005;
    private static final int EVENT_UPDATE_SMSC_DONE = 1006;
    private static final int MENU_ITEM_SELECT_BAND = 0;
    private static final int MENU_ITEM_VIEW_ADN = 1;
    private static final int MENU_ITEM_VIEW_FDN = 2;
    private static final int MENU_ITEM_VIEW_SDN = 3;
    private static final int MENU_ITEM_GET_PDP_LIST = 4;
    private static final int MENU_ITEM_TOGGLE_DATA = 5;
    static final String ENABLE_DATA_STR = "Enable data connection";
    static final String DISABLE_DATA_STR = "Disable data connection";
    private TextView mDeviceId;
    private TextView number;
    private TextView callState;
    private TextView operatorName;
    private TextView roamingState;
    private TextView gsmState;
    private TextView gprsState;
    private TextView network;
    private TextView dBm;
    private TextView mMwi;
    private TextView mCfi;
    private TextView mLocation;
    private TextView mNeighboringCids;
    private TextView resets;
    private TextView attempts;
    private TextView successes;
    private TextView disconnects;
    private TextView sentSinceReceived;
    private TextView sent;
    private TextView received;
    private TextView mPingIpAddr;
    private TextView mPingHostname;
    private TextView mHttpClientTest;
    private TextView dnsCheckState;
    private EditText smsc;
    private Button radioPowerButton;
    private Button dnsCheckToggleButton;
    private Button pingTestButton;
    private Button updateSmscButton;
    private Button refreshSmscButton;
    private Button oemInfoButton;
    private Spinner preferredNetworkType;
    private TelephonyManager mTelephonyManager;
    private Phone phone = null;
    private PhoneStateIntentReceiver mPhoneStateReceiver;
    private INetStatService netstat;
    private String mPingIpAddrResult;
    private String mPingHostnameResult;
    private String mHttpClientTestResult;
    private boolean mMwiValue = false;
    private boolean mCfiValue = false;
    private PhoneStateListener mPhoneStateListener = new PhoneStateListener(){

        public void onDataConnectionStateChanged(int state) {
            RadioInfo.this.updateDataState();
            RadioInfo.this.updateDataStats();
            RadioInfo.this.updatePdpList();
            RadioInfo.this.updateNetworkType();
        }

        public void onDataActivity(int direction) {
            RadioInfo.this.updateDataStats2();
        }

        public void onCellLocationChanged(CellLocation location) {
            RadioInfo.this.updateLocation(location);
        }

        public void onMessageWaitingIndicatorChanged(boolean mwi) {
            RadioInfo.this.mMwiValue = mwi;
            RadioInfo.this.updateMessageWaiting();
        }

        public void onCallForwardingIndicatorChanged(boolean cfi) {
            RadioInfo.this.mCfiValue = cfi;
            RadioInfo.this.updateCallRedirect();
        }
    };
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 100: {
                    RadioInfo.this.updatePhoneState();
                    break;
                }
                case 200: {
                    RadioInfo.this.updateSignalStrength();
                    break;
                }
                case 300: {
                    RadioInfo.this.updateServiceState();
                    RadioInfo.this.updatePowerState();
                    break;
                }
                case 1000: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception == null) {
                        int type = ((int[])ar.result)[0];
                        RadioInfo.this.preferredNetworkType.setSelection(type, true);
                        break;
                    }
                    RadioInfo.this.preferredNetworkType.setSelection(8, true);
                    break;
                }
                case 1001: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception == null) break;
                    RadioInfo.this.phone.getPreferredNetworkType(this.obtainMessage(1000));
                    break;
                }
                case 1002: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception == null) {
                        RadioInfo.this.updateNeighboringCids((ArrayList)ar.result);
                        break;
                    }
                    RadioInfo.this.mNeighboringCids.setText((CharSequence)"unknown");
                    break;
                }
                case 1005: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        RadioInfo.this.smsc.setText((CharSequence)"refresh error");
                        break;
                    }
                    RadioInfo.this.smsc.setText((CharSequence)((String)ar.result));
                    break;
                }
                case 1006: {
                    RadioInfo.this.updateSmscButton.setEnabled(true);
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception == null) break;
                    RadioInfo.this.smsc.setText((CharSequence)"update error");
                    break;
                }
            }
        }
    };
    private MenuItem.OnMenuItemClickListener mViewADNCallback = new MenuItem.OnMenuItemClickListener(){

        public boolean onMenuItemClick(MenuItem item) {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setClassName("com.android.phone", "com.android.phone.SimContacts");
            RadioInfo.this.startActivity(intent);
            return true;
        }
    };
    private MenuItem.OnMenuItemClickListener mViewFDNCallback = new MenuItem.OnMenuItemClickListener(){

        public boolean onMenuItemClick(MenuItem item) {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setClassName("com.android.phone", "com.android.phone.FdnList");
            RadioInfo.this.startActivity(intent);
            return true;
        }
    };
    private MenuItem.OnMenuItemClickListener mViewSDNCallback = new MenuItem.OnMenuItemClickListener(){

        public boolean onMenuItemClick(MenuItem item) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"content://icc/sdn"));
            intent.setClassName("com.android.phone", "com.android.phone.ADNList");
            RadioInfo.this.startActivity(intent);
            return true;
        }
    };
    private MenuItem.OnMenuItemClickListener mGetPdpList = new MenuItem.OnMenuItemClickListener(){

        public boolean onMenuItemClick(MenuItem item) {
            RadioInfo.this.phone.getDataCallList(null);
            return true;
        }
    };
    private MenuItem.OnMenuItemClickListener mSelectBandCallback = new MenuItem.OnMenuItemClickListener(){

        public boolean onMenuItemClick(MenuItem item) {
            Intent intent = new Intent();
            intent.setClass((Context)RadioInfo.this, BandMode.class);
            RadioInfo.this.startActivity(intent);
            return true;
        }
    };
    private MenuItem.OnMenuItemClickListener mToggleData = new MenuItem.OnMenuItemClickListener(){

        public boolean onMenuItemClick(MenuItem item) {
            int state = RadioInfo.this.mTelephonyManager.getDataState();
            switch (state) {
                case 2: {
                    RadioInfo.this.phone.disableDataConnectivity();
                    break;
                }
                case 0: {
                    RadioInfo.this.phone.enableDataConnectivity();
                    break;
                }
            }
            return true;
        }
    };
    View.OnClickListener mPowerButtonHandler = new View.OnClickListener(){

        public void onClick(View v) {
            RadioInfo.this.phone.setRadioPower(!RadioInfo.this.isRadioOn());
        }
    };
    View.OnClickListener mDnsCheckButtonHandler = new View.OnClickListener(){

        public void onClick(View v) {
            RadioInfo.this.phone.disableDnsCheck(!RadioInfo.this.phone.isDnsCheckDisabled());
            RadioInfo.this.updateDnsCheckState();
        }
    };
    View.OnClickListener mOemInfoButtonHandler = new View.OnClickListener(){

        public void onClick(View v) {
            Intent intent = new Intent("com.android.settings.OEM_RADIO_INFO");
            try {
                RadioInfo.this.startActivity(intent);
            }
            catch (ActivityNotFoundException ex) {
                Log.d((String)"phone", (String)("OEM-specific Info/Settings Activity Not Found : " + (Object)((Object)ex)));
            }
        }
    };
    View.OnClickListener mPingButtonHandler = new View.OnClickListener(){

        public void onClick(View v) {
            RadioInfo.this.updatePingState();
        }
    };
    View.OnClickListener mUpdateSmscButtonHandler = new View.OnClickListener(){

        public void onClick(View v) {
            RadioInfo.this.updateSmscButton.setEnabled(false);
            RadioInfo.this.phone.setSmscAddress(RadioInfo.this.smsc.getText().toString(), RadioInfo.this.mHandler.obtainMessage(1006));
        }
    };
    View.OnClickListener mRefreshSmscButtonHandler = new View.OnClickListener(){

        public void onClick(View v) {
            RadioInfo.this.refreshSmsc();
        }
    };
    AdapterView.OnItemSelectedListener mPreferredNetworkHandler = new AdapterView.OnItemSelectedListener(){

        public void onItemSelected(AdapterView parent, View v, int pos, long id2) {
            Message msg = RadioInfo.this.mHandler.obtainMessage(1001);
            if (pos >= 0 && pos <= 7) {
                RadioInfo.this.phone.setPreferredNetworkType(pos, msg);
            }
        }

        public void onNothingSelected(AdapterView parent) {
        }
    };
    private String[] mPreferredNetworkLabels = new String[]{"WCDMA preferred", "GSM only", "WCDMA only", "GSM auto (PRL)", "CDMA auto (PRL)", "CDMA only", "EvDo only", "GSM/CDMA auto (PRL)", "Unknown"};

    public void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.setContentView(2130903090);
        this.mTelephonyManager = (TelephonyManager)this.getSystemService("phone");
        this.phone = PhoneFactory.getDefaultPhone();
        this.mDeviceId = (TextView)this.findViewById(2131427464);
        this.number = (TextView)this.findViewById(2131427465);
        this.callState = (TextView)this.findViewById(2131427480);
        this.operatorName = (TextView)this.findViewById(2131427466);
        this.roamingState = (TextView)this.findViewById(2131427474);
        this.gsmState = (TextView)this.findViewById(2131427475);
        this.gprsState = (TextView)this.findViewById(2131427476);
        this.network = (TextView)this.findViewById(2131427477);
        this.dBm = (TextView)this.findViewById(2131427471);
        this.mMwi = (TextView)this.findViewById(2131427478);
        this.mCfi = (TextView)this.findViewById(2131427479);
        this.mLocation = (TextView)this.findViewById(2131427472);
        this.mNeighboringCids = (TextView)this.findViewById(2131427473);
        this.resets = (TextView)this.findViewById(2131427481);
        this.attempts = (TextView)this.findViewById(2131427482);
        this.successes = (TextView)this.findViewById(2131427483);
        this.disconnects = (TextView)this.findViewById(2131427484);
        this.sentSinceReceived = (TextView)this.findViewById(2131427487);
        this.sent = (TextView)this.findViewById(2131427485);
        this.received = (TextView)this.findViewById(2131427486);
        this.smsc = (EditText)this.findViewById(2131427493);
        this.dnsCheckState = (TextView)this.findViewById(2131427495);
        this.mPingIpAddr = (TextView)this.findViewById(2131427468);
        this.mPingHostname = (TextView)this.findViewById(2131427469);
        this.mHttpClientTest = (TextView)this.findViewById(2131427470);
        this.preferredNetworkType = (Spinner)this.findViewById(2131427488);
        ArrayAdapter adapter = new ArrayAdapter((Context)this, 17367048, (Object[])this.mPreferredNetworkLabels);
        adapter.setDropDownViewResource(0x1090009);
        this.preferredNetworkType.setAdapter((SpinnerAdapter)adapter);
        this.preferredNetworkType.setOnItemSelectedListener(this.mPreferredNetworkHandler);
        this.radioPowerButton = (Button)this.findViewById(2131427489);
        this.radioPowerButton.setOnClickListener(this.mPowerButtonHandler);
        this.pingTestButton = (Button)this.findViewById(2131427467);
        this.pingTestButton.setOnClickListener(this.mPingButtonHandler);
        this.updateSmscButton = (Button)this.findViewById(2131427491);
        this.updateSmscButton.setOnClickListener(this.mUpdateSmscButtonHandler);
        this.refreshSmscButton = (Button)this.findViewById(2131427492);
        this.refreshSmscButton.setOnClickListener(this.mRefreshSmscButtonHandler);
        this.dnsCheckToggleButton = (Button)this.findViewById(2131427494);
        this.dnsCheckToggleButton.setOnClickListener(this.mDnsCheckButtonHandler);
        this.oemInfoButton = (Button)this.findViewById(2131427496);
        this.oemInfoButton.setOnClickListener(this.mOemInfoButtonHandler);
        PackageManager pm = this.getPackageManager();
        Intent oemInfoIntent = new Intent("com.android.settings.OEM_RADIO_INFO");
        List oemInfoIntentList = pm.queryIntentActivities(oemInfoIntent, 0);
        if (oemInfoIntentList.size() == 0) {
            this.oemInfoButton.setEnabled(false);
        }
        this.mPhoneStateReceiver = new PhoneStateIntentReceiver((Context)this, this.mHandler);
        this.mPhoneStateReceiver.notifySignalStrength(200);
        this.mPhoneStateReceiver.notifyServiceState(300);
        this.mPhoneStateReceiver.notifyPhoneCallState(100);
        this.phone.getPreferredNetworkType(this.mHandler.obtainMessage(1000));
        this.phone.getNeighboringCids(this.mHandler.obtainMessage(1002));
        this.netstat = INetStatService.Stub.asInterface((IBinder)ServiceManager.getService((String)"netstat"));
        CellLocation.requestLocationUpdate();
    }

    protected void onResume() {
        super.onResume();
        this.updatePhoneState();
        this.updateSignalStrength();
        this.updateMessageWaiting();
        this.updateCallRedirect();
        this.updateServiceState();
        this.updateLocation(this.mTelephonyManager.getCellLocation());
        this.updateDataState();
        this.updateDataStats();
        this.updateDataStats2();
        this.updatePowerState();
        this.updateProperties();
        this.updateDnsCheckState();
        Log.i((String)"phone", (String)"[RadioInfo] onResume: register phone & data intents");
        this.mPhoneStateReceiver.registerIntent();
        this.mTelephonyManager.listen(this.mPhoneStateListener, 220);
    }

    public void onPause() {
        super.onPause();
        Log.i((String)"phone", (String)"[RadioInfo] onPause: unregister phone & data intents");
        this.mPhoneStateReceiver.unregisterIntent();
        this.mTelephonyManager.listen(this.mPhoneStateListener, 0);
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        menu.add(0, 0, 0, 2131230880).setOnMenuItemClickListener(this.mSelectBandCallback).setAlphabeticShortcut('b');
        menu.add(1, 1, 0, 2131230727).setOnMenuItemClickListener(this.mViewADNCallback);
        menu.add(1, 2, 0, 2131230728).setOnMenuItemClickListener(this.mViewFDNCallback);
        menu.add(1, 3, 0, 2131230729).setOnMenuItemClickListener(this.mViewSDNCallback);
        menu.add(1, 4, 0, 2131230730).setOnMenuItemClickListener(this.mGetPdpList);
        menu.add(1, 5, 0, (CharSequence)DISABLE_DATA_STR).setOnMenuItemClickListener(this.mToggleData);
        return true;
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        MenuItem item = menu.findItem(5);
        int state = this.mTelephonyManager.getDataState();
        boolean visible = true;
        switch (state) {
            case 2: 
            case 3: {
                item.setTitle((CharSequence)DISABLE_DATA_STR);
                break;
            }
            case 0: {
                item.setTitle((CharSequence)ENABLE_DATA_STR);
                break;
            }
            default: {
                visible = false;
            }
        }
        item.setVisible(visible);
        return true;
    }

    private boolean isRadioOn() {
        return this.phone.getServiceState().getState() != 3;
    }

    private void updatePowerState() {
        String buttonText = this.isRadioOn() ? this.getString(2131230726) : this.getString(2131230725);
        this.radioPowerButton.setText((CharSequence)buttonText);
    }

    private void updateDnsCheckState() {
        this.dnsCheckState.setText((CharSequence)(this.phone.isDnsCheckDisabled() ? "0.0.0.0 allowed" : "0.0.0.0 not allowed"));
    }

    private final void updateSignalStrength() {
        int signalAsu;
        int signalDbm;
        int state = this.mPhoneStateReceiver.getServiceState().getState();
        Resources r = this.getResources();
        if (1 == state || 3 == state) {
            this.dBm.setText((CharSequence)"0");
        }
        if (-1 == (signalDbm = this.mPhoneStateReceiver.getSignalStrengthDbm())) {
            signalDbm = 0;
        }
        if (-1 == (signalAsu = this.mPhoneStateReceiver.getSignalStrength())) {
            signalAsu = 0;
        }
        this.dBm.setText((CharSequence)(String.valueOf(signalDbm) + " " + r.getString(2131230747) + "   " + String.valueOf(signalAsu) + " " + r.getString(2131230748)));
    }

    private final void updateLocation(CellLocation location) {
        Resources r = this.getResources();
        if (location instanceof GsmCellLocation) {
            GsmCellLocation loc = (GsmCellLocation)location;
            int lac = loc.getLac();
            int cid = loc.getCid();
            this.mLocation.setText((CharSequence)(r.getString(2131230749) + " = " + (lac == -1 ? "unknown" : Integer.toHexString(lac)) + "   " + r.getString(2131230750) + " = " + (cid == -1 ? "unknown" : Integer.toHexString(cid))));
        } else if (location instanceof CdmaCellLocation) {
            CdmaCellLocation loc = (CdmaCellLocation)location;
            int bid = loc.getBaseStationId();
            int sid = loc.getSystemId();
            int nid = loc.getNetworkId();
            int lat = loc.getBaseStationLatitude();
            int lon = loc.getBaseStationLongitude();
            this.mLocation.setText((CharSequence)("BID = " + (bid == -1 ? "unknown" : Integer.toHexString(bid)) + "   " + "SID = " + (sid == -1 ? "unknown" : Integer.toHexString(sid)) + "   " + "NID = " + (nid == -1 ? "unknown" : Integer.toHexString(nid)) + "\n" + "LAT = " + (lat == -1 ? "unknown" : Integer.toHexString(lat)) + "   " + "LONG = " + (lon == -1 ? "unknown" : Integer.toHexString(lon))));
        } else {
            this.mLocation.setText((CharSequence)"unknown");
        }
    }

    private final void updateNeighboringCids(ArrayList<NeighboringCellInfo> cids) {
        StringBuilder sb = new StringBuilder();
        if (cids != null) {
            if (cids.isEmpty()) {
                sb.append("no neighboring cells");
            } else {
                for (NeighboringCellInfo cell : cids) {
                    sb.append(cell.toString()).append(" ");
                }
            }
        } else {
            sb.append("unknown");
        }
        this.mNeighboringCids.setText((CharSequence)sb.toString());
    }

    private final void updateMessageWaiting() {
        this.mMwi.setText((CharSequence)String.valueOf(this.mMwiValue));
    }

    private final void updateCallRedirect() {
        this.mCfi.setText((CharSequence)String.valueOf(this.mCfiValue));
    }

    private final void updateServiceState() {
        ServiceState serviceState = this.mPhoneStateReceiver.getServiceState();
        int state = serviceState.getState();
        Resources r = this.getResources();
        String display = r.getString(2131230744);
        switch (state) {
            case 0: {
                display = r.getString(2131230731);
                break;
            }
            case 1: 
            case 2: {
                display = r.getString(2131230733);
                break;
            }
            case 3: {
                display = r.getString(2131230734);
            }
        }
        this.gsmState.setText((CharSequence)display);
        if (serviceState.getRoaming()) {
            this.roamingState.setText(2131230735);
        } else {
            this.roamingState.setText(2131230736);
        }
        this.operatorName.setText((CharSequence)serviceState.getOperatorAlphaLong());
    }

    private final void updatePhoneState() {
        Phone.State state = this.mPhoneStateReceiver.getPhoneState();
        Resources r = this.getResources();
        String display = r.getString(2131230744);
        switch (state) {
            case IDLE: {
                display = r.getString(2131230737);
                break;
            }
            case RINGING: {
                display = r.getString(2131230738);
                break;
            }
            case OFFHOOK: {
                display = r.getString(2131230739);
            }
        }
        this.callState.setText((CharSequence)display);
    }

    private final void updateDataState() {
        int state = this.mTelephonyManager.getDataState();
        Resources r = this.getResources();
        String display = r.getString(2131230744);
        switch (state) {
            case 2: {
                display = r.getString(2131230742);
                break;
            }
            case 1: {
                display = r.getString(2131230741);
                break;
            }
            case 0: {
                display = r.getString(2131230740);
                break;
            }
            case 3: {
                display = r.getString(2131230743);
            }
        }
        this.gprsState.setText((CharSequence)display);
    }

    private final void updateNetworkType() {
        Resources r = this.getResources();
        String display = SystemProperties.get((String)"gsm.network.type", (String)r.getString(2131230744));
        this.network.setText((CharSequence)display);
    }

    private final void updateProperties() {
        Resources r = this.getResources();
        String s = this.phone.getDeviceId();
        if (s == null) {
            s = r.getString(2131230744);
        }
        this.mDeviceId.setText((CharSequence)s);
        s = this.phone.getLine1Number();
        if (s == null) {
            s = r.getString(2131230744);
        }
        this.number.setText((CharSequence)s);
    }

    private final void updateDataStats() {
        String s = SystemProperties.get((String)"net.gsm.radio-reset", (String)"0");
        this.resets.setText((CharSequence)s);
        s = SystemProperties.get((String)"net.gsm.attempt-gprs", (String)"0");
        this.attempts.setText((CharSequence)s);
        s = SystemProperties.get((String)"net.gsm.succeed-gprs", (String)"0");
        this.successes.setText((CharSequence)s);
        s = SystemProperties.get((String)"net.ppp.reset-by-timeout", (String)"0");
        this.sentSinceReceived.setText((CharSequence)s);
    }

    private final void updateDataStats2() {
        Resources r = this.getResources();
        try {
            long txPackets = this.netstat.getMobileTxPackets();
            long rxPackets = this.netstat.getMobileRxPackets();
            long txBytes = this.netstat.getMobileTxBytes();
            long rxBytes = this.netstat.getMobileRxBytes();
            String packets = r.getString(2131230745);
            String bytes = r.getString(2131230746);
            this.sent.setText((CharSequence)(txPackets + " " + packets + ", " + txBytes + " " + bytes));
            this.received.setText((CharSequence)(rxPackets + " " + packets + ", " + rxBytes + " " + bytes));
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void pingIpAddr() {
        try {
            String ipAddress = "74.125.47.104";
            Process p = Runtime.getRuntime().exec("ping -c 1 " + ipAddress);
            int status = p.waitFor();
            this.mPingIpAddrResult = status == 0 ? "Pass" : "Fail: IP addr not reachable";
        }
        catch (IOException e) {
            this.mPingIpAddrResult = "Fail: IOException";
        }
        catch (InterruptedException e) {
            this.mPingIpAddrResult = "Fail: InterruptedException";
        }
    }

    private final void pingHostname() {
        try {
            Process p = Runtime.getRuntime().exec("ping -c 1 www.google.com");
            int status = p.waitFor();
            this.mPingHostnameResult = status == 0 ? "Pass" : "Fail: Host unreachable";
        }
        catch (UnknownHostException e) {
            this.mPingHostnameResult = "Fail: Unknown Host";
        }
        catch (IOException e) {
            this.mPingHostnameResult = "Fail: IOException";
        }
        catch (InterruptedException e) {
            this.mPingHostnameResult = "Fail: InterruptedException";
        }
    }

    private void httpClientTest() {
        DefaultHttpClient client = new DefaultHttpClient();
        try {
            HttpGet request = new HttpGet("http://www.google.com");
            HttpResponse response = client.execute((HttpUriRequest)request);
            this.mHttpClientTestResult = response.getStatusLine().getStatusCode() == 200 ? "Pass" : "Fail: Code: " + String.valueOf(response);
            request.abort();
        }
        catch (IOException e) {
            this.mHttpClientTestResult = "Fail: IOException";
        }
    }

    private void refreshSmsc() {
        this.phone.getSmscAddress(this.mHandler.obtainMessage(1005));
    }

    private final void updatePingState() {
        final Handler handler = new Handler();
        this.mPingIpAddrResult = this.getResources().getString(2131230744);
        this.mPingHostnameResult = this.getResources().getString(2131230744);
        this.mHttpClientTestResult = this.getResources().getString(2131230744);
        this.mPingIpAddr.setText((CharSequence)this.mPingIpAddrResult);
        this.mPingHostname.setText((CharSequence)this.mPingHostnameResult);
        this.mHttpClientTest.setText((CharSequence)this.mHttpClientTestResult);
        final Runnable updatePingResults = new Runnable(){

            public void run() {
                RadioInfo.this.mPingIpAddr.setText((CharSequence)RadioInfo.this.mPingIpAddrResult);
                RadioInfo.this.mPingHostname.setText((CharSequence)RadioInfo.this.mPingHostnameResult);
                RadioInfo.this.mHttpClientTest.setText((CharSequence)RadioInfo.this.mHttpClientTestResult);
            }
        };
        Thread ipAddr = new Thread(){

            public void run() {
                RadioInfo.this.pingIpAddr();
                handler.post(updatePingResults);
            }
        };
        ipAddr.start();
        Thread hostname = new Thread(){

            public void run() {
                RadioInfo.this.pingHostname();
                handler.post(updatePingResults);
            }
        };
        hostname.start();
        Thread httpClient = new Thread(){

            public void run() {
                RadioInfo.this.httpClientTest();
                handler.post(updatePingResults);
            }
        };
        httpClient.start();
    }

    private final void updatePdpList() {
        StringBuilder sb = new StringBuilder("========DATA=======\n");
        List dcs = this.phone.getCurrentDataConnectionList();
        for (DataConnection dc : dcs) {
            sb.append("    State: ").append(dc.getStateAsString()).append("\n");
            if (dc.isActive()) {
                long timeElapsed = (System.currentTimeMillis() - dc.getConnectionTime()) / 1000L;
                sb.append("    connected at ").append(DateUtils.timeString((long)dc.getConnectionTime())).append(" and elapsed ").append(DateUtils.formatElapsedTime((long)timeElapsed));
                if (dc instanceof GsmDataConnection) {
                    GsmDataConnection pdp = (GsmDataConnection)dc;
                    sb.append("\n    to ").append(pdp.getApn().toString());
                }
                sb.append("\ninterface: ").append(this.phone.getInterfaceName(this.phone.getActiveApnTypes()[0])).append("\naddress: ").append(this.phone.getIpAddress(this.phone.getActiveApnTypes()[0])).append("\ngateway: ").append(this.phone.getGateway(this.phone.getActiveApnTypes()[0]));
                String[] dns = this.phone.getDnsServers(this.phone.getActiveApnTypes()[0]);
                if (dns != null) {
                    sb.append("\ndns: ").append(dns[0]).append(", ").append(dns[1]);
                }
            } else if (dc.isInactive()) {
                sb.append("    disconnected with last try at ").append(DateUtils.timeString((long)dc.getLastFailTime())).append("\n    fail because ").append(dc.getLastFailCause().toString());
            } else if (dc instanceof GsmDataConnection) {
                GsmDataConnection pdp = (GsmDataConnection)dc;
                sb.append("    is connecting to ").append(pdp.getApn().toString());
            } else {
                sb.append("    is connecting");
            }
            sb.append("\n===================");
        }
        this.disconnects.setText((CharSequence)sb.toString());
    }
}

