/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.Proxy;
import android.os.Bundle;
import android.provider.Settings;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProxySelector
extends Activity {
    private static final String LOGTAG = "Settings";
    EditText mHostnameField;
    EditText mPortField;
    Button mOKButton;
    private static final String HOSTNAME_REGEXP = "^$|^[a-zA-Z0-9]+(\\-[a-zA-Z0-9]+)*(\\.[a-zA-Z0-9]+(\\-[a-zA-Z0-9]+)*)*$";
    private static final Pattern HOSTNAME_PATTERN = Pattern.compile("^$|^[a-zA-Z0-9]+(\\-[a-zA-Z0-9]+)*(\\.[a-zA-Z0-9]+(\\-[a-zA-Z0-9]+)*)*$");
    View.OnClickListener mOKHandler = new View.OnClickListener(){

        public void onClick(View v) {
            if (ProxySelector.this.saveToDb()) {
                ProxySelector.this.finish();
            }
        }
    };
    View.OnClickListener mClearHandler = new View.OnClickListener(){

        public void onClick(View v) {
            ProxySelector.this.mHostnameField.setText((CharSequence)"");
            ProxySelector.this.mPortField.setText((CharSequence)"");
        }
    };
    View.OnClickListener mDefaultHandler = new View.OnClickListener(){

        public void onClick(View v) {
            ProxySelector.this.populateFields(true);
        }
    };
    View.OnFocusChangeListener mOnFocusChangeHandler = new View.OnFocusChangeListener(){

        public void onFocusChange(View v, boolean hasFocus) {
            if (hasFocus) {
                TextView textView = (TextView)v;
                Selection.selectAll((Spannable)((Spannable)textView.getText()));
            }
        }
    };

    public void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.setContentView(2130903089);
        this.initView();
        this.populateFields(false);
    }

    protected void showError(int error) {
        new AlertDialog.Builder((Context)this).setTitle(2131230855).setMessage(error).setPositiveButton(2131230856, null).show();
    }

    void initView() {
        this.mHostnameField = (EditText)this.findViewById(2131427459);
        this.mHostnameField.setOnFocusChangeListener(this.mOnFocusChangeHandler);
        this.mPortField = (EditText)this.findViewById(2131427460);
        this.mPortField.setOnClickListener(this.mOKHandler);
        this.mPortField.setOnFocusChangeListener(this.mOnFocusChangeHandler);
        this.mOKButton = (Button)this.findViewById(2131427461);
        this.mOKButton.setOnClickListener(this.mOKHandler);
        Button b = (Button)this.findViewById(2131427462);
        b.setOnClickListener(this.mClearHandler);
        b = (Button)this.findViewById(2131427463);
        b.setOnClickListener(this.mDefaultHandler);
    }

    void populateFields(boolean useDefault) {
        String title;
        String hostname = null;
        int port = -1;
        if (useDefault) {
            hostname = Proxy.getDefaultHost();
            port = Proxy.getDefaultPort();
        } else {
            hostname = Proxy.getHost((Context)this);
            port = Proxy.getPort((Context)this);
        }
        if (hostname == null) {
            hostname = "";
        }
        this.mHostnameField.setText((CharSequence)hostname);
        String portStr = port == -1 ? "" : Integer.toString(port);
        this.mPortField.setText((CharSequence)portStr);
        Intent intent = this.getIntent();
        String buttonLabel = intent.getStringExtra("button-label");
        if (!TextUtils.isEmpty((CharSequence)buttonLabel)) {
            this.mOKButton.setText((CharSequence)buttonLabel);
        }
        if (!TextUtils.isEmpty((CharSequence)(title = intent.getStringExtra("title")))) {
            this.setTitle(title);
        }
    }

    int validate(String hostname, String port) {
        Matcher match = HOSTNAME_PATTERN.matcher(hostname);
        if (!match.matches()) {
            return 2131230857;
        }
        if (hostname.length() > 0 && port.length() == 0) {
            return 2131230858;
        }
        if (port.length() > 0) {
            if (hostname.length() == 0) {
                return 2131230859;
            }
            int portVal = -1;
            try {
                portVal = Integer.parseInt(port);
            }
            catch (NumberFormatException ex) {
                return 2131230860;
            }
            if (portVal <= 0 || portVal > 65535) {
                return 2131230860;
            }
        }
        return 0;
    }

    boolean saveToDb() {
        String hostname = this.mHostnameField.getText().toString().trim();
        String portStr = this.mPortField.getText().toString().trim();
        int port = -1;
        int result = this.validate(hostname, portStr);
        if (result > 0) {
            this.showError(result);
            return false;
        }
        if (portStr.length() > 0) {
            try {
                port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        ContentResolver res = this.getContentResolver();
        if (hostname.equals(Proxy.getDefaultHost()) && port == Proxy.getDefaultPort()) {
            hostname = null;
        }
        if (!TextUtils.isEmpty((CharSequence)hostname)) {
            hostname = hostname + ':' + portStr;
        }
        Settings.Secure.putString((ContentResolver)res, (String)"http_proxy", (String)hostname);
        this.sendBroadcast(new Intent("android.intent.action.PROXY_CHANGE"));
        return true;
    }
}

