/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.app.AlertDialog;
import android.app.Dialog;
import android.app.backup.IBackupManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.preference.CheckBoxPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceScreen;
import android.provider.Settings;

public class PrivacySettings
extends PreferenceActivity
implements DialogInterface.OnClickListener {
    private static final String GSETTINGS_PROVIDER = "com.google.settings";
    private static final String BACKUP_CATEGORY = "backup_category";
    private static final String BACKUP_DATA = "backup_data";
    private static final String AUTO_RESTORE = "auto_restore";
    private CheckBoxPreference mBackup;
    private CheckBoxPreference mAutoRestore;
    private Dialog mConfirmDialog;
    private static final int DIALOG_ERASE_BACKUP = 2;
    private int mDialogType;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.addPreferencesFromResource(2130968595);
        PreferenceScreen screen = this.getPreferenceScreen();
        this.mBackup = (CheckBoxPreference)screen.findPreference((CharSequence)BACKUP_DATA);
        this.mAutoRestore = (CheckBoxPreference)screen.findPreference((CharSequence)AUTO_RESTORE);
        if (this.getPackageManager().resolveContentProvider(GSETTINGS_PROVIDER, 0) == null) {
            screen.removePreference(this.findPreference(BACKUP_CATEGORY));
        }
        this.updateToggles();
    }

    public void onStop() {
        if (this.mConfirmDialog != null && this.mConfirmDialog.isShowing()) {
            this.mConfirmDialog.dismiss();
        }
        this.mConfirmDialog = null;
        this.mDialogType = 0;
        super.onStop();
    }

    public boolean onPreferenceTreeClick(PreferenceScreen preferenceScreen, Preference preference) {
        IBackupManager bm;
        if (preference == this.mBackup) {
            if (!this.mBackup.isChecked()) {
                this.showEraseBackupDialog();
            } else {
                this.setBackupEnabled(true);
            }
        } else if (preference == this.mAutoRestore && (bm = IBackupManager.Stub.asInterface((IBinder)ServiceManager.getService((String)"backup"))) != null) {
            boolean curState = this.mAutoRestore.isChecked();
            try {
                bm.setAutoRestore(curState);
            }
            catch (RemoteException e) {
                this.mAutoRestore.setChecked(!curState);
            }
        }
        return false;
    }

    private void showEraseBackupDialog() {
        this.mBackup.setChecked(true);
        this.mDialogType = 2;
        CharSequence msg = this.getResources().getText(2131231863);
        this.mConfirmDialog = new AlertDialog.Builder((Context)this).setMessage(msg).setTitle(2131231862).setIcon(17301543).setPositiveButton(17039370, (DialogInterface.OnClickListener)this).setNegativeButton(0x1040000, (DialogInterface.OnClickListener)this).show();
    }

    private void updateToggles() {
        ContentResolver res = this.getContentResolver();
        boolean backupEnabled = Settings.Secure.getInt((ContentResolver)res, (String)"backup_enabled", (int)0) == 1;
        this.mBackup.setChecked(backupEnabled);
        this.mAutoRestore.setChecked(Settings.Secure.getInt((ContentResolver)res, (String)"backup_auto_restore", (int)1) == 1);
        this.mAutoRestore.setEnabled(backupEnabled);
    }

    public void onClick(DialogInterface dialog, int which) {
        if (which == -1) {
            if (this.mDialogType == 2) {
                this.setBackupEnabled(false);
            }
        } else if (this.mDialogType == 2) {
            this.mBackup.setChecked(true);
            this.mAutoRestore.setEnabled(true);
        }
        this.mDialogType = 0;
    }

    private void setBackupEnabled(boolean enable) {
        IBackupManager bm = IBackupManager.Stub.asInterface((IBinder)ServiceManager.getService((String)"backup"));
        if (bm != null) {
            try {
                bm.setBackupEnabled(enable);
            }
            catch (RemoteException e) {
                this.mBackup.setChecked(!enable);
                this.mAutoRestore.setEnabled(!enable);
                return;
            }
        }
        this.mBackup.setChecked(enable);
        this.mAutoRestore.setEnabled(enable);
    }
}

