/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import com.android.internal.os.storage.ExternalStorageFormatter;
import com.android.settings.ChooseLockSettingsHelper;
import com.android.settings.Utils;

public class MediaFormat
extends Activity {
    private static final int KEYGUARD_REQUEST = 55;
    private LayoutInflater mInflater;
    private View mInitialView;
    private Button mInitiateButton;
    private View mFinalView;
    private Button mFinalButton;
    private View.OnClickListener mFinalClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (Utils.isMonkeyRunning()) {
                return;
            }
            Intent intent = new Intent("com.android.internal.os.storage.FORMAT_ONLY");
            intent.setComponent(ExternalStorageFormatter.COMPONENT_NAME);
            MediaFormat.this.startService(intent);
            MediaFormat.this.finish();
        }
    };
    private View.OnClickListener mInitiateListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (!MediaFormat.this.runKeyguardConfirmation(55)) {
                MediaFormat.this.establishFinalConfirmationState();
            }
        }
    };

    private boolean runKeyguardConfirmation(int request) {
        return new ChooseLockSettingsHelper(this).launchConfirmationActivity(request, this.getText(2131231347), this.getText(2131231348));
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode != 55) {
            return;
        }
        if (resultCode == -1) {
            this.establishFinalConfirmationState();
        } else if (resultCode == 0) {
            this.finish();
        } else {
            this.establishInitialState();
        }
    }

    private void establishFinalConfirmationState() {
        if (this.mFinalView == null) {
            this.mFinalView = this.mInflater.inflate(2130903073, null);
            this.mFinalButton = (Button)this.mFinalView.findViewById(2131427431);
            this.mFinalButton.setOnClickListener(this.mFinalClickListener);
        }
        this.setContentView(this.mFinalView);
    }

    private void establishInitialState() {
        if (this.mInitialView == null) {
            this.mInitialView = this.mInflater.inflate(2130903074, null);
            this.mInitiateButton = (Button)this.mInitialView.findViewById(2131427432);
            this.mInitiateButton.setOnClickListener(this.mInitiateListener);
        }
        this.setContentView(this.mInitialView);
    }

    protected void onCreate(Bundle savedState) {
        super.onCreate(savedState);
        this.mInitialView = null;
        this.mFinalView = null;
        this.mInflater = LayoutInflater.from((Context)this);
        this.establishInitialState();
    }

    public void onPause() {
        super.onPause();
        if (!this.isFinishing()) {
            this.establishInitialState();
        }
    }
}

