/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import com.android.internal.os.storage.ExternalStorageFormatter;
import com.android.internal.widget.LockPatternUtils;
import com.android.settings.ChooseLockSettingsHelper;
import com.android.settings.Utils;

public class MasterClear
extends Activity {
    private static final int KEYGUARD_REQUEST = 55;
    private LayoutInflater mInflater;
    private LockPatternUtils mLockUtils;
    private View mInitialView;
    private Button mInitiateButton;
    private View mExternalStorageContainer;
    private CheckBox mExternalStorage;
    private View mFinalView;
    private Button mFinalButton;
    private View.OnClickListener mFinalClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (Utils.isMonkeyRunning()) {
                return;
            }
            if (MasterClear.this.mExternalStorage.isChecked()) {
                Intent intent = new Intent("com.android.internal.os.storage.FORMAT_AND_FACTORY_RESET");
                intent.setComponent(ExternalStorageFormatter.COMPONENT_NAME);
                MasterClear.this.startService(intent);
            } else {
                MasterClear.this.sendBroadcast(new Intent("android.intent.action.MASTER_CLEAR"));
            }
        }
    };
    private View.OnClickListener mInitiateListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (!MasterClear.this.runKeyguardConfirmation(55)) {
                MasterClear.this.establishFinalConfirmationState();
            }
        }
    };

    private boolean runKeyguardConfirmation(int request) {
        return new ChooseLockSettingsHelper(this).launchConfirmationActivity(request, this.getText(2131231338), this.getText(2131231339));
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode != 55) {
            return;
        }
        if (resultCode == -1) {
            this.establishFinalConfirmationState();
        } else if (resultCode == 0) {
            this.finish();
        } else {
            this.establishInitialState();
        }
    }

    private void establishFinalConfirmationState() {
        if (this.mFinalView == null) {
            this.mFinalView = this.mInflater.inflate(2130903071, null);
            this.mFinalButton = (Button)this.mFinalView.findViewById(2131427427);
            this.mFinalButton.setOnClickListener(this.mFinalClickListener);
        }
        this.setContentView(this.mFinalView);
    }

    private void establishInitialState() {
        if (this.mInitialView == null) {
            this.mInitialView = this.mInflater.inflate(2130903072, null);
            this.mInitiateButton = (Button)this.mInitialView.findViewById(2131427430);
            this.mInitiateButton.setOnClickListener(this.mInitiateListener);
            this.mExternalStorageContainer = this.mInitialView.findViewById(2131427428);
            this.mExternalStorage = (CheckBox)this.mInitialView.findViewById(2131427429);
            this.mExternalStorageContainer.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MasterClear.this.mExternalStorage.toggle();
                }
            });
        }
        this.setContentView(this.mInitialView);
    }

    protected void onCreate(Bundle savedState) {
        super.onCreate(savedState);
        this.mInitialView = null;
        this.mFinalView = null;
        this.mInflater = LayoutInflater.from((Context)this);
        this.mLockUtils = new LockPatternUtils((Context)this);
        this.establishInitialState();
    }

    public void onPause() {
        super.onPause();
        if (!this.isFinishing()) {
            this.establishInitialState();
        }
    }
}

