/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.app.ActivityManagerNative;
import android.app.IActivityManager;
import android.app.ListActivity;
import android.app.backup.BackupManager;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.RemoteException;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import java.text.Collator;
import java.util.Arrays;
import java.util.Locale;

public class LocalePicker
extends ListActivity {
    private static final String TAG = "LocalePicker";
    private static final boolean DEBUG = false;
    Loc[] mLocales;
    String[] mSpecialLocaleCodes;
    String[] mSpecialLocaleNames;

    int getContentView() {
        return 2130903066;
    }

    public void onCreate(Bundle icicle) {
        int i;
        super.onCreate(icicle);
        this.setContentView(this.getContentView());
        this.mSpecialLocaleCodes = this.getResources().getStringArray(2131034143);
        this.mSpecialLocaleNames = this.getResources().getStringArray(2131034144);
        Object[] locales = this.getAssets().getLocales();
        Arrays.sort(locales);
        int origSize = locales.length;
        Loc[] preprocess = new Loc[origSize];
        int finalSize = 0;
        for (i = 0; i < origSize; ++i) {
            Object s = locales[i];
            int len = ((String)s).length();
            if (len != 5) continue;
            String language = ((String)s).substring(0, 2);
            String country = ((String)s).substring(3, 5);
            Locale l = new Locale(language, country);
            if (finalSize == 0) {
                preprocess[finalSize++] = new Loc(LocalePicker.toTitleCase(l.getDisplayLanguage(l)), l);
                continue;
            }
            if (preprocess[finalSize - 1].locale.getLanguage().equals(language)) {
                preprocess[finalSize - 1].label = LocalePicker.toTitleCase(this.getDisplayName(preprocess[finalSize - 1].locale));
                preprocess[finalSize++] = new Loc(LocalePicker.toTitleCase(this.getDisplayName(l)), l);
                continue;
            }
            String displayName = ((String)s).equals("zz_ZZ") ? "Pseudo..." : LocalePicker.toTitleCase(l.getDisplayLanguage(l));
            preprocess[finalSize++] = new Loc(displayName, l);
        }
        this.mLocales = new Loc[finalSize];
        for (i = 0; i < finalSize; ++i) {
            this.mLocales[i] = preprocess[i];
        }
        Arrays.sort(this.mLocales);
        int layoutId = 2130903068;
        int fieldId = 2131427414;
        ArrayAdapter adapter = new ArrayAdapter((Context)this, layoutId, fieldId, (Object[])this.mLocales);
        this.getListView().setAdapter((ListAdapter)adapter);
    }

    private static String toTitleCase(String s) {
        if (s.length() == 0) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    private String getDisplayName(Locale l) {
        String code = l.toString();
        for (int i = 0; i < this.mSpecialLocaleCodes.length; ++i) {
            if (!this.mSpecialLocaleCodes[i].equals(code)) continue;
            return this.mSpecialLocaleNames[i];
        }
        return l.getDisplayName(l);
    }

    public void onResume() {
        super.onResume();
        this.getListView().requestFocus();
    }

    protected void onListItemClick(ListView l, View v, int position, long id2) {
        try {
            IActivityManager am = ActivityManagerNative.getDefault();
            Configuration config = am.getConfiguration();
            Loc loc = this.mLocales[position];
            config.locale = loc.locale;
            config.userSetLocale = true;
            am.updateConfiguration(config);
            BackupManager.dataChanged((String)"com.android.providers.settings");
        }
        catch (RemoteException e) {
            // empty catch block
        }
        this.finish();
    }

    private static class Loc
    implements Comparable {
        static Collator sCollator = Collator.getInstance();
        String label;
        Locale locale;

        public Loc(String label, Locale locale) {
            this.label = label;
            this.locale = locale;
        }

        public String toString() {
            return this.label;
        }

        public int compareTo(Object o) {
            return sCollator.compare(this.label, ((Loc)o).label);
        }
    }
}

