/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.app.AlertDialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.preference.CheckBoxPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceGroup;
import android.preference.PreferenceScreen;
import android.provider.Settings;
import android.text.TextUtils;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodManager;
import com.android.settings.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class LanguageSettings
extends PreferenceActivity {
    private static final String KEY_PHONE_LANGUAGE = "phone_language";
    private static final String KEY_KEYBOARD_SETTINGS_CATEGORY = "keyboard_settings_category";
    private static final String KEY_HARDKEYBOARD_CATEGORY = "hardkeyboard_category";
    private boolean mHaveHardKeyboard;
    private List<InputMethodInfo> mInputMethodProperties;
    private List<CheckBoxPreference> mCheckboxes;
    private Preference mLanguagePref;
    final TextUtils.SimpleStringSplitter mStringColonSplitter = new TextUtils.SimpleStringSplitter(':');
    private String mLastInputMethodId;
    private String mLastTickedInputMethodId;

    public static String getInputMethodIdFromKey(String key) {
        return key;
    }

    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.addPreferencesFromResource(2130968593);
        if (this.getAssets().getLocales().length == 1) {
            this.getPreferenceScreen().removePreference(this.findPreference(KEY_PHONE_LANGUAGE));
        } else {
            this.mLanguagePref = this.findPreference(KEY_PHONE_LANGUAGE);
        }
        Configuration config = this.getResources().getConfiguration();
        if (config.keyboard != 2) {
            this.getPreferenceScreen().removePreference(this.getPreferenceScreen().findPreference((CharSequence)KEY_HARDKEYBOARD_CATEGORY));
        } else {
            this.mHaveHardKeyboard = true;
        }
        this.mCheckboxes = new ArrayList<CheckBoxPreference>();
        this.onCreateIMM();
    }

    private boolean isSystemIme(InputMethodInfo property) {
        return (property.getServiceInfo().applicationInfo.flags & 1) != 0;
    }

    private void onCreateIMM() {
        InputMethodManager imm = (InputMethodManager)this.getSystemService("input_method");
        this.mInputMethodProperties = imm.getInputMethodList();
        this.mLastInputMethodId = Settings.Secure.getString((ContentResolver)this.getContentResolver(), (String)"default_input_method");
        PreferenceGroup keyboardSettingsCategory = (PreferenceGroup)this.findPreference(KEY_KEYBOARD_SETTINGS_CATEGORY);
        int N = this.mInputMethodProperties == null ? 0 : this.mInputMethodProperties.size();
        for (int i = 0; i < N; ++i) {
            InputMethodInfo property = this.mInputMethodProperties.get(i);
            String prefKey = property.getId();
            CharSequence label = property.loadLabel(this.getPackageManager());
            boolean systemIME = this.isSystemIme(property);
            if (this.mHaveHardKeyboard || N > 1 && !systemIME) {
                CheckBoxPreference chkbxPref = new CheckBoxPreference((Context)this);
                chkbxPref.setKey(prefKey);
                chkbxPref.setTitle(label);
                keyboardSettingsCategory.addPreference((Preference)chkbxPref);
                this.mCheckboxes.add(chkbxPref);
            }
            if (null == property.getSettingsActivity()) continue;
            PreferenceScreen prefScreen = new PreferenceScreen((Context)this, null);
            String settingsActivity = property.getSettingsActivity();
            if (settingsActivity.lastIndexOf("/") < 0) {
                settingsActivity = property.getPackageName() + "/" + settingsActivity;
            }
            prefScreen.setKey(settingsActivity);
            prefScreen.setTitle(label);
            if (N == 1) {
                prefScreen.setSummary((CharSequence)this.getString(2131231587));
            } else {
                String settingsLabel = this.getResources().getString(2131231586, new Object[]{label});
                prefScreen.setSummary((CharSequence)settingsLabel);
            }
            keyboardSettingsCategory.addPreference((Preference)prefScreen);
        }
    }

    protected void onResume() {
        super.onResume();
        HashSet<String> enabled = new HashSet<String>();
        String enabledStr = Settings.Secure.getString((ContentResolver)this.getContentResolver(), (String)"enabled_input_methods");
        if (enabledStr != null) {
            TextUtils.SimpleStringSplitter splitter = this.mStringColonSplitter;
            splitter.setString(enabledStr);
            while (splitter.hasNext()) {
                enabled.add(splitter.next());
            }
        }
        int N = this.mInputMethodProperties.size();
        for (int i = 0; i < N; ++i) {
            String id2 = this.mInputMethodProperties.get(i).getId();
            CheckBoxPreference pref = (CheckBoxPreference)this.findPreference(this.mInputMethodProperties.get(i).getId());
            if (pref == null) continue;
            pref.setChecked(enabled.contains(id2));
        }
        this.mLastTickedInputMethodId = null;
        if (this.mLanguagePref != null) {
            Configuration conf = this.getResources().getConfiguration();
            String locale = conf.locale.getDisplayName(conf.locale);
            if (locale != null && locale.length() > 1) {
                locale = Character.toUpperCase(locale.charAt(0)) + locale.substring(1);
                this.mLanguagePref.setSummary((CharSequence)locale);
            }
        }
    }

    protected void onPause() {
        super.onPause();
        StringBuilder builder = new StringBuilder(256);
        StringBuilder disabledSysImes = new StringBuilder(256);
        int firstEnabled = -1;
        int N = this.mInputMethodProperties.size();
        for (int i = 0; i < N; ++i) {
            InputMethodInfo property = this.mInputMethodProperties.get(i);
            String id2 = property.getId();
            CheckBoxPreference pref = (CheckBoxPreference)this.findPreference(id2);
            boolean hasIt = id2.equals(this.mLastInputMethodId);
            boolean systemIme = this.isSystemIme(property);
            if ((N == 1 || systemIme) && !this.mHaveHardKeyboard || pref != null && pref.isChecked()) {
                if (builder.length() > 0) {
                    builder.append(':');
                }
                builder.append(id2);
                if (firstEnabled < 0) {
                    firstEnabled = i;
                }
            } else if (hasIt) {
                this.mLastInputMethodId = this.mLastTickedInputMethodId;
            }
            if (pref == null || pref.isChecked() || !systemIme || !this.mHaveHardKeyboard) continue;
            if (disabledSysImes.length() > 0) {
                disabledSysImes.append(":");
            }
            disabledSysImes.append(id2);
        }
        if (null == this.mLastInputMethodId || "".equals(this.mLastInputMethodId)) {
            this.mLastInputMethodId = firstEnabled >= 0 ? this.mInputMethodProperties.get(firstEnabled).getId() : null;
        }
        Settings.Secure.putString((ContentResolver)this.getContentResolver(), (String)"enabled_input_methods", (String)builder.toString());
        Settings.Secure.putString((ContentResolver)this.getContentResolver(), (String)"disabled_system_input_methods", (String)disabledSysImes.toString());
        Settings.Secure.putString((ContentResolver)this.getContentResolver(), (String)"default_input_method", (String)(this.mLastInputMethodId != null ? this.mLastInputMethodId : ""));
    }

    public boolean onPreferenceTreeClick(PreferenceScreen preferenceScreen, Preference preference) {
        if (Utils.isMonkeyRunning()) {
            return false;
        }
        if (preference instanceof CheckBoxPreference) {
            final CheckBoxPreference chkPref = (CheckBoxPreference)preference;
            final String id2 = LanguageSettings.getInputMethodIdFromKey(chkPref.getKey());
            if (chkPref.isChecked()) {
                InputMethodInfo selImi = null;
                int N = this.mInputMethodProperties.size();
                for (int i = 0; i < N; ++i) {
                    InputMethodInfo imi = this.mInputMethodProperties.get(i);
                    if (!id2.equals(imi.getId())) continue;
                    selImi = imi;
                    if (!this.isSystemIme(imi)) continue;
                    this.mLastTickedInputMethodId = id2;
                    return super.onPreferenceTreeClick(preferenceScreen, preference);
                }
                chkPref.setChecked(false);
                if (selImi == null) {
                    return super.onPreferenceTreeClick(preferenceScreen, preference);
                }
                AlertDialog d = new AlertDialog.Builder((Context)this).setTitle(0x1040014).setIcon(17301543).setMessage((CharSequence)this.getString(2131231559, new Object[]{selImi.getServiceInfo().applicationInfo.loadLabel(this.getPackageManager())})).setCancelable(true).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        chkPref.setChecked(true);
                        LanguageSettings.this.mLastTickedInputMethodId = id2;
                    }
                }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                    }
                }).create();
                d.show();
            } else if (id2.equals(this.mLastTickedInputMethodId)) {
                this.mLastTickedInputMethodId = null;
            }
        } else if (preference instanceof PreferenceScreen && preference.getIntent() == null) {
            PreferenceScreen pref = (PreferenceScreen)preference;
            String activityName = pref.getKey();
            String packageName = activityName.substring(0, activityName.lastIndexOf("."));
            int slash = activityName.indexOf("/");
            if (slash > 0) {
                packageName = activityName.substring(0, slash);
                activityName = activityName.substring(slash + 1);
            }
            if (activityName.length() > 0) {
                Intent i = new Intent("android.intent.action.MAIN");
                i.setClassName(packageName, activityName);
                this.startActivity(i);
            }
        }
        return super.onPreferenceTreeClick(preferenceScreen, preference);
    }
}

