/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.content.Context;
import android.content.res.Resources;
import android.os.AsyncResult;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.preference.CheckBoxPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceScreen;
import android.widget.Toast;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneFactory;
import com.android.settings.EditPinPreference;
import com.android.settings.Utils;

public class IccLockSettings
extends PreferenceActivity
implements EditPinPreference.OnPinEnteredListener {
    private static final int OFF_MODE = 0;
    private static final int ICC_LOCK_MODE = 1;
    private static final int ICC_OLD_MODE = 2;
    private static final int ICC_NEW_MODE = 3;
    private static final int ICC_REENTER_MODE = 4;
    private static final String PIN_DIALOG = "sim_pin";
    private static final String PIN_TOGGLE = "sim_toggle";
    private static final String DIALOG_STATE = "dialogState";
    private static final String DIALOG_PIN = "dialogPin";
    private static final String DIALOG_ERROR = "dialogError";
    private static final String ENABLE_TO_STATE = "enableState";
    private static final int MIN_PIN_LENGTH = 4;
    private static final int MAX_PIN_LENGTH = 8;
    private int mDialogState = 0;
    private String mPin;
    private String mOldPin;
    private String mNewPin;
    private String mError;
    private boolean mToState;
    private Phone mPhone;
    private EditPinPreference mPinDialog;
    private CheckBoxPreference mPinToggle;
    private Resources mRes;
    private static final int ENABLE_ICC_PIN_COMPLETE = 100;
    private static final int CHANGE_ICC_PIN_COMPLETE = 101;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            AsyncResult ar = (AsyncResult)msg.obj;
            switch (msg.what) {
                case 100: {
                    IccLockSettings.this.iccLockChanged(ar.exception == null);
                    break;
                }
                case 101: {
                    IccLockSettings.this.iccPinChanged(ar.exception == null);
                }
            }
        }
    };

    static boolean isIccLockEnabled() {
        return PhoneFactory.getDefaultPhone().getIccCard().getIccLockEnabled();
    }

    static String getSummary(Context context) {
        Resources res = context.getResources();
        String summary = IccLockSettings.isIccLockEnabled() ? res.getString(2131231224) : res.getString(2131231225);
        return summary;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (Utils.isMonkeyRunning()) {
            this.finish();
            return;
        }
        this.addPreferencesFromResource(2130968604);
        this.mPinDialog = (EditPinPreference)this.findPreference(PIN_DIALOG);
        this.mPinToggle = (CheckBoxPreference)this.findPreference(PIN_TOGGLE);
        if (savedInstanceState != null && savedInstanceState.containsKey(DIALOG_STATE)) {
            this.mDialogState = savedInstanceState.getInt(DIALOG_STATE);
            this.mPin = savedInstanceState.getString(DIALOG_PIN);
            this.mError = savedInstanceState.getString(DIALOG_ERROR);
            this.mToState = savedInstanceState.getBoolean(ENABLE_TO_STATE);
        }
        this.mPinDialog.setOnPinEnteredListener(this);
        this.getPreferenceScreen().setPersistent(false);
        this.mPhone = PhoneFactory.getDefaultPhone();
        this.mRes = this.getResources();
    }

    protected void onResume() {
        super.onResume();
        this.mPinToggle.setChecked(this.mPhone.getIccCard().getIccLockEnabled());
        if (this.mDialogState != 0) {
            this.showPinDialog();
        } else {
            this.resetDialogState();
        }
    }

    protected void onSaveInstanceState(Bundle out) {
        if (this.mPinDialog.isDialogOpen()) {
            out.putInt(DIALOG_STATE, this.mDialogState);
            out.putString(DIALOG_PIN, this.mPinDialog.getEditText().getText().toString());
            out.putString(DIALOG_ERROR, this.mError);
            out.putBoolean(ENABLE_TO_STATE, this.mToState);
        } else {
            super.onSaveInstanceState(out);
        }
    }

    private void showPinDialog() {
        if (this.mDialogState == 0) {
            return;
        }
        this.setDialogValues();
        this.mPinDialog.showPinDialog();
    }

    private void setDialogValues() {
        this.mPinDialog.setText(this.mPin);
        String message = "";
        switch (this.mDialogState) {
            case 1: {
                message = this.mRes.getString(2131231227);
                this.mPinDialog.setDialogTitle(this.mToState ? this.mRes.getString(2131231228) : this.mRes.getString(2131231229));
                break;
            }
            case 2: {
                message = this.mRes.getString(2131231230);
                this.mPinDialog.setDialogTitle(this.mRes.getString(2131231233));
                break;
            }
            case 3: {
                message = this.mRes.getString(2131231231);
                this.mPinDialog.setDialogTitle(this.mRes.getString(2131231233));
                break;
            }
            case 4: {
                message = this.mRes.getString(2131231232);
                this.mPinDialog.setDialogTitle(this.mRes.getString(2131231233));
            }
        }
        if (this.mError != null) {
            message = this.mError + "\n" + message;
            this.mError = null;
        }
        this.mPinDialog.setDialogMessage(message);
    }

    public void onPinEntered(EditPinPreference preference, boolean positiveResult) {
        if (!positiveResult) {
            this.resetDialogState();
            return;
        }
        this.mPin = preference.getText();
        if (!this.reasonablePin(this.mPin)) {
            this.mError = this.mRes.getString(2131231234);
            this.showPinDialog();
            return;
        }
        switch (this.mDialogState) {
            case 1: {
                this.tryChangeIccLockState();
                break;
            }
            case 2: {
                this.mOldPin = this.mPin;
                this.mDialogState = 3;
                this.mError = null;
                this.mPin = null;
                this.showPinDialog();
                break;
            }
            case 3: {
                this.mNewPin = this.mPin;
                this.mDialogState = 4;
                this.mPin = null;
                this.showPinDialog();
                break;
            }
            case 4: {
                if (!this.mPin.equals(this.mNewPin)) {
                    this.mError = this.mRes.getString(2131231235);
                    this.mDialogState = 3;
                    this.mPin = null;
                    this.showPinDialog();
                    break;
                }
                this.mError = null;
                this.tryChangePin();
            }
        }
    }

    public boolean onPreferenceTreeClick(PreferenceScreen preferenceScreen, Preference preference) {
        if (preference == this.mPinToggle) {
            this.mToState = this.mPinToggle.isChecked();
            this.mPinToggle.setChecked(!this.mToState);
            this.mDialogState = 1;
            this.showPinDialog();
        } else if (preference == this.mPinDialog) {
            this.mDialogState = 2;
            return false;
        }
        return true;
    }

    private void tryChangeIccLockState() {
        Message callback = Message.obtain((Handler)this.mHandler, (int)100);
        this.mPhone.getIccCard().setIccLockEnabled(this.mToState, this.mPin, callback);
    }

    private void iccLockChanged(boolean success) {
        if (success) {
            this.mPinToggle.setChecked(this.mToState);
        } else {
            Toast.makeText((Context)this, (CharSequence)this.mRes.getString(2131231238), (int)0).show();
        }
        this.resetDialogState();
    }

    private void iccPinChanged(boolean success) {
        if (!success) {
            Toast.makeText((Context)this, (CharSequence)this.mRes.getString(2131231236), (int)0).show();
        } else {
            Toast.makeText((Context)this, (CharSequence)this.mRes.getString(2131231237), (int)0).show();
        }
        this.resetDialogState();
    }

    private void tryChangePin() {
        Message callback = Message.obtain((Handler)this.mHandler, (int)101);
        this.mPhone.getIccCard().changeIccLockPassword(this.mOldPin, this.mNewPin, callback);
    }

    private boolean reasonablePin(String pin) {
        return pin != null && pin.length() >= 4 && pin.length() <= 8;
    }

    private void resetDialogState() {
        this.mError = null;
        this.mDialogState = 2;
        this.mPin = "";
        this.setDialogValues();
        this.mDialogState = 0;
    }
}

