/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.app.Dialog;
import android.content.Context;
import android.preference.EditTextPreference;
import android.text.method.DigitsKeyListener;
import android.text.method.KeyListener;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.view.View;
import android.widget.EditText;

class EditPinPreference
extends EditTextPreference {
    private OnPinEnteredListener mPinListener;

    public EditPinPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public EditPinPreference(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setOnPinEnteredListener(OnPinEnteredListener listener) {
        this.mPinListener = listener;
    }

    protected void onBindDialogView(View view) {
        super.onBindDialogView(view);
        EditText editText = (EditText)view.findViewById(16908291);
        if (editText != null) {
            editText.setSingleLine(true);
            editText.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
            editText.setKeyListener((KeyListener)DigitsKeyListener.getInstance());
        }
    }

    public boolean isDialogOpen() {
        Dialog dialog = this.getDialog();
        return dialog != null && dialog.isShowing();
    }

    protected void onDialogClosed(boolean positiveResult) {
        super.onDialogClosed(positiveResult);
        if (this.mPinListener != null) {
            this.mPinListener.onPinEntered(this, positiveResult);
        }
    }

    public void showPinDialog() {
        Dialog dialog = this.getDialog();
        if (dialog == null || !dialog.isShowing()) {
            this.showDialog(null);
        }
    }

    static interface OnPinEnteredListener {
        public void onPinEntered(EditPinPreference var1, boolean var2);
    }
}

