/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.preference.CheckBoxPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceScreen;
import android.provider.Settings;
import com.android.settings.bluetooth.DockEventReceiver;

public class DockSettings
extends PreferenceActivity {
    private static final int DIALOG_NOT_DOCKED = 1;
    private static final String KEY_AUDIO_SETTINGS = "dock_audio";
    private static final String KEY_DOCK_SOUNDS = "dock_sounds";
    private Preference mAudioSettings;
    private CheckBoxPreference mDockSounds;
    private Intent mDockIntent;
    private BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.DOCK_EVENT")) {
                DockSettings.this.handleDockChange(intent);
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ContentResolver resolver = this.getContentResolver();
        this.addPreferencesFromResource(2130968590);
        this.initDockSettings();
    }

    protected void onResume() {
        super.onResume();
        IntentFilter filter = new IntentFilter("android.intent.action.DOCK_EVENT");
        this.registerReceiver(this.mReceiver, filter);
    }

    protected void onPause() {
        super.onPause();
        this.unregisterReceiver(this.mReceiver);
    }

    private void initDockSettings() {
        ContentResolver resolver = this.getContentResolver();
        this.mAudioSettings = this.findPreference(KEY_AUDIO_SETTINGS);
        if (this.mAudioSettings != null) {
            this.mAudioSettings.setSummary(2131231197);
        }
        this.mDockSounds = (CheckBoxPreference)this.findPreference(KEY_DOCK_SOUNDS);
        this.mDockSounds.setPersistent(false);
        this.mDockSounds.setChecked(Settings.System.getInt((ContentResolver)resolver, (String)"dock_sounds_enabled", (int)0) != 0);
    }

    private void handleDockChange(Intent intent) {
        if (this.mAudioSettings != null) {
            boolean isBluetooth;
            int dockState = intent.getIntExtra("android.intent.extra.DOCK_STATE", 0);
            boolean bl = isBluetooth = intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE") != null;
            if (!isBluetooth) {
                this.mAudioSettings.setEnabled(false);
                this.mAudioSettings.setSummary(2131231198);
            } else {
                this.mAudioSettings.setEnabled(true);
                this.mDockIntent = intent;
                int resId = 2131231198;
                switch (dockState) {
                    case 2: {
                        resId = 2131231196;
                        break;
                    }
                    case 1: {
                        resId = 2131231195;
                        break;
                    }
                    case 0: {
                        resId = 2131231197;
                    }
                }
                this.mAudioSettings.setSummary(resId);
            }
            if (dockState != 0) {
                try {
                    this.dismissDialog(1);
                }
                catch (IllegalArgumentException iae) {
                    // empty catch block
                }
            }
        }
    }

    public boolean onPreferenceTreeClick(PreferenceScreen preferenceScreen, Preference preference) {
        if (preference == this.mAudioSettings) {
            int dockState;
            int n = dockState = this.mDockIntent != null ? this.mDockIntent.getIntExtra("android.intent.extra.DOCK_STATE", 0) : 0;
            if (dockState == 0) {
                this.showDialog(1);
            } else {
                Intent i = new Intent(this.mDockIntent);
                i.setAction("com.android.settings.bluetooth.action.DOCK_SHOW_UI");
                i.setClass((Context)this, DockEventReceiver.class);
                this.sendBroadcast(i);
            }
        } else if (preference == this.mDockSounds) {
            Settings.System.putInt((ContentResolver)this.getContentResolver(), (String)"dock_sounds_enabled", (int)(this.mDockSounds.isChecked() ? 1 : 0));
        }
        return true;
    }

    public Dialog onCreateDialog(int id2) {
        if (id2 == 1) {
            return this.createUndockedMessage();
        }
        return null;
    }

    private Dialog createUndockedMessage() {
        AlertDialog.Builder ab = new AlertDialog.Builder((Context)this);
        ab.setTitle(2131231199);
        ab.setMessage(2131231200);
        ab.setPositiveButton(17039370, null);
        return ab.create();
    }
}

