/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.app.admin.DevicePolicyManager;
import android.content.ContentResolver;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.preference.CheckBoxPreference;
import android.preference.ListPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceScreen;
import android.provider.Settings;
import android.util.Log;
import android.view.IWindowManager;
import java.util.ArrayList;

public class DisplaySettings
extends PreferenceActivity
implements Preference.OnPreferenceChangeListener {
    private static final String TAG = "DisplaySettings";
    private static final int FALLBACK_SCREEN_TIMEOUT_VALUE = 30000;
    private static final String KEY_SCREEN_TIMEOUT = "screen_timeout";
    private static final String KEY_ANIMATIONS = "animations";
    private static final String KEY_ACCELEROMETER = "accelerometer";
    private ListPreference mAnimations;
    private CheckBoxPreference mAccelerometer;
    private float[] mAnimationScales;
    private IWindowManager mWindowManager;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ContentResolver resolver = this.getContentResolver();
        this.mWindowManager = IWindowManager.Stub.asInterface((IBinder)ServiceManager.getService((String)"window"));
        this.addPreferencesFromResource(2130968589);
        this.mAnimations = (ListPreference)this.findPreference(KEY_ANIMATIONS);
        this.mAnimations.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
        this.mAccelerometer = (CheckBoxPreference)this.findPreference(KEY_ACCELEROMETER);
        this.mAccelerometer.setPersistent(false);
        ListPreference screenTimeoutPreference = (ListPreference)this.findPreference(KEY_SCREEN_TIMEOUT);
        screenTimeoutPreference.setValue(String.valueOf(Settings.System.getInt((ContentResolver)resolver, (String)"screen_off_timeout", (int)30000)));
        screenTimeoutPreference.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
        this.disableUnusableTimeouts(screenTimeoutPreference);
    }

    private void disableUnusableTimeouts(ListPreference screenTimeoutPreference) {
        long maxTimeout;
        DevicePolicyManager dpm = (DevicePolicyManager)this.getSystemService("device_policy");
        long l = maxTimeout = dpm != null ? dpm.getMaximumTimeToLock(null) : 0L;
        if (maxTimeout == 0L) {
            return;
        }
        CharSequence[] entries = screenTimeoutPreference.getEntries();
        CharSequence[] values = screenTimeoutPreference.getEntryValues();
        ArrayList<CharSequence> revisedEntries = new ArrayList<CharSequence>();
        ArrayList<CharSequence> revisedValues = new ArrayList<CharSequence>();
        for (int i = 0; i < values.length; ++i) {
            long timeout = Long.valueOf(((Object)values[i]).toString());
            if (timeout > maxTimeout) continue;
            revisedEntries.add(entries[i]);
            revisedValues.add(values[i]);
        }
        if (revisedEntries.size() != entries.length || revisedValues.size() != values.length) {
            screenTimeoutPreference.setEntries(revisedEntries.toArray(new CharSequence[revisedEntries.size()]));
            screenTimeoutPreference.setEntryValues(revisedValues.toArray(new CharSequence[revisedValues.size()]));
            int userPreference = Integer.valueOf(screenTimeoutPreference.getValue());
            if ((long)userPreference <= maxTimeout) {
                screenTimeoutPreference.setValue(String.valueOf(userPreference));
            }
        }
        screenTimeoutPreference.setEnabled(revisedEntries.size() > 0);
    }

    protected void onResume() {
        super.onResume();
        this.updateState(true);
    }

    private void updateState(boolean force) {
        int animations = 0;
        try {
            this.mAnimationScales = this.mWindowManager.getAnimationScales();
        }
        catch (RemoteException e) {
            // empty catch block
        }
        if (this.mAnimationScales != null) {
            if (this.mAnimationScales.length >= 1) {
                animations = (int)(this.mAnimationScales[0] + 0.5f) % 10;
            }
            if (this.mAnimationScales.length >= 2) {
                animations += ((int)(this.mAnimationScales[1] + 0.5f) & 7) * 10;
            }
        }
        int idx = 0;
        int best = 0;
        CharSequence[] aents = this.mAnimations.getEntryValues();
        for (int i = 0; i < aents.length; ++i) {
            int val = Integer.parseInt(((Object)aents[i]).toString());
            if (val > animations || val <= best) continue;
            best = val;
            idx = i;
        }
        this.mAnimations.setValueIndex(idx);
        this.updateAnimationsSummary(this.mAnimations.getValue());
        this.mAccelerometer.setChecked(Settings.System.getInt((ContentResolver)this.getContentResolver(), (String)"accelerometer_rotation", (int)0) != 0);
    }

    private void updateAnimationsSummary(Object value) {
        CharSequence[] summaries = this.getResources().getTextArray(2131034115);
        CharSequence[] values = this.mAnimations.getEntryValues();
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].equals(value)) continue;
            this.mAnimations.setSummary(summaries[i]);
            break;
        }
    }

    public boolean onPreferenceTreeClick(PreferenceScreen preferenceScreen, Preference preference) {
        if (preference == this.mAccelerometer) {
            Settings.System.putInt((ContentResolver)this.getContentResolver(), (String)"accelerometer_rotation", (int)(this.mAccelerometer.isChecked() ? 1 : 0));
        }
        return true;
    }

    public boolean onPreferenceChange(Preference preference, Object objValue) {
        String key = preference.getKey();
        if (KEY_ANIMATIONS.equals(key)) {
            try {
                int value = Integer.parseInt((String)objValue);
                if (this.mAnimationScales.length >= 1) {
                    this.mAnimationScales[0] = value % 10;
                }
                if (this.mAnimationScales.length >= 2) {
                    this.mAnimationScales[1] = value / 10 % 10;
                }
                try {
                    this.mWindowManager.setAnimationScales(this.mAnimationScales);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                this.updateAnimationsSummary(objValue);
            }
            catch (NumberFormatException e) {
                Log.e((String)TAG, (String)"could not persist animation setting", (Throwable)e);
            }
        }
        if (KEY_SCREEN_TIMEOUT.equals(key)) {
            int value = Integer.parseInt((String)objValue);
            try {
                Settings.System.putInt((ContentResolver)this.getContentResolver(), (String)"screen_off_timeout", (int)value);
            }
            catch (NumberFormatException e) {
                Log.e((String)TAG, (String)"could not persist screen timeout setting", (Throwable)e);
            }
        }
        return true;
    }
}

