/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.R;
import android.app.Activity;
import android.app.ActivityManagerNative;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;

public class Display
extends Activity
implements View.OnClickListener {
    private AdapterView.OnItemSelectedListener mFontSizeChanged = new AdapterView.OnItemSelectedListener(){

        public void onItemSelected(AdapterView av, View v, int position, long id2) {
            ((Display)Display.this).mCurConfig.fontScale = position == 0 ? 0.75f : (position == 2 ? 1.25f : 1.0f);
            Display.this.updateFontScale();
        }

        public void onNothingSelected(AdapterView av) {
        }
    };
    private Spinner mFontSize;
    private TextView mPreview;
    private TypedValue mTextSizeTyped;
    private DisplayMetrics mDisplayMetrics;
    private Configuration mCurConfig = new Configuration();

    public void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.setContentView(2130903062);
        this.mFontSize = (Spinner)this.findViewById(2131427383);
        this.mFontSize.setOnItemSelectedListener(this.mFontSizeChanged);
        Object[] states = new String[3];
        Resources r = this.getResources();
        states[0] = r.getString(2131230753);
        states[1] = r.getString(2131230754);
        states[2] = r.getString(2131230755);
        ArrayAdapter adapter = new ArrayAdapter((Context)this, 17367048, states);
        adapter.setDropDownViewResource(0x1090009);
        this.mFontSize.setAdapter((SpinnerAdapter)adapter);
        this.mPreview = (TextView)this.findViewById(2131427384);
        this.mPreview.setText(r.getText(2131230756));
        Button save = (Button)this.findViewById(2131427385);
        save.setText(r.getText(2131230757));
        save.setOnClickListener((View.OnClickListener)this);
        this.mTextSizeTyped = new TypedValue();
        TypedArray styledAttributes = this.obtainStyledAttributes(R.styleable.TextView);
        styledAttributes.getValue(2, this.mTextSizeTyped);
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        this.mDisplayMetrics = new DisplayMetrics();
        this.mDisplayMetrics.density = metrics.density;
        this.mDisplayMetrics.heightPixels = metrics.heightPixels;
        this.mDisplayMetrics.scaledDensity = metrics.scaledDensity;
        this.mDisplayMetrics.widthPixels = metrics.widthPixels;
        this.mDisplayMetrics.xdpi = metrics.xdpi;
        this.mDisplayMetrics.ydpi = metrics.ydpi;
        styledAttributes.recycle();
    }

    public void onResume() {
        super.onResume();
        try {
            this.mCurConfig.updateFrom(ActivityManagerNative.getDefault().getConfiguration());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (this.mCurConfig.fontScale < 1.0f) {
            this.mFontSize.setSelection(0);
        } else if (this.mCurConfig.fontScale > 1.0f) {
            this.mFontSize.setSelection(2);
        } else {
            this.mFontSize.setSelection(1);
        }
        this.updateFontScale();
    }

    private void updateFontScale() {
        this.mDisplayMetrics.scaledDensity = this.mDisplayMetrics.density * this.mCurConfig.fontScale;
        float size = this.mTextSizeTyped.getDimension(this.mDisplayMetrics);
        this.mPreview.setTextSize(0, size);
    }

    public void onClick(View v) {
        try {
            ActivityManagerNative.getDefault().updateConfiguration(this.mCurConfig);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.finish();
    }
}

