/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceGroup;
import android.preference.PreferenceScreen;
import android.provider.Settings;
import android.util.Log;
import com.android.internal.app.PlatLogoActivity;
import com.android.settings.Utils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeviceInfoSettings
extends PreferenceActivity {
    private static final String TAG = "DeviceInfoSettings";
    private static final String KEY_CONTAINER = "container";
    private static final String KEY_TEAM = "team";
    private static final String KEY_CONTRIBUTORS = "contributors";
    private static final String KEY_TERMS = "terms";
    private static final String KEY_LICENSE = "license";
    private static final String KEY_COPYRIGHT = "copyright";
    private static final String KEY_SYSTEM_UPDATE_SETTINGS = "system_update_settings";
    private static final String PROPERTY_URL_SAFETYLEGAL = "ro.url.safetylegal";
    private static final String KEY_UPDATE_SETTING = "additional_system_update_settings";
    long[] mHits = new long[3];

    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.addPreferencesFromResource(2130968586);
        String currentIme = Settings.Secure.getString((ContentResolver)this.getContentResolver(), (String)"default_input_method");
        ComponentName component = ComponentName.unflattenFromString((String)currentIme);
        Intent imeIntent = new Intent(component.getPackageName() + ".tutorial");
        PackageManager pm = this.getPackageManager();
        List tutorials = pm.queryIntentActivities(imeIntent, 0);
        if (tutorials == null || tutorials.isEmpty()) {
            this.getPreferenceScreen().removePreference(this.findPreference("system_tutorial"));
        }
        this.setStringSummary("firmware_version", Build.VERSION.RELEASE);
        this.findPreference("firmware_version").setEnabled(true);
        this.setValueSummary("baseband_version", "gsm.version.baseband");
        this.setStringSummary("device_model", Build.MODEL);
        this.setStringSummary("build_number", Build.DISPLAY);
        this.findPreference("kernel_version").setSummary((CharSequence)this.getFormattedKernelVersion());
        this.removePreferenceIfPropertyMissing((PreferenceGroup)this.getPreferenceScreen(), "safetylegal", PROPERTY_URL_SAFETYLEGAL);
        PreferenceGroup parentPreference = (PreferenceGroup)this.findPreference(KEY_CONTAINER);
        Utils.updatePreferenceToSpecificActivityOrRemove((Context)this, parentPreference, KEY_TERMS, 1);
        Utils.updatePreferenceToSpecificActivityOrRemove((Context)this, parentPreference, KEY_LICENSE, 1);
        Utils.updatePreferenceToSpecificActivityOrRemove((Context)this, parentPreference, KEY_COPYRIGHT, 1);
        Utils.updatePreferenceToSpecificActivityOrRemove((Context)this, parentPreference, KEY_TEAM, 1);
        parentPreference = this.getPreferenceScreen();
        Utils.updatePreferenceToSpecificActivityOrRemove((Context)this, parentPreference, KEY_SYSTEM_UPDATE_SETTINGS, 1);
        Utils.updatePreferenceToSpecificActivityOrRemove((Context)this, parentPreference, KEY_CONTRIBUTORS, 1);
        boolean mUpdateSettingAvailable = this.getResources().getBoolean(2131099650);
        if (!mUpdateSettingAvailable) {
            this.getPreferenceScreen().removePreference(this.findPreference(KEY_UPDATE_SETTING));
        }
    }

    public boolean onPreferenceTreeClick(PreferenceScreen preferenceScreen, Preference preference) {
        if (preference.getKey().equals("firmware_version")) {
            System.arraycopy(this.mHits, 1, this.mHits, 0, this.mHits.length - 1);
            this.mHits[this.mHits.length - 1] = SystemClock.uptimeMillis();
            if (this.mHits[0] >= SystemClock.uptimeMillis() - 500L) {
                Intent intent = new Intent("android.intent.action.MAIN");
                intent.setClassName("android", PlatLogoActivity.class.getName());
                try {
                    this.startActivity(intent);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return super.onPreferenceTreeClick(preferenceScreen, preference);
    }

    private void removePreferenceIfPropertyMissing(PreferenceGroup preferenceGroup, String preference, String property) {
        if (SystemProperties.get((String)property).equals("")) {
            try {
                preferenceGroup.removePreference(this.findPreference(preference));
            }
            catch (RuntimeException e) {
                Log.d((String)TAG, (String)("Property '" + property + "' missing and no '" + preference + "' preference"));
            }
        }
    }

    private void setStringSummary(String preference, String value) {
        try {
            this.findPreference(preference).setSummary((CharSequence)value);
        }
        catch (RuntimeException e) {
            this.findPreference(preference).setSummary((CharSequence)this.getResources().getString(2131230724));
        }
    }

    private void setValueSummary(String preference, String property) {
        try {
            this.findPreference(preference).setSummary((CharSequence)SystemProperties.get((String)property, (String)this.getResources().getString(2131230724)));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFormattedKernelVersion() {
        try {
            String procVersionStr;
            BufferedReader reader = new BufferedReader(new FileReader("/proc/version"), 256);
            try {
                procVersionStr = reader.readLine();
            }
            finally {
                reader.close();
            }
            String PROC_VERSION_REGEX = "\\w+\\s+\\w+\\s+([^\\s]+)\\s+\\(([^\\s@]+(?:@[^\\s.]+)?)[^)]*\\)\\s+\\((?:[^(]*\\([^)]*\\))?[^)]*\\)\\s+([^\\s]+)\\s+(?:PREEMPT\\s+)?(.+)";
            Pattern p = Pattern.compile("\\w+\\s+\\w+\\s+([^\\s]+)\\s+\\(([^\\s@]+(?:@[^\\s.]+)?)[^)]*\\)\\s+\\((?:[^(]*\\([^)]*\\))?[^)]*\\)\\s+([^\\s]+)\\s+(?:PREEMPT\\s+)?(.+)");
            Matcher m = p.matcher(procVersionStr);
            if (!m.matches()) {
                Log.e((String)TAG, (String)("Regex did not match on /proc/version: " + procVersionStr));
                return "Unavailable";
            }
            if (m.groupCount() < 4) {
                Log.e((String)TAG, (String)("Regex match on /proc/version only returned " + m.groupCount() + " groups"));
                return "Unavailable";
            }
            return m.group(1) + "\n" + m.group(2) + " " + m.group(3) + "\n" + m.group(4);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"IO Exception when getting kernel version for Device Info screen", (Throwable)e);
            return "Unavailable";
        }
    }
}

