/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.app.ListActivity;
import android.app.admin.DeviceAdminInfo;
import android.app.admin.DevicePolicyManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.android.settings.DeviceAdminAdd;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.xmlpull.v1.XmlPullParserException;

public class DeviceAdminSettings
extends ListActivity {
    static final String TAG = "DeviceAdminSettings";
    static final int DIALOG_WARNING = 1;
    DevicePolicyManager mDPM;
    final HashSet<ComponentName> mActiveAdmins = new HashSet();
    final ArrayList<DeviceAdminInfo> mAvailableAdmins = new ArrayList();

    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.mDPM = (DevicePolicyManager)this.getSystemService("device_policy");
        this.setContentView(2130903060);
    }

    protected void onResume() {
        super.onResume();
        this.updateList();
    }

    void updateList() {
        this.mActiveAdmins.clear();
        List cur = this.mDPM.getActiveAdmins();
        if (cur != null) {
            for (int i = 0; i < cur.size(); ++i) {
                this.mActiveAdmins.add((ComponentName)cur.get(i));
            }
        }
        this.mAvailableAdmins.clear();
        List avail = this.getPackageManager().queryBroadcastReceivers(new Intent("android.app.action.DEVICE_ADMIN_ENABLED"), 128);
        int count = avail == null ? 0 : avail.size();
        for (int i = 0; i < count; ++i) {
            ResolveInfo ri = (ResolveInfo)avail.get(i);
            try {
                DeviceAdminInfo dpi = new DeviceAdminInfo((Context)this, ri);
                if (!dpi.isVisible() && !this.mActiveAdmins.contains(dpi.getComponent())) continue;
                this.mAvailableAdmins.add(dpi);
                continue;
            }
            catch (XmlPullParserException e) {
                Log.w((String)TAG, (String)("Skipping " + ri.activityInfo), (Throwable)e);
                continue;
            }
            catch (IOException e) {
                Log.w((String)TAG, (String)("Skipping " + ri.activityInfo), (Throwable)e);
            }
        }
        this.getListView().setAdapter((ListAdapter)new PolicyListAdapter());
    }

    protected void onListItemClick(ListView l, View v, int position, long id2) {
        DeviceAdminInfo dpi = (DeviceAdminInfo)l.getAdapter().getItem(position);
        Intent intent = new Intent();
        intent.setClass((Context)this, DeviceAdminAdd.class);
        intent.putExtra("android.app.extra.DEVICE_ADMIN", (Parcelable)dpi.getComponent());
        this.startActivity(intent);
    }

    class PolicyListAdapter
    extends BaseAdapter {
        final LayoutInflater mInflater;

        PolicyListAdapter() {
            this.mInflater = (LayoutInflater)DeviceAdminSettings.this.getSystemService("layout_inflater");
        }

        public boolean hasStableIds() {
            return true;
        }

        public int getCount() {
            return DeviceAdminSettings.this.mAvailableAdmins.size();
        }

        public Object getItem(int position) {
            return DeviceAdminSettings.this.mAvailableAdmins.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public boolean areAllItemsEnabled() {
            return false;
        }

        public boolean isEnabled(int position) {
            return true;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            View v = convertView == null ? this.newView(parent) : convertView;
            this.bindView(v, position);
            return v;
        }

        public View newView(ViewGroup parent) {
            View v = this.mInflater.inflate(2130903059, parent, false);
            ViewHolder h = new ViewHolder();
            h.icon = (ImageView)v.findViewById(2131427349);
            h.name = (TextView)v.findViewById(2131427379);
            h.checkbox = (CheckBox)v.findViewById(2131427380);
            h.description = (TextView)v.findViewById(2131427381);
            v.setTag((Object)h);
            return v;
        }

        public void bindView(View view, int position) {
            ViewHolder vh = (ViewHolder)view.getTag();
            DeviceAdminInfo item = DeviceAdminSettings.this.mAvailableAdmins.get(position);
            vh.icon.setImageDrawable(item.loadIcon(DeviceAdminSettings.this.getPackageManager()));
            vh.name.setText(item.loadLabel(DeviceAdminSettings.this.getPackageManager()));
            vh.checkbox.setChecked(DeviceAdminSettings.this.mActiveAdmins.contains(item.getComponent()));
            try {
                vh.description.setText(item.loadDescription(DeviceAdminSettings.this.getPackageManager()));
            }
            catch (Resources.NotFoundException e) {
                // empty catch block
            }
        }
    }

    static class ViewHolder {
        ImageView icon;
        TextView name;
        CheckBox checkbox;
        TextView description;

        ViewHolder() {
        }
    }
}

