/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.admin.DeviceAdminInfo;
import android.app.admin.DevicePolicyManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Handler;
import android.os.RemoteCallback;
import android.text.TextUtils;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.AppSecurityPermissions;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import java.io.IOException;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceAdminAdd
extends Activity {
    static final String TAG = "DeviceAdminAdd";
    static final int DIALOG_WARNING = 1;
    private static final int MAX_ADD_MSG_LINES_PORTRAIT = 5;
    private static final int MAX_ADD_MSG_LINES_LANDSCAPE = 2;
    private static final int MAX_ADD_MSG_LINES = 15;
    Handler mHandler;
    DevicePolicyManager mDPM;
    DeviceAdminInfo mDeviceAdmin;
    CharSequence mAddMsgText;
    TextView mTitle;
    ImageView mAdminIcon;
    TextView mAdminName;
    TextView mAdminDescription;
    TextView mAddMsg;
    boolean mAddMsgEllipsized = true;
    TextView mAdminWarning;
    ViewGroup mAdminPolicies;
    Button mActionButton;
    Button mCancelButton;
    View mSelectLayout;
    final ArrayList<View> mAddingPolicies = new ArrayList();
    final ArrayList<View> mActivePolicies = new ArrayList();
    boolean mAdding;

    protected void onCreate(Bundle icicle) {
        ActivityInfo ai;
        super.onCreate(icicle);
        this.mHandler = new Handler(this.getMainLooper());
        this.mDPM = (DevicePolicyManager)this.getSystemService("device_policy");
        if ((this.getIntent().getFlags() & 0x10000000) != 0) {
            Log.w((String)TAG, (String)"Can now start ADD_DEVICE_ADMIN as a new task");
            this.finish();
            return;
        }
        ComponentName cn = (ComponentName)this.getIntent().getParcelableExtra("android.app.extra.DEVICE_ADMIN");
        if (cn == null) {
            Log.w((String)TAG, (String)("No component specified in " + this.getIntent().getAction()));
            this.finish();
            return;
        }
        if ("android.app.action.ADD_DEVICE_ADMIN".equals(this.getIntent().getAction()) && this.mDPM.isAdminActive(cn)) {
            this.setResult(-1);
            this.finish();
            return;
        }
        try {
            ai = this.getPackageManager().getReceiverInfo(cn, 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w((String)TAG, (String)("Unable to retrieve device policy " + cn), (Throwable)e);
            this.finish();
            return;
        }
        ResolveInfo ri = new ResolveInfo();
        ri.activityInfo = ai;
        try {
            this.mDeviceAdmin = new DeviceAdminInfo((Context)this, ri);
        }
        catch (XmlPullParserException e) {
            Log.w((String)TAG, (String)("Unable to retrieve device policy " + cn), (Throwable)e);
            this.finish();
            return;
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)("Unable to retrieve device policy " + cn), (Throwable)e);
            this.finish();
            return;
        }
        this.mAddMsgText = this.getIntent().getCharSequenceExtra("android.app.extra.ADD_EXPLANATION");
        this.setContentView(2130903058);
        this.mTitle = (TextView)this.findViewById(2131427350);
        this.mAdminIcon = (ImageView)this.findViewById(2131427371);
        this.mAdminName = (TextView)this.findViewById(2131427372);
        this.mAdminDescription = (TextView)this.findViewById(2131427373);
        this.mAddMsg = (TextView)this.findViewById(2131427375);
        this.mAddMsg.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DeviceAdminAdd.this.toggleMessageEllipsis(v);
            }
        });
        this.toggleMessageEllipsis((View)this.mAddMsg);
        this.mAdminWarning = (TextView)this.findViewById(2131427376);
        this.mAdminPolicies = (ViewGroup)this.findViewById(2131427377);
        this.mCancelButton = (Button)this.findViewById(2131427355);
        this.mCancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DeviceAdminAdd.this.finish();
            }
        });
        this.mActionButton = (Button)this.findViewById(2131427378);
        this.mActionButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (DeviceAdminAdd.this.mAdding) {
                    block4: {
                        try {
                            DeviceAdminAdd.this.mDPM.setActiveAdmin(DeviceAdminAdd.this.mDeviceAdmin.getComponent());
                            DeviceAdminAdd.this.setResult(-1);
                        }
                        catch (RuntimeException e) {
                            Log.w((String)DeviceAdminAdd.TAG, (String)("Exception trying to activate admin " + DeviceAdminAdd.this.mDeviceAdmin.getComponent()), (Throwable)e);
                            if (!DeviceAdminAdd.this.mDPM.isAdminActive(DeviceAdminAdd.this.mDeviceAdmin.getComponent())) break block4;
                            DeviceAdminAdd.this.setResult(-1);
                        }
                    }
                    DeviceAdminAdd.this.finish();
                } else {
                    DeviceAdminAdd.this.mDPM.getRemoveWarning(DeviceAdminAdd.this.mDeviceAdmin.getComponent(), new RemoteCallback(DeviceAdminAdd.this.mHandler){

                        protected void onResult(Bundle bundle) {
                            CharSequence msg;
                            CharSequence charSequence = msg = bundle != null ? bundle.getCharSequence("android.app.extra.DISABLE_WARNING") : null;
                            if (msg == null) {
                                DeviceAdminAdd.this.mDPM.removeActiveAdmin(DeviceAdminAdd.this.mDeviceAdmin.getComponent());
                                DeviceAdminAdd.this.finish();
                            } else {
                                Bundle args = new Bundle();
                                args.putCharSequence("android.app.extra.DISABLE_WARNING", msg);
                                DeviceAdminAdd.this.showDialog(1, args);
                            }
                        }
                    });
                }
            }
        });
    }

    protected void onResume() {
        super.onResume();
        this.updateInterface();
    }

    protected Dialog onCreateDialog(int id2, Bundle args) {
        switch (id2) {
            case 1: {
                CharSequence msg = args.getCharSequence("android.app.extra.DISABLE_WARNING");
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
                builder.setMessage(msg);
                builder.setPositiveButton(2131231483, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        DeviceAdminAdd.this.mDPM.removeActiveAdmin(DeviceAdminAdd.this.mDeviceAdmin.getComponent());
                        DeviceAdminAdd.this.finish();
                    }
                });
                builder.setNegativeButton(2131231484, null);
                return builder.create();
            }
        }
        return super.onCreateDialog(id2, args);
    }

    static void setViewVisibility(ArrayList<View> views, int visibility) {
        int N = views.size();
        for (int i = 0; i < N; ++i) {
            views.get(i).setVisibility(visibility);
        }
    }

    void updateInterface() {
        this.mAdminIcon.setImageDrawable(this.mDeviceAdmin.loadIcon(this.getPackageManager()));
        this.mAdminName.setText(this.mDeviceAdmin.loadLabel(this.getPackageManager()));
        try {
            this.mAdminDescription.setText(this.mDeviceAdmin.loadDescription(this.getPackageManager()));
            this.mAdminDescription.setVisibility(0);
        }
        catch (Resources.NotFoundException e) {
            this.mAdminDescription.setVisibility(8);
        }
        if (this.mAddMsgText != null) {
            this.mAddMsg.setText(this.mAddMsgText);
            this.mAddMsg.setVisibility(0);
        } else {
            this.mAddMsg.setVisibility(8);
        }
        if (this.mDPM.isAdminActive(this.mDeviceAdmin.getComponent())) {
            if (this.mActivePolicies.size() == 0) {
                ArrayList policies = this.mDeviceAdmin.getUsedPolicies();
                for (int i = 0; i < policies.size(); ++i) {
                    DeviceAdminInfo.PolicyInfo pi = (DeviceAdminInfo.PolicyInfo)policies.get(i);
                    View view = AppSecurityPermissions.getPermissionItemView((Context)this, (CharSequence)this.getText(pi.label), (CharSequence)"", (boolean)true);
                    this.mActivePolicies.add(view);
                    this.mAdminPolicies.addView(view);
                }
            }
            DeviceAdminAdd.setViewVisibility(this.mActivePolicies, 0);
            DeviceAdminAdd.setViewVisibility(this.mAddingPolicies, 8);
            this.mAdminWarning.setText((CharSequence)this.getString(2131231873, new Object[]{this.mDeviceAdmin.getActivityInfo().applicationInfo.loadLabel(this.getPackageManager())}));
            this.mTitle.setText(this.getText(2131231865));
            this.mActionButton.setText(this.getText(2131231866));
            this.mAdding = false;
        } else {
            if (this.mAddingPolicies.size() == 0) {
                ArrayList policies = this.mDeviceAdmin.getUsedPolicies();
                for (int i = 0; i < policies.size(); ++i) {
                    DeviceAdminInfo.PolicyInfo pi = (DeviceAdminInfo.PolicyInfo)policies.get(i);
                    View view = AppSecurityPermissions.getPermissionItemView((Context)this, (CharSequence)this.getText(pi.label), (CharSequence)this.getText(pi.description), (boolean)true);
                    this.mAddingPolicies.add(view);
                    this.mAdminPolicies.addView(view);
                }
            }
            DeviceAdminAdd.setViewVisibility(this.mAddingPolicies, 0);
            DeviceAdminAdd.setViewVisibility(this.mActivePolicies, 8);
            this.mAdminWarning.setText((CharSequence)this.getString(2131231872, new Object[]{this.mDeviceAdmin.getActivityInfo().applicationInfo.loadLabel(this.getPackageManager())}));
            this.mTitle.setText(this.getText(2131231869));
            this.mActionButton.setText(this.getText(2131231870));
            this.mAdding = true;
        }
    }

    void toggleMessageEllipsis(View v) {
        TextView tv = (TextView)v;
        this.mAddMsgEllipsized = !this.mAddMsgEllipsized;
        tv.setEllipsize((TextUtils.TruncateAt)(this.mAddMsgEllipsized ? TextUtils.TruncateAt.END : null));
        tv.setMaxLines(this.mAddMsgEllipsized ? this.getEllipsizedLines() : 15);
        ImageView iv = (ImageView)this.findViewById(2131427374);
        iv.setImageResource(this.mAddMsgEllipsized ? 17301874 : 17301873);
    }

    int getEllipsizedLines() {
        Display d = ((WindowManager)this.getSystemService("window")).getDefaultDisplay();
        return d.getHeight() > d.getWidth() ? 5 : 2;
    }
}

