/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.preference.CheckBoxPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceScreen;
import android.provider.Settings;
import com.android.settings.Utils;

public class DevelopmentSettings
extends PreferenceActivity
implements DialogInterface.OnClickListener,
DialogInterface.OnDismissListener {
    private static final String ENABLE_ADB = "enable_adb";
    private static final String KEEP_SCREEN_ON = "keep_screen_on";
    private static final String ALLOW_MOCK_LOCATION = "allow_mock_location";
    private CheckBoxPreference mEnableAdb;
    private CheckBoxPreference mKeepScreenOn;
    private CheckBoxPreference mAllowMockLocation;
    private boolean mOkClicked;
    private Dialog mOkDialog;

    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.addPreferencesFromResource(2130968584);
        this.mEnableAdb = (CheckBoxPreference)this.findPreference(ENABLE_ADB);
        this.mKeepScreenOn = (CheckBoxPreference)this.findPreference(KEEP_SCREEN_ON);
        this.mAllowMockLocation = (CheckBoxPreference)this.findPreference(ALLOW_MOCK_LOCATION);
    }

    protected void onResume() {
        super.onResume();
        this.mEnableAdb.setChecked(Settings.Secure.getInt((ContentResolver)this.getContentResolver(), (String)"adb_enabled", (int)0) != 0);
        this.mKeepScreenOn.setChecked(Settings.System.getInt((ContentResolver)this.getContentResolver(), (String)"stay_on_while_plugged_in", (int)0) != 0);
        this.mAllowMockLocation.setChecked(Settings.Secure.getInt((ContentResolver)this.getContentResolver(), (String)"mock_location", (int)0) != 0);
    }

    public boolean onPreferenceTreeClick(PreferenceScreen preferenceScreen, Preference preference) {
        if (Utils.isMonkeyRunning()) {
            return false;
        }
        if (preference == this.mEnableAdb) {
            if (this.mEnableAdb.isChecked()) {
                this.mOkClicked = false;
                if (this.mOkDialog != null) {
                    this.dismissDialog();
                }
                this.mOkDialog = new AlertDialog.Builder((Context)this).setMessage((CharSequence)this.getResources().getString(2131231599)).setTitle(2131231598).setIcon(17301543).setPositiveButton(17039379, (DialogInterface.OnClickListener)this).setNegativeButton(17039369, (DialogInterface.OnClickListener)this).show();
                this.mOkDialog.setOnDismissListener((DialogInterface.OnDismissListener)this);
            } else {
                Settings.Secure.putInt((ContentResolver)this.getContentResolver(), (String)"adb_enabled", (int)0);
            }
        } else if (preference == this.mKeepScreenOn) {
            Settings.System.putInt((ContentResolver)this.getContentResolver(), (String)"stay_on_while_plugged_in", (int)(this.mKeepScreenOn.isChecked() ? 3 : 0));
        } else if (preference == this.mAllowMockLocation) {
            Settings.Secure.putInt((ContentResolver)this.getContentResolver(), (String)"mock_location", (int)(this.mAllowMockLocation.isChecked() ? 1 : 0));
        }
        return false;
    }

    private void dismissDialog() {
        if (this.mOkDialog == null) {
            return;
        }
        this.mOkDialog.dismiss();
        this.mOkDialog = null;
    }

    public void onClick(DialogInterface dialog, int which) {
        if (which == -1) {
            this.mOkClicked = true;
            Settings.Secure.putInt((ContentResolver)this.getContentResolver(), (String)"adb_enabled", (int)1);
        } else {
            this.mEnableAdb.setChecked(false);
        }
    }

    public void onDismiss(DialogInterface dialog) {
        if (!this.mOkClicked) {
            this.mEnableAdb.setChecked(false);
        }
    }

    public void onDestroy() {
        this.dismissDialog();
        super.onDestroy();
    }
}

