/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.app.DatePickerDialog;
import android.app.Dialog;
import android.app.TimePickerDialog;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.SystemClock;
import android.preference.CheckBoxPreference;
import android.preference.ListPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceScreen;
import android.provider.Settings;
import android.text.format.DateFormat;
import android.widget.DatePicker;
import android.widget.TimePicker;
import com.android.settings.ZoneList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateTimeSettings
extends PreferenceActivity
implements SharedPreferences.OnSharedPreferenceChangeListener,
TimePickerDialog.OnTimeSetListener,
DatePickerDialog.OnDateSetListener {
    private static final String HOURS_12 = "12";
    private static final String HOURS_24 = "24";
    private Calendar mDummyDate;
    private static final String KEY_DATE_FORMAT = "date_format";
    private static final String KEY_AUTO_TIME = "auto_time";
    private static final int DIALOG_DATEPICKER = 0;
    private static final int DIALOG_TIMEPICKER = 1;
    private CheckBoxPreference mAutoPref;
    private Preference mTimePref;
    private Preference mTime24Pref;
    private Preference mTimeZone;
    private Preference mDatePref;
    private ListPreference mDateFormat;
    private BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            DateTimeSettings.this.updateTimeAndDateDisplay();
        }
    };

    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.addPreferencesFromResource(2130968583);
        this.initUI();
    }

    private void initUI() {
        boolean autoEnabled = this.getAutoState();
        this.mDummyDate = Calendar.getInstance();
        this.mDummyDate.set(this.mDummyDate.get(1), 11, 31, 13, 0, 0);
        this.mAutoPref = (CheckBoxPreference)this.findPreference(KEY_AUTO_TIME);
        this.mAutoPref.setChecked(autoEnabled);
        this.mTimePref = this.findPreference("time");
        this.mTime24Pref = this.findPreference("24 hour");
        this.mTimeZone = this.findPreference("timezone");
        this.mDatePref = this.findPreference("date");
        this.mDateFormat = (ListPreference)this.findPreference(KEY_DATE_FORMAT);
        String[] dateFormats = this.getResources().getStringArray(2131034113);
        CharSequence[] formattedDates = new String[dateFormats.length];
        String currentFormat = this.getDateFormat();
        if (currentFormat == null) {
            currentFormat = "";
        }
        for (int i = 0; i < formattedDates.length; ++i) {
            String formatted = DateFormat.getDateFormatForSetting((Context)this, (String)dateFormats[i]).format(this.mDummyDate.getTime());
            formattedDates[i] = dateFormats[i].length() == 0 ? this.getResources().getString(2131230841, new Object[]{formatted}) : formatted;
        }
        this.mDateFormat.setEntries(formattedDates);
        this.mDateFormat.setEntryValues(2131034113);
        this.mDateFormat.setValue(currentFormat);
        this.mTimePref.setEnabled(!autoEnabled);
        this.mDatePref.setEnabled(!autoEnabled);
        this.mTimeZone.setEnabled(!autoEnabled);
    }

    protected void onResume() {
        super.onResume();
        this.getPreferenceScreen().getSharedPreferences().registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
        ((CheckBoxPreference)this.mTime24Pref).setChecked(this.is24Hour());
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.TIME_TICK");
        filter.addAction("android.intent.action.TIME_SET");
        filter.addAction("android.intent.action.TIMEZONE_CHANGED");
        this.registerReceiver(this.mIntentReceiver, filter, null, null);
        this.updateTimeAndDateDisplay();
    }

    protected void onPause() {
        super.onPause();
        this.unregisterReceiver(this.mIntentReceiver);
        this.getPreferenceScreen().getSharedPreferences().unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
    }

    private void updateTimeAndDateDisplay() {
        java.text.DateFormat shortDateFormat = DateFormat.getDateFormat((Context)this);
        Date now = Calendar.getInstance().getTime();
        Date dummyDate = this.mDummyDate.getTime();
        this.mTimePref.setSummary((CharSequence)DateFormat.getTimeFormat((Context)this).format(now));
        this.mTimeZone.setSummary((CharSequence)this.getTimeZoneText());
        this.mDatePref.setSummary((CharSequence)shortDateFormat.format(now));
        this.mDateFormat.setSummary((CharSequence)shortDateFormat.format(dummyDate));
    }

    public void onDateSet(DatePicker view, int year, int month, int day) {
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, month);
        c.set(5, day);
        long when = c.getTimeInMillis();
        if (when / 1000L < Integer.MAX_VALUE) {
            SystemClock.setCurrentTimeMillis((long)when);
        }
        this.updateTimeAndDateDisplay();
    }

    public void onTimeSet(TimePicker view, int hourOfDay, int minute) {
        Calendar c = Calendar.getInstance();
        c.set(11, hourOfDay);
        c.set(12, minute);
        long when = c.getTimeInMillis();
        if (when / 1000L < Integer.MAX_VALUE) {
            SystemClock.setCurrentTimeMillis((long)when);
        }
        this.updateTimeAndDateDisplay();
    }

    public void onSharedPreferenceChanged(SharedPreferences preferences, String key) {
        if (key.equals(KEY_DATE_FORMAT)) {
            String format = preferences.getString(key, this.getResources().getString(2131230840));
            Settings.System.putString((ContentResolver)this.getContentResolver(), (String)KEY_DATE_FORMAT, (String)format);
            this.updateTimeAndDateDisplay();
        } else if (key.equals(KEY_AUTO_TIME)) {
            boolean autoEnabled = preferences.getBoolean(key, true);
            Settings.System.putInt((ContentResolver)this.getContentResolver(), (String)KEY_AUTO_TIME, (int)(autoEnabled ? 1 : 0));
            this.mTimePref.setEnabled(!autoEnabled);
            this.mDatePref.setEnabled(!autoEnabled);
            this.mTimeZone.setEnabled(!autoEnabled);
        }
    }

    public Dialog onCreateDialog(int id2) {
        TimePickerDialog d;
        switch (id2) {
            case 0: {
                Calendar calendar = Calendar.getInstance();
                d = new DatePickerDialog((Context)this, (DatePickerDialog.OnDateSetListener)this, calendar.get(1), calendar.get(2), calendar.get(5));
                d.setTitle((CharSequence)this.getResources().getString(2131230838));
                break;
            }
            case 1: {
                Calendar calendar = Calendar.getInstance();
                d = new TimePickerDialog((Context)this, (TimePickerDialog.OnTimeSetListener)this, calendar.get(11), calendar.get(12), DateFormat.is24HourFormat((Context)this));
                d.setTitle((CharSequence)this.getResources().getString(2131230837));
                break;
            }
            default: {
                d = null;
            }
        }
        return d;
    }

    public void onPrepareDialog(int id2, Dialog d) {
        switch (id2) {
            case 0: {
                DatePickerDialog datePicker = (DatePickerDialog)d;
                Calendar calendar = Calendar.getInstance();
                datePicker.updateDate(calendar.get(1), calendar.get(2), calendar.get(5));
                break;
            }
            case 1: {
                TimePickerDialog timePicker = (TimePickerDialog)d;
                Calendar calendar = Calendar.getInstance();
                timePicker.updateTime(calendar.get(11), calendar.get(12));
                break;
            }
        }
    }

    public boolean onPreferenceTreeClick(PreferenceScreen preferenceScreen, Preference preference) {
        if (preference == this.mDatePref) {
            this.showDialog(0);
        } else if (preference == this.mTimePref) {
            this.removeDialog(1);
            this.showDialog(1);
        } else if (preference == this.mTime24Pref) {
            this.set24Hour(((CheckBoxPreference)this.mTime24Pref).isChecked());
            this.updateTimeAndDateDisplay();
            this.timeUpdated();
        } else if (preference == this.mTimeZone) {
            Intent intent = new Intent();
            intent.setClass((Context)this, ZoneList.class);
            this.startActivityForResult(intent, 0);
        }
        return false;
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.updateTimeAndDateDisplay();
    }

    private void timeUpdated() {
        Intent timeChanged = new Intent("android.intent.action.TIME_SET");
        this.sendBroadcast(timeChanged);
    }

    private boolean is24Hour() {
        return DateFormat.is24HourFormat((Context)this);
    }

    private void set24Hour(boolean is24Hour) {
        Settings.System.putString((ContentResolver)this.getContentResolver(), (String)"time_12_24", (String)(is24Hour ? HOURS_24 : HOURS_12));
    }

    private String getDateFormat() {
        return Settings.System.getString((ContentResolver)this.getContentResolver(), (String)KEY_DATE_FORMAT);
    }

    private boolean getAutoState() {
        try {
            return Settings.System.getInt((ContentResolver)this.getContentResolver(), (String)KEY_AUTO_TIME) > 0;
        }
        catch (Settings.SettingNotFoundException snfe) {
            return true;
        }
    }

    private void setDateFormat(String format) {
        if (format.length() == 0) {
            format = null;
        }
        Settings.System.putString((ContentResolver)this.getContentResolver(), (String)KEY_DATE_FORMAT, (String)format);
    }

    private String getTimeZoneText() {
        TimeZone tz = Calendar.getInstance().getTimeZone();
        boolean daylight = tz.inDaylightTime(new Date());
        StringBuilder sb = new StringBuilder();
        sb.append(this.formatOffset(tz.getRawOffset() + (daylight ? tz.getDSTSavings() : 0))).append(", ").append(tz.getDisplayName(daylight, 1));
        return sb.toString();
    }

    private char[] formatOffset(int off) {
        off = off / 1000 / 60;
        char[] buf = new char[9];
        buf[0] = 71;
        buf[1] = 77;
        buf[2] = 84;
        if (off < 0) {
            buf[3] = 45;
            off = -off;
        } else {
            buf[3] = 43;
        }
        int hours = off / 60;
        int minutes = off % 60;
        buf[4] = (char)(48 + hours / 10);
        buf[5] = (char)(48 + hours % 10);
        buf[6] = 58;
        buf[7] = (char)(48 + minutes / 10);
        buf[8] = (char)(48 + minutes % 10);
        return buf;
    }
}

