/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.security.Credentials;
import android.security.KeyStore;
import android.util.Log;

public class CredentialInstaller
extends Activity {
    private static final String TAG = "CredentialInstaller";
    private static final String UNLOCKING = "ulck";
    private KeyStore mKeyStore = KeyStore.getInstance();
    private boolean mUnlocking = false;

    protected void onResume() {
        super.onResume();
        if (!"com.android.certinstaller".equals(this.getCallingPackage())) {
            this.finish();
        }
        if (this.isKeyStoreUnlocked()) {
            this.install();
        } else if (!this.mUnlocking) {
            this.mUnlocking = true;
            Credentials.getInstance().unlock((Context)this);
            return;
        }
        this.finish();
    }

    protected void onSaveInstanceState(Bundle outStates) {
        super.onSaveInstanceState(outStates);
        outStates.putBoolean(UNLOCKING, this.mUnlocking);
    }

    protected void onRestoreInstanceState(Bundle savedStates) {
        super.onRestoreInstanceState(savedStates);
        this.mUnlocking = savedStates.getBoolean(UNLOCKING);
    }

    private void install() {
        Bundle bundle;
        Intent intent = this.getIntent();
        Bundle bundle2 = bundle = intent == null ? null : intent.getExtras();
        if (bundle == null) {
            return;
        }
        for (String key : bundle.keySet()) {
            byte[] data = bundle.getByteArray(key);
            if (data == null) continue;
            boolean success = this.mKeyStore.put(key.getBytes(), data);
            Log.d((String)TAG, (String)("install " + key + ": " + data.length + "  success? " + success));
            if (success) continue;
            return;
        }
        this.setResult(-1);
    }

    private boolean isKeyStoreUnlocked() {
        return this.mKeyStore.test() == 1;
    }
}

