/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.SystemClock;
import android.view.View;
import android.widget.TextView;
import com.android.internal.widget.LinearLayoutWithDefaultTouchRecepient;
import com.android.internal.widget.LockPatternUtils;
import com.android.internal.widget.LockPatternView;
import java.util.List;

public class ConfirmLockPattern
extends Activity {
    public static final String HEADER_TEXT = "com.android.settings.ConfirmLockPattern.header";
    public static final String FOOTER_TEXT = "com.android.settings.ConfirmLockPattern.footer";
    public static final String HEADER_WRONG_TEXT = "com.android.settings.ConfirmLockPattern.header_wrong";
    public static final String FOOTER_WRONG_TEXT = "com.android.settings.ConfirmLockPattern.footer_wrong";
    private static final int WRONG_PATTERN_CLEAR_TIMEOUT_MS = 2000;
    private static final String KEY_NUM_WRONG_ATTEMPTS = "num_wrong_attempts";
    private LockPatternView mLockPatternView;
    private LockPatternUtils mLockPatternUtils;
    private int mNumWrongConfirmAttempts;
    private CountDownTimer mCountdownTimer;
    private TextView mHeaderTextView;
    private TextView mFooterTextView;
    private CharSequence mHeaderText;
    private CharSequence mFooterText;
    private CharSequence mHeaderWrongText;
    private CharSequence mFooterWrongText;
    private Runnable mClearPatternRunnable = new Runnable(){

        public void run() {
            ConfirmLockPattern.this.mLockPatternView.clearPattern();
        }
    };
    private LockPatternView.OnPatternListener mConfirmExistingLockPatternListener = new LockPatternView.OnPatternListener(){

        public void onPatternStart() {
            ConfirmLockPattern.this.mLockPatternView.removeCallbacks(ConfirmLockPattern.this.mClearPatternRunnable);
        }

        public void onPatternCleared() {
            ConfirmLockPattern.this.mLockPatternView.removeCallbacks(ConfirmLockPattern.this.mClearPatternRunnable);
        }

        public void onPatternCellAdded(List<LockPatternView.Cell> pattern) {
        }

        public void onPatternDetected(List<LockPatternView.Cell> pattern) {
            if (ConfirmLockPattern.this.mLockPatternUtils.checkPattern(pattern)) {
                ConfirmLockPattern.this.setResult(-1);
                ConfirmLockPattern.this.finish();
            } else if (pattern.size() >= 3 && ++ConfirmLockPattern.this.mNumWrongConfirmAttempts >= 5) {
                long deadline = ConfirmLockPattern.this.mLockPatternUtils.setLockoutAttemptDeadline();
                ConfirmLockPattern.this.handleAttemptLockout(deadline);
            } else {
                ConfirmLockPattern.this.updateStage(Stage.NeedToUnlockWrong);
                ConfirmLockPattern.this.postClearPatternRunnable();
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mLockPatternUtils = new LockPatternUtils((Context)this);
        this.requestWindowFeature(1);
        this.setContentView(2130903054);
        this.mHeaderTextView = (TextView)this.findViewById(2131427351);
        this.mLockPatternView = (LockPatternView)this.findViewById(2131427358);
        this.mFooterTextView = (TextView)this.findViewById(2131427359);
        LinearLayoutWithDefaultTouchRecepient topLayout = (LinearLayoutWithDefaultTouchRecepient)this.findViewById(2131427357);
        topLayout.setDefaultTouchRecepient((View)this.mLockPatternView);
        Intent intent = this.getIntent();
        if (intent != null) {
            this.mHeaderText = intent.getCharSequenceExtra(HEADER_TEXT);
            this.mFooterText = intent.getCharSequenceExtra(FOOTER_TEXT);
            this.mHeaderWrongText = intent.getCharSequenceExtra(HEADER_WRONG_TEXT);
            this.mFooterWrongText = intent.getCharSequenceExtra(FOOTER_WRONG_TEXT);
        }
        this.mLockPatternView.setTactileFeedbackEnabled(this.mLockPatternUtils.isTactileFeedbackEnabled());
        this.mLockPatternView.setOnPatternListener(this.mConfirmExistingLockPatternListener);
        this.updateStage(Stage.NeedToUnlock);
        if (savedInstanceState != null) {
            this.mNumWrongConfirmAttempts = savedInstanceState.getInt(KEY_NUM_WRONG_ATTEMPTS);
        } else if (!this.mLockPatternUtils.savedPatternExists()) {
            this.setResult(-1);
            this.finish();
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        outState.putInt(KEY_NUM_WRONG_ATTEMPTS, this.mNumWrongConfirmAttempts);
    }

    protected void onPause() {
        super.onPause();
        if (this.mCountdownTimer != null) {
            this.mCountdownTimer.cancel();
        }
    }

    protected void onResume() {
        super.onResume();
        long deadline = this.mLockPatternUtils.getLockoutAttemptDeadline();
        if (deadline != 0L) {
            this.handleAttemptLockout(deadline);
        }
    }

    private void updateStage(Stage stage) {
        switch (stage) {
            case NeedToUnlock: {
                if (this.mHeaderText != null) {
                    this.mHeaderTextView.setText(this.mHeaderText);
                } else {
                    this.mHeaderTextView.setText(2131231405);
                }
                if (this.mFooterText != null) {
                    this.mFooterTextView.setText(this.mFooterText);
                } else {
                    this.mFooterTextView.setText(2131231406);
                }
                this.mLockPatternView.setEnabled(true);
                this.mLockPatternView.enableInput();
                break;
            }
            case NeedToUnlockWrong: {
                if (this.mHeaderWrongText != null) {
                    this.mHeaderTextView.setText(this.mHeaderWrongText);
                } else {
                    this.mHeaderTextView.setText(2131231407);
                }
                if (this.mFooterWrongText != null) {
                    this.mFooterTextView.setText(this.mFooterWrongText);
                } else {
                    this.mFooterTextView.setText(2131231408);
                }
                this.mLockPatternView.setDisplayMode(LockPatternView.DisplayMode.Wrong);
                this.mLockPatternView.setEnabled(true);
                this.mLockPatternView.enableInput();
                break;
            }
            case LockedOut: {
                this.mLockPatternView.clearPattern();
                this.mLockPatternView.setEnabled(false);
            }
        }
    }

    private void postClearPatternRunnable() {
        this.mLockPatternView.removeCallbacks(this.mClearPatternRunnable);
        this.mLockPatternView.postDelayed(this.mClearPatternRunnable, 2000L);
    }

    private void handleAttemptLockout(long elapsedRealtimeDeadline) {
        this.updateStage(Stage.LockedOut);
        long elapsedRealtime = SystemClock.elapsedRealtime();
        this.mCountdownTimer = new CountDownTimer(elapsedRealtimeDeadline - elapsedRealtime, 1000L){

            public void onTick(long millisUntilFinished) {
                ConfirmLockPattern.this.mHeaderTextView.setText(2131231428);
                int secondsCountdown = (int)(millisUntilFinished / 1000L);
                ConfirmLockPattern.this.mFooterTextView.setText((CharSequence)ConfirmLockPattern.this.getString(2131231429, new Object[]{secondsCountdown}));
            }

            public void onFinish() {
                ConfirmLockPattern.this.mNumWrongConfirmAttempts = 0;
                ConfirmLockPattern.this.updateStage(Stage.NeedToUnlock);
            }
        }.start();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Stage {
        NeedToUnlock,
        NeedToUnlockWrong,
        LockedOut;

    }
}

