/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.app.Activity;
import android.content.Context;
import android.inputmethodservice.KeyboardView;
import android.os.Bundle;
import android.os.Handler;
import android.view.KeyEvent;
import android.view.View;
import android.widget.TextView;
import com.android.internal.widget.LockPatternUtils;
import com.android.internal.widget.PasswordEntryKeyboardHelper;
import com.android.internal.widget.PasswordEntryKeyboardView;

public class ConfirmLockPassword
extends Activity
implements View.OnClickListener,
TextView.OnEditorActionListener {
    private static final long ERROR_MESSAGE_TIMEOUT = 3000L;
    private TextView mPasswordEntry;
    private LockPatternUtils mLockPatternUtils;
    private TextView mHeaderText;
    private Handler mHandler = new Handler();
    private PasswordEntryKeyboardHelper mKeyboardHelper;
    private PasswordEntryKeyboardView mKeyboardView;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mLockPatternUtils = new LockPatternUtils((Context)this);
        this.initViews();
    }

    private void initViews() {
        int storedQuality = this.mLockPatternUtils.getKeyguardStoredPasswordQuality();
        this.setContentView(2130903053);
        this.getWindow().setFlags(131072, 131072);
        this.findViewById(2131427355).setOnClickListener((View.OnClickListener)this);
        this.findViewById(2131427356).setOnClickListener((View.OnClickListener)this);
        this.mPasswordEntry = (TextView)this.findViewById(2131427353);
        this.mPasswordEntry.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        this.mKeyboardView = (PasswordEntryKeyboardView)this.findViewById(2131427354);
        this.mHeaderText = (TextView)this.findViewById(2131427351);
        boolean isAlpha = 262144 == storedQuality || 327680 == storedQuality;
        this.mHeaderText.setText(isAlpha ? 2131231395 : 2131231396);
        this.mKeyboardHelper = new PasswordEntryKeyboardHelper((Context)this, (KeyboardView)this.mKeyboardView, (View)this.mPasswordEntry);
        this.mKeyboardHelper.setKeyboardMode(isAlpha ? 0 : 1);
        this.mKeyboardView.requestFocus();
    }

    protected void onPause() {
        super.onPause();
        this.mKeyboardView.requestFocus();
    }

    protected void onResume() {
        super.onResume();
        this.mKeyboardView.requestFocus();
    }

    private void handleNext() {
        String pin = ((Object)this.mPasswordEntry.getText()).toString();
        if (this.mLockPatternUtils.checkPassword(pin)) {
            this.setResult(-1);
            this.finish();
        } else {
            this.showError(2131231407);
        }
    }

    public void onClick(View v) {
        switch (v.getId()) {
            case 2131427356: {
                this.handleNext();
                break;
            }
            case 2131427355: {
                this.setResult(0);
                this.finish();
            }
        }
    }

    private void showError(int msg) {
        this.mHeaderText.setText(msg);
        this.mPasswordEntry.setText(null);
        this.mHandler.postDelayed(new Runnable(){

            public void run() {
                ConfirmLockPassword.this.mHeaderText.setText(2131231395);
            }
        }, 3000L);
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        if (actionId == 0) {
            this.handleNext();
            return true;
        }
        return false;
    }
}

