/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.android.internal.widget.LockPatternUtils;

public class ChooseLockSettingsHelper {
    private LockPatternUtils mLockPatternUtils;
    private Activity mActivity;

    public ChooseLockSettingsHelper(Activity activity) {
        this.mActivity = activity;
        this.mLockPatternUtils = new LockPatternUtils((Context)activity);
    }

    public LockPatternUtils utils() {
        return this.mLockPatternUtils;
    }

    protected boolean launchConfirmationActivity(int request, CharSequence message, CharSequence details) {
        boolean launched = false;
        switch (this.mLockPatternUtils.getKeyguardStoredPasswordQuality()) {
            case 65536: {
                launched = this.confirmPattern(request, message, details);
                break;
            }
            case 131072: 
            case 262144: 
            case 327680: {
                launched = this.confirmPassword(request);
            }
        }
        return launched;
    }

    private boolean confirmPattern(int request, CharSequence message, CharSequence details) {
        if (!this.mLockPatternUtils.isLockPatternEnabled() || !this.mLockPatternUtils.savedPatternExists()) {
            return false;
        }
        Intent intent = new Intent();
        intent.putExtra("com.android.settings.ConfirmLockPattern.header", message);
        intent.putExtra("com.android.settings.ConfirmLockPattern.footer", details);
        intent.setClassName("com.android.settings", "com.android.settings.ConfirmLockPattern");
        this.mActivity.startActivityForResult(intent, request);
        return true;
    }

    private boolean confirmPassword(int request) {
        if (!this.mLockPatternUtils.isLockPasswordEnabled()) {
            return false;
        }
        Intent intent = new Intent();
        intent.setClassName("com.android.settings", "com.android.settings.ConfirmLockPassword");
        this.mActivity.startActivityForResult(intent, request);
        return true;
    }
}

