/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.widget.TextView;
import com.android.internal.widget.LinearLayoutWithDefaultTouchRecepient;
import com.android.internal.widget.LockPatternUtils;
import com.android.internal.widget.LockPatternView;
import com.android.settings.ChooseLockSettingsHelper;
import com.google.android.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ChooseLockPattern
extends Activity
implements View.OnClickListener {
    static final int RESULT_FINISHED = 1;
    public static final int CONFIRM_EXISTING_REQUEST = 55;
    static final int INFORMATION_MSG_TIMEOUT_MS = 3000;
    private static final int WRONG_PATTERN_CLEAR_TIMEOUT_MS = 2000;
    private static final int ID_EMPTY_MESSAGE = -1;
    protected TextView mHeaderText;
    protected LockPatternView mLockPatternView;
    protected TextView mFooterText;
    private TextView mFooterLeftButton;
    private TextView mFooterRightButton;
    protected List<LockPatternView.Cell> mChosenPattern = null;
    private final List<LockPatternView.Cell> mAnimatePattern = Collections.unmodifiableList(Lists.newArrayList((Object[])new LockPatternView.Cell[]{LockPatternView.Cell.of((int)0, (int)0), LockPatternView.Cell.of((int)0, (int)1), LockPatternView.Cell.of((int)1, (int)1), LockPatternView.Cell.of((int)2, (int)1)}));
    protected LockPatternView.OnPatternListener mChooseNewLockPatternListener = new LockPatternView.OnPatternListener(){

        public void onPatternStart() {
            ChooseLockPattern.this.mLockPatternView.removeCallbacks(ChooseLockPattern.this.mClearPatternRunnable);
            this.patternInProgress();
        }

        public void onPatternCleared() {
            ChooseLockPattern.this.mLockPatternView.removeCallbacks(ChooseLockPattern.this.mClearPatternRunnable);
        }

        public void onPatternDetected(List<LockPatternView.Cell> pattern) {
            if (ChooseLockPattern.this.mUiStage == Stage.NeedToConfirm || ChooseLockPattern.this.mUiStage == Stage.ConfirmWrong) {
                if (ChooseLockPattern.this.mChosenPattern == null) {
                    throw new IllegalStateException("null chosen pattern in stage 'need to confirm");
                }
                if (((Object)ChooseLockPattern.this.mChosenPattern).equals(pattern)) {
                    ChooseLockPattern.this.updateStage(Stage.ChoiceConfirmed);
                } else {
                    ChooseLockPattern.this.updateStage(Stage.ConfirmWrong);
                }
            } else if (ChooseLockPattern.this.mUiStage == Stage.Introduction || ChooseLockPattern.this.mUiStage == Stage.ChoiceTooShort) {
                if (pattern.size() < 4) {
                    ChooseLockPattern.this.updateStage(Stage.ChoiceTooShort);
                } else {
                    ChooseLockPattern.this.mChosenPattern = new ArrayList<LockPatternView.Cell>(pattern);
                    ChooseLockPattern.this.updateStage(Stage.FirstChoiceValid);
                }
            } else {
                throw new IllegalStateException("Unexpected stage " + (Object)((Object)ChooseLockPattern.this.mUiStage) + " when " + "entering the pattern.");
            }
        }

        public void onPatternCellAdded(List<LockPatternView.Cell> pattern) {
        }

        private void patternInProgress() {
            ChooseLockPattern.this.mHeaderText.setText(2131231411);
            ChooseLockPattern.this.mFooterText.setText((CharSequence)"");
            ChooseLockPattern.this.mFooterLeftButton.setEnabled(false);
            ChooseLockPattern.this.mFooterRightButton.setEnabled(false);
        }
    };
    private Stage mUiStage = Stage.Introduction;
    private Runnable mClearPatternRunnable = new Runnable(){

        public void run() {
            ChooseLockPattern.this.mLockPatternView.clearPattern();
        }
    };
    private ChooseLockSettingsHelper mChooseLockSettingsHelper;
    private static final String KEY_UI_STAGE = "uiStage";
    private static final String KEY_PATTERN_CHOICE = "chosenPattern";

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 55: {
                if (resultCode != -1) {
                    this.setResult(1);
                    this.finish();
                }
                this.updateStage(Stage.Introduction);
            }
        }
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mChooseLockSettingsHelper = new ChooseLockSettingsHelper(this);
        this.requestWindowFeature(1);
        this.setupViews();
        LinearLayoutWithDefaultTouchRecepient topLayout = (LinearLayoutWithDefaultTouchRecepient)this.findViewById(2131427357);
        topLayout.setDefaultTouchRecepient((View)this.mLockPatternView);
        boolean confirmCredentials = this.getIntent().getBooleanExtra("confirm_credentials", true);
        if (savedInstanceState == null) {
            if (confirmCredentials) {
                this.updateStage(Stage.NeedToConfirm);
                boolean launchedConfirmationActivity = this.mChooseLockSettingsHelper.launchConfirmationActivity(55, null, null);
                if (!launchedConfirmationActivity) {
                    this.updateStage(Stage.Introduction);
                }
            } else {
                this.updateStage(Stage.Introduction);
            }
        } else {
            String patternString = savedInstanceState.getString(KEY_PATTERN_CHOICE);
            if (patternString != null) {
                this.mChosenPattern = LockPatternUtils.stringToPattern((String)patternString);
            }
            this.updateStage(Stage.values()[savedInstanceState.getInt(KEY_UI_STAGE)]);
        }
    }

    protected void setupViews() {
        this.setContentView(2130903050);
        this.mHeaderText = (TextView)this.findViewById(2131427351);
        this.mLockPatternView = (LockPatternView)this.findViewById(2131427358);
        this.mLockPatternView.setOnPatternListener(this.mChooseNewLockPatternListener);
        this.mLockPatternView.setTactileFeedbackEnabled(this.mChooseLockSettingsHelper.utils().isTactileFeedbackEnabled());
        this.mFooterText = (TextView)this.findViewById(2131427359);
        this.mFooterLeftButton = (TextView)this.findViewById(2131427360);
        this.mFooterRightButton = (TextView)this.findViewById(2131427361);
        this.mFooterLeftButton.setOnClickListener((View.OnClickListener)this);
        this.mFooterRightButton.setOnClickListener((View.OnClickListener)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onClick(View v) {
        if (v == this.mFooterLeftButton) {
            if (this.mUiStage.leftMode == LeftButtonMode.Retry) {
                this.mChosenPattern = null;
                this.mLockPatternView.clearPattern();
                this.updateStage(Stage.Introduction);
                return;
            } else {
                if (this.mUiStage.leftMode != LeftButtonMode.Cancel) throw new IllegalStateException("left footer button pressed, but stage of " + (Object)((Object)this.mUiStage) + " doesn't make sense");
                this.setResult(1);
                this.finish();
            }
            return;
        } else {
            if (v != this.mFooterRightButton) return;
            if (this.mUiStage.rightMode == RightButtonMode.Continue) {
                if (this.mUiStage != Stage.FirstChoiceValid) {
                    throw new IllegalStateException("expected ui stage " + (Object)((Object)Stage.FirstChoiceValid) + " when button is " + (Object)((Object)RightButtonMode.Continue));
                }
                this.updateStage(Stage.NeedToConfirm);
                return;
            } else if (this.mUiStage.rightMode == RightButtonMode.Confirm) {
                if (this.mUiStage != Stage.ChoiceConfirmed) {
                    throw new IllegalStateException("expected ui stage " + (Object)((Object)Stage.ChoiceConfirmed) + " when button is " + (Object)((Object)RightButtonMode.Confirm));
                }
                this.saveChosenPatternAndFinish();
                return;
            } else {
                if (this.mUiStage.rightMode != RightButtonMode.Ok) return;
                if (this.mUiStage != Stage.HelpScreen) {
                    throw new IllegalStateException("Help screen is only mode with ok button, but stage is " + (Object)((Object)this.mUiStage));
                }
                this.mLockPatternView.clearPattern();
                this.mLockPatternView.setDisplayMode(LockPatternView.DisplayMode.Correct);
                this.updateStage(Stage.Introduction);
            }
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4 && event.getRepeatCount() == 0 && this.mUiStage == Stage.HelpScreen) {
            this.updateStage(Stage.Introduction);
            return true;
        }
        if (keyCode == 82 && this.mUiStage == Stage.Introduction) {
            this.updateStage(Stage.HelpScreen);
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(KEY_UI_STAGE, this.mUiStage.ordinal());
        if (this.mChosenPattern != null) {
            outState.putString(KEY_PATTERN_CHOICE, LockPatternUtils.patternToString(this.mChosenPattern));
        }
    }

    protected void updateStage(Stage stage) {
        this.mUiStage = stage;
        if (stage == Stage.ChoiceTooShort) {
            this.mHeaderText.setText((CharSequence)this.getResources().getString(stage.headerMessage, new Object[]{4}));
        } else {
            this.mHeaderText.setText(stage.headerMessage);
        }
        if (stage.footerMessage == -1) {
            this.mFooterText.setText((CharSequence)"");
        } else {
            this.mFooterText.setText(stage.footerMessage);
        }
        if (stage.leftMode == LeftButtonMode.Gone) {
            this.mFooterLeftButton.setVisibility(8);
        } else {
            this.mFooterLeftButton.setVisibility(0);
            this.mFooterLeftButton.setText(stage.leftMode.text);
            this.mFooterLeftButton.setEnabled(stage.leftMode.enabled);
        }
        this.mFooterRightButton.setText(stage.rightMode.text);
        this.mFooterRightButton.setEnabled(stage.rightMode.enabled);
        if (stage.patternEnabled) {
            this.mLockPatternView.enableInput();
        } else {
            this.mLockPatternView.disableInput();
        }
        this.mLockPatternView.setDisplayMode(LockPatternView.DisplayMode.Correct);
        switch (this.mUiStage) {
            case Introduction: {
                this.mLockPatternView.clearPattern();
                break;
            }
            case HelpScreen: {
                this.mLockPatternView.setPattern(LockPatternView.DisplayMode.Animate, this.mAnimatePattern);
                break;
            }
            case ChoiceTooShort: {
                this.mLockPatternView.setDisplayMode(LockPatternView.DisplayMode.Wrong);
                this.postClearPatternRunnable();
                break;
            }
            case FirstChoiceValid: {
                break;
            }
            case NeedToConfirm: {
                this.mLockPatternView.clearPattern();
                break;
            }
            case ConfirmWrong: {
                this.mLockPatternView.setDisplayMode(LockPatternView.DisplayMode.Wrong);
                this.postClearPatternRunnable();
                break;
            }
        }
    }

    private void postClearPatternRunnable() {
        this.mLockPatternView.removeCallbacks(this.mClearPatternRunnable);
        this.mLockPatternView.postDelayed(this.mClearPatternRunnable, 2000L);
    }

    private void saveChosenPatternAndFinish() {
        LockPatternUtils utils = this.mChooseLockSettingsHelper.utils();
        boolean lockVirgin = !utils.isPatternEverChosen();
        utils.saveLockPattern(this.mChosenPattern);
        utils.setLockPatternEnabled(true);
        if (lockVirgin) {
            utils.setVisiblePatternEnabled(true);
            utils.setTactileFeedbackEnabled(false);
        }
        this.setResult(1);
        this.finish();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Stage {
        Introduction(2131231409, LeftButtonMode.Cancel, RightButtonMode.ContinueDisabled, 2131231410, true),
        HelpScreen(2131231427, LeftButtonMode.Gone, RightButtonMode.Ok, -1, false),
        ChoiceTooShort(2131231412, LeftButtonMode.Retry, RightButtonMode.ContinueDisabled, -1, true),
        FirstChoiceValid(2131231413, LeftButtonMode.Retry, RightButtonMode.Continue, -1, false),
        NeedToConfirm(2131231414, LeftButtonMode.CancelDisabled, RightButtonMode.ConfirmDisabled, -1, true),
        ConfirmWrong(2131231407, LeftButtonMode.Cancel, RightButtonMode.ConfirmDisabled, -1, true),
        ChoiceConfirmed(2131231415, LeftButtonMode.Cancel, RightButtonMode.Confirm, -1, false);

        final int headerMessage;
        final LeftButtonMode leftMode;
        final RightButtonMode rightMode;
        final int footerMessage;
        final boolean patternEnabled;

        private Stage(int headerMessage, LeftButtonMode leftMode, RightButtonMode rightMode, int footerMessage, boolean patternEnabled) {
            this.headerMessage = headerMessage;
            this.leftMode = leftMode;
            this.rightMode = rightMode;
            this.footerMessage = footerMessage;
            this.patternEnabled = patternEnabled;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RightButtonMode {
        Continue(2131231419, true),
        ContinueDisabled(2131231419, false),
        Confirm(2131231416, true),
        ConfirmDisabled(2131231416, false),
        Ok(17039370, true);

        final int text;
        final boolean enabled;

        private RightButtonMode(int text, boolean enabled) {
            this.text = text;
            this.enabled = enabled;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum LeftButtonMode {
        Cancel(2131230919, true),
        CancelDisabled(2131230919, false),
        Retry(2131231418, true),
        RetryDisabled(2131231418, false),
        Gone(-1, false);

        final int text;
        final boolean enabled;

        private LeftButtonMode(int text, boolean enabled) {
            this.text = text;
            this.enabled = enabled;
        }
    }
}

