/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.inputmethodservice.KeyboardView;
import android.os.Bundle;
import android.os.Handler;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.android.internal.widget.LockPatternUtils;
import com.android.internal.widget.PasswordEntryKeyboardHelper;
import com.android.internal.widget.PasswordEntryKeyboardView;
import com.android.settings.ChooseLockSettingsHelper;

public class ChooseLockPassword
extends Activity
implements View.OnClickListener,
TextView.OnEditorActionListener,
TextWatcher {
    private static final String KEY_FIRST_PIN = "first_pin";
    private static final String KEY_UI_STAGE = "ui_stage";
    private TextView mPasswordEntry;
    private int mPasswordMinLength = 4;
    private int mPasswordMaxLength = 16;
    private LockPatternUtils mLockPatternUtils;
    private int mRequestedQuality = 131072;
    private ChooseLockSettingsHelper mChooseLockSettingsHelper;
    private Stage mUiStage = Stage.Introduction;
    private TextView mHeaderText;
    private String mFirstPin;
    private KeyboardView mKeyboardView;
    private PasswordEntryKeyboardHelper mKeyboardHelper;
    private boolean mIsAlphaMode;
    private Button mCancelButton;
    private Button mNextButton;
    public static final String PASSWORD_MIN_KEY = "lockscreen.password_min";
    public static final String PASSWORD_MAX_KEY = "lockscreen.password_max";
    private static Handler mHandler = new Handler();
    private static final int CONFIRM_EXISTING_REQUEST = 58;
    static final int RESULT_FINISHED = 1;
    private static final long ERROR_MESSAGE_TIMEOUT = 3000L;

    protected void onCreate(Bundle savedInstanceState) {
        int minLength;
        super.onCreate(savedInstanceState);
        this.mLockPatternUtils = new LockPatternUtils((Context)this);
        this.mRequestedQuality = this.getIntent().getIntExtra("lockscreen.password_type", this.mRequestedQuality);
        this.mPasswordMinLength = this.getIntent().getIntExtra(PASSWORD_MIN_KEY, this.mPasswordMinLength);
        this.mPasswordMaxLength = this.getIntent().getIntExtra(PASSWORD_MAX_KEY, this.mPasswordMaxLength);
        boolean confirmCredentials = this.getIntent().getBooleanExtra("confirm_credentials", true);
        int minMode = this.mLockPatternUtils.getRequestedPasswordQuality();
        if (this.mRequestedQuality < minMode) {
            this.mRequestedQuality = minMode;
        }
        if (this.mPasswordMinLength < (minLength = this.mLockPatternUtils.getRequestedMinimumPasswordLength())) {
            this.mPasswordMinLength = minLength;
        }
        this.initViews();
        this.mChooseLockSettingsHelper = new ChooseLockSettingsHelper(this);
        if (savedInstanceState == null) {
            this.updateStage(Stage.Introduction);
            if (confirmCredentials) {
                this.mChooseLockSettingsHelper.launchConfirmationActivity(58, null, null);
            }
        }
    }

    private void initViews() {
        this.setContentView(2130903049);
        this.getWindow().setFlags(131072, 131072);
        this.mCancelButton = (Button)this.findViewById(2131427355);
        this.mCancelButton.setOnClickListener((View.OnClickListener)this);
        this.mNextButton = (Button)this.findViewById(2131427356);
        this.mNextButton.setOnClickListener((View.OnClickListener)this);
        this.mKeyboardView = (PasswordEntryKeyboardView)this.findViewById(2131427354);
        this.mPasswordEntry = (TextView)this.findViewById(2131427353);
        this.mPasswordEntry.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        this.mPasswordEntry.addTextChangedListener((TextWatcher)this);
        this.mIsAlphaMode = 262144 == this.mRequestedQuality || 327680 == this.mRequestedQuality;
        this.mKeyboardHelper = new PasswordEntryKeyboardHelper((Context)this, this.mKeyboardView, (View)this.mPasswordEntry);
        this.mKeyboardHelper.setKeyboardMode(this.mIsAlphaMode ? 0 : 1);
        this.mHeaderText = (TextView)this.findViewById(2131427351);
        this.mKeyboardView.requestFocus();
    }

    protected void onResume() {
        super.onResume();
        this.updateStage(this.mUiStage);
        this.mKeyboardView.requestFocus();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString(KEY_UI_STAGE, this.mUiStage.name());
        outState.putString(KEY_FIRST_PIN, this.mFirstPin);
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        String state = savedInstanceState.getString(KEY_UI_STAGE);
        this.mFirstPin = savedInstanceState.getString(KEY_FIRST_PIN);
        if (state != null) {
            this.mUiStage = Stage.valueOf(state);
            this.updateStage(this.mUiStage);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 58: {
                if (resultCode == -1) break;
                this.setResult(1);
                this.finish();
            }
        }
    }

    protected void updateStage(Stage stage) {
        this.mUiStage = stage;
        this.updateUi();
    }

    private String validatePassword(String password) {
        if (password.length() < this.mPasswordMinLength) {
            return this.getString(this.mIsAlphaMode ? 2131230977 : 2131230978, new Object[]{this.mPasswordMinLength});
        }
        if (password.length() > this.mPasswordMaxLength) {
            return this.getString(this.mIsAlphaMode ? 2131230981 : 2131230982, new Object[]{this.mPasswordMaxLength});
        }
        boolean hasAlpha = false;
        boolean hasDigit = false;
        boolean hasSymbol = false;
        for (int i = 0; i < password.length(); ++i) {
            char c = password.charAt(i);
            if (c <= ' ' || c > '\u007f') {
                return this.getString(2131230984);
            }
            if (c >= '0' && c <= '9') {
                hasDigit = true;
                continue;
            }
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                hasAlpha = true;
                continue;
            }
            hasSymbol = true;
        }
        if (131072 == this.mRequestedQuality && hasAlpha | hasSymbol) {
            return this.getString(2131230983);
        }
        boolean alphabetic = 262144 == this.mRequestedQuality;
        boolean alphanumeric = 327680 == this.mRequestedQuality;
        boolean symbolic = false;
        if ((alphabetic || alphanumeric) && !hasAlpha) {
            return this.getString(2131230985);
        }
        if (alphanumeric && !hasDigit) {
            return this.getString(2131230986);
        }
        return null;
    }

    private void handleNext() {
        String pin = ((Object)this.mPasswordEntry.getText()).toString();
        if (TextUtils.isEmpty((CharSequence)pin)) {
            return;
        }
        String errorMsg = null;
        if (this.mUiStage == Stage.Introduction) {
            errorMsg = this.validatePassword(pin);
            if (errorMsg == null) {
                this.mFirstPin = pin;
                this.updateStage(Stage.NeedToConfirm);
                this.mPasswordEntry.setText((CharSequence)"");
            }
        } else if (this.mUiStage == Stage.NeedToConfirm) {
            if (this.mFirstPin.equals(pin)) {
                this.mLockPatternUtils.clearLock();
                this.mLockPatternUtils.saveLockPassword(pin, this.mRequestedQuality);
                this.finish();
            } else {
                this.updateStage(Stage.ConfirmWrong);
                CharSequence tmp = this.mPasswordEntry.getText();
                if (tmp != null) {
                    Selection.setSelection((Spannable)((Spannable)tmp), (int)0, (int)tmp.length());
                }
            }
        }
        if (errorMsg != null) {
            this.showError(errorMsg, this.mUiStage);
        }
    }

    public void onClick(View v) {
        switch (v.getId()) {
            case 2131427356: {
                this.handleNext();
                break;
            }
            case 2131427355: {
                this.finish();
            }
        }
    }

    private void showError(String msg, final Stage next) {
        this.mHeaderText.setText((CharSequence)msg);
        mHandler.postDelayed(new Runnable(){

            public void run() {
                ChooseLockPassword.this.updateStage(next);
            }
        }, 3000L);
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        if (actionId == 0) {
            this.handleNext();
            return true;
        }
        return false;
    }

    private void updateUi() {
        String password = ((Object)this.mPasswordEntry.getText()).toString();
        int length = password.length();
        if (this.mUiStage == Stage.Introduction && length > 0) {
            if (length < this.mPasswordMinLength) {
                String msg = this.getString(this.mIsAlphaMode ? 2131230977 : 2131230978, new Object[]{this.mPasswordMinLength});
                this.mHeaderText.setText((CharSequence)msg);
                this.mNextButton.setEnabled(false);
            } else {
                String error = this.validatePassword(password);
                if (error != null) {
                    this.mHeaderText.setText((CharSequence)error);
                    this.mNextButton.setEnabled(false);
                } else {
                    this.mHeaderText.setText(2131230979);
                    this.mNextButton.setEnabled(true);
                }
            }
        } else {
            this.mHeaderText.setText(this.mIsAlphaMode ? this.mUiStage.alphaHint : this.mUiStage.numericHint);
            this.mNextButton.setEnabled(length > 0);
        }
        this.mNextButton.setText(this.mUiStage.buttonText);
    }

    public void afterTextChanged(Editable s) {
        if (this.mUiStage == Stage.ConfirmWrong) {
            this.mUiStage = Stage.NeedToConfirm;
        }
        this.updateUi();
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Stage {
        Introduction(2131231393, 2131231394, 2131230980),
        NeedToConfirm(2131231395, 2131231396, 2131230988),
        ConfirmWrong(2131231397, 2131231398, 2131230980);

        public final int alphaHint;
        public final int numericHint;
        public final int buttonText;

        private Stage(int hintInAlpha, int hintInNumeric, int nextButtonText) {
            this.alphaHint = hintInAlpha;
            this.numericHint = hintInNumeric;
            this.buttonText = nextButtonText;
        }
    }
}

