/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.app.Activity;
import android.app.admin.DevicePolicyManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceCategory;
import android.preference.PreferenceScreen;
import com.android.settings.ChooseLockPassword;
import com.android.settings.ChooseLockPattern;
import com.android.settings.ChooseLockPatternTutorial;
import com.android.settings.ChooseLockSettingsHelper;

public class ChooseLockGeneric
extends PreferenceActivity {
    private static final int MIN_PASSWORD_LENGTH = 4;
    private static final String KEY_UNLOCK_SET_NONE = "unlock_set_none";
    private static final String KEY_UNLOCK_SET_PIN = "unlock_set_pin";
    private static final String KEY_UNLOCK_SET_PASSWORD = "unlock_set_password";
    private static final String KEY_UNLOCK_SET_PATTERN = "unlock_set_pattern";
    private static final int CONFIRM_EXISTING_REQUEST = 100;
    private static final String PASSWORD_CONFIRMED = "password_confirmed";
    private static final String CONFIRM_CREDENTIALS = "confirm_credentials";
    private ChooseLockSettingsHelper mChooseLockSettingsHelper;
    private DevicePolicyManager mDPM;
    private boolean mPasswordConfirmed = false;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mDPM = (DevicePolicyManager)this.getSystemService("device_policy");
        this.mChooseLockSettingsHelper = new ChooseLockSettingsHelper((Activity)this);
        if (savedInstanceState != null) {
            this.mPasswordConfirmed = savedInstanceState.getBoolean(PASSWORD_CONFIRMED);
        }
        if (!this.mPasswordConfirmed) {
            ChooseLockSettingsHelper helper = new ChooseLockSettingsHelper((Activity)this);
            if (!helper.launchConfirmationActivity(100, null, null)) {
                this.mPasswordConfirmed = true;
                this.updatePreferencesOrFinish();
            }
        } else {
            this.updatePreferencesOrFinish();
        }
    }

    public boolean onPreferenceTreeClick(PreferenceScreen preferenceScreen, Preference preference) {
        String key = preference.getKey();
        boolean handled = true;
        if (KEY_UNLOCK_SET_NONE.equals(key)) {
            this.updateUnlockMethodAndFinish(0);
        } else if (KEY_UNLOCK_SET_PATTERN.equals(key)) {
            this.updateUnlockMethodAndFinish(65536);
        } else if (KEY_UNLOCK_SET_PIN.equals(key)) {
            this.updateUnlockMethodAndFinish(131072);
        } else if (KEY_UNLOCK_SET_PASSWORD.equals(key)) {
            this.updateUnlockMethodAndFinish(262144);
        } else {
            handled = false;
        }
        return handled;
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 100 && resultCode == -1) {
            this.mPasswordConfirmed = true;
            this.updatePreferencesOrFinish();
        } else {
            this.setResult(0);
            this.finish();
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean(PASSWORD_CONFIRMED, this.mPasswordConfirmed);
    }

    private void updatePreferencesOrFinish() {
        int quality = this.getIntent().getIntExtra("lockscreen.password_type", -1);
        if (quality == -1) {
            quality = this.mChooseLockSettingsHelper.utils().getKeyguardStoredPasswordQuality();
            PreferenceScreen prefScreen = this.getPreferenceScreen();
            if (prefScreen != null) {
                prefScreen.removeAll();
            }
            this.addPreferencesFromResource(2130968601);
            this.disableUnusablePreferences(this.mDPM.getPasswordQuality(null));
        } else {
            this.updateUnlockMethodAndFinish(quality);
        }
    }

    private void disableUnusablePreferences(int quality) {
        Preference picker = this.getPreferenceScreen().findPreference((CharSequence)"security_picker_category");
        PreferenceCategory cat = (PreferenceCategory)picker;
        int preferenceCount = cat.getPreferenceCount();
        for (int i = 0; i < preferenceCount; ++i) {
            Preference pref = cat.getPreference(i);
            if (!(pref instanceof PreferenceScreen)) continue;
            String key = ((PreferenceScreen)pref).getKey();
            boolean enabled = true;
            if (KEY_UNLOCK_SET_NONE.equals(key)) {
                enabled = quality <= 0;
            } else if (KEY_UNLOCK_SET_PATTERN.equals(key)) {
                enabled = quality <= 65536;
            } else if (KEY_UNLOCK_SET_PIN.equals(key)) {
                enabled = quality <= 131072;
            } else if (KEY_UNLOCK_SET_PASSWORD.equals(key)) {
                boolean bl = enabled = quality <= 327680;
            }
            if (enabled) continue;
            pref.setSummary(2131230969);
            pref.setEnabled(false);
        }
    }

    void updateUnlockMethodAndFinish(int quality) {
        if (!this.mPasswordConfirmed) {
            throw new IllegalStateException("Tried to update password without confirming first");
        }
        int minQuality = this.mDPM.getPasswordQuality(null);
        if (quality < minQuality) {
            quality = minQuality;
        }
        if (quality >= 131072) {
            int minLength = this.mDPM.getPasswordMinimumLength(null);
            if (minLength < 4) {
                minLength = 4;
            }
            int maxLength = this.mDPM.getPasswordMaximumLength(quality);
            Intent intent = new Intent().setClass((Context)this, ChooseLockPassword.class);
            intent.putExtra("lockscreen.password_type", quality);
            intent.putExtra("lockscreen.password_min", minLength);
            intent.putExtra("lockscreen.password_max", maxLength);
            intent.putExtra(CONFIRM_CREDENTIALS, false);
            intent.addFlags(0x2000000);
            this.startActivity(intent);
        } else if (quality == 65536) {
            boolean showTutorial = !this.mChooseLockSettingsHelper.utils().isPatternEverChosen();
            Intent intent = new Intent();
            intent.setClass((Context)this, showTutorial ? ChooseLockPatternTutorial.class : ChooseLockPattern.class);
            intent.addFlags(0x2000000);
            intent.putExtra("key_lock_method", "pattern");
            intent.putExtra(CONFIRM_CREDENTIALS, false);
            this.startActivity(intent);
        } else if (quality == 0) {
            this.mChooseLockSettingsHelper.utils().clearLock();
            this.setResult(-1);
        }
        this.finish();
    }
}

