/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.content.ContentResolver;
import android.content.Context;
import android.os.IBinder;
import android.os.IPowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.preference.SeekBarPreference;
import android.provider.Settings;
import android.util.AttributeSet;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.SeekBar;

public class BrightnessPreference
extends SeekBarPreference
implements SeekBar.OnSeekBarChangeListener,
CompoundButton.OnCheckedChangeListener {
    private SeekBar mSeekBar;
    private CheckBox mCheckBox;
    private int mOldBrightness;
    private int mOldAutomatic;
    private boolean mAutomaticAvailable;
    private static final int MINIMUM_BACKLIGHT = 30;
    private static final int MAXIMUM_BACKLIGHT = 255;

    public BrightnessPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mAutomaticAvailable = context.getResources().getBoolean(17629189);
        this.setDialogLayoutResource(2130903082);
        this.setDialogIcon(2130837563);
    }

    protected void onBindDialogView(View view) {
        super.onBindDialogView(view);
        this.mSeekBar = BrightnessPreference.getSeekBar((View)view);
        this.mSeekBar.setMax(225);
        try {
            this.mOldBrightness = Settings.System.getInt((ContentResolver)this.getContext().getContentResolver(), (String)"screen_brightness");
        }
        catch (Settings.SettingNotFoundException snfe) {
            this.mOldBrightness = 255;
        }
        this.mSeekBar.setProgress(this.mOldBrightness - 30);
        this.mCheckBox = (CheckBox)view.findViewById(2131427446);
        if (this.mAutomaticAvailable) {
            this.mCheckBox.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
            try {
                this.mOldAutomatic = Settings.System.getInt((ContentResolver)this.getContext().getContentResolver(), (String)"screen_brightness_mode");
            }
            catch (Settings.SettingNotFoundException snfe) {
                this.mOldAutomatic = 0;
            }
            this.mCheckBox.setChecked(this.mOldAutomatic != 0);
        } else {
            this.mCheckBox.setVisibility(8);
        }
        this.mSeekBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromTouch) {
        this.setBrightness(progress + 30);
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
    }

    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        this.setMode(isChecked ? 1 : 0);
        if (!isChecked) {
            this.setBrightness(this.mSeekBar.getProgress() + 30);
        }
    }

    protected void onDialogClosed(boolean positiveResult) {
        super.onDialogClosed(positiveResult);
        if (positiveResult) {
            Settings.System.putInt((ContentResolver)this.getContext().getContentResolver(), (String)"screen_brightness", (int)(this.mSeekBar.getProgress() + 30));
        } else {
            if (this.mAutomaticAvailable) {
                this.setMode(this.mOldAutomatic);
            }
            if (!this.mAutomaticAvailable || this.mOldAutomatic == 0) {
                this.setBrightness(this.mOldBrightness);
            }
        }
    }

    private void setBrightness(int brightness) {
        try {
            IPowerManager power = IPowerManager.Stub.asInterface((IBinder)ServiceManager.getService((String)"power"));
            if (power != null) {
                power.setBacklightBrightness(brightness);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void setMode(int mode) {
        if (mode == 1) {
            this.mSeekBar.setVisibility(8);
        } else {
            this.mSeekBar.setVisibility(0);
        }
        Settings.System.putInt((ContentResolver)this.getContext().getContentResolver(), (String)"screen_brightness_mode", (int)mode);
    }
}

