/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IPowerManager;
import android.os.Message;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.text.format.DateUtils;
import android.widget.TextView;
import com.android.internal.app.IBatteryStats;

public class BatteryInfo
extends Activity {
    private TextView mStatus;
    private TextView mPower;
    private TextView mLevel;
    private TextView mScale;
    private TextView mHealth;
    private TextView mVoltage;
    private TextView mTemperature;
    private TextView mTechnology;
    private TextView mUptime;
    private IBatteryStats mBatteryStats;
    private IPowerManager mScreenStats;
    private static final int EVENT_TICK = 1;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    BatteryInfo.this.updateBatteryStats();
                    this.sendEmptyMessageDelayed(1, 1000L);
                }
            }
        }
    };
    private IntentFilter mIntentFilter;
    private BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.intent.action.BATTERY_CHANGED")) {
                String statusString;
                int plugType = intent.getIntExtra("plugged", 0);
                BatteryInfo.this.mLevel.setText((CharSequence)("" + intent.getIntExtra("level", 0)));
                BatteryInfo.this.mScale.setText((CharSequence)("" + intent.getIntExtra("scale", 0)));
                BatteryInfo.this.mVoltage.setText((CharSequence)("" + intent.getIntExtra("voltage", 0) + " " + BatteryInfo.this.getString(2131230766)));
                BatteryInfo.this.mTemperature.setText((CharSequence)("" + BatteryInfo.this.tenthsToFixedString(intent.getIntExtra("temperature", 0)) + BatteryInfo.this.getString(2131230768)));
                BatteryInfo.this.mTechnology.setText((CharSequence)("" + intent.getStringExtra("technology")));
                int status = intent.getIntExtra("status", 1);
                if (status == 2) {
                    statusString = BatteryInfo.this.getString(2131230774);
                    if (plugType > 0) {
                        statusString = statusString + " " + BatteryInfo.this.getString(plugType == 1 ? 2131230775 : 2131230776);
                    }
                } else {
                    statusString = status == 3 ? BatteryInfo.this.getString(2131230777) : (status == 4 ? BatteryInfo.this.getString(2131230778) : (status == 5 ? BatteryInfo.this.getString(2131230779) : BatteryInfo.this.getString(2131230773)));
                }
                BatteryInfo.this.mStatus.setText((CharSequence)statusString);
                switch (plugType) {
                    case 0: {
                        BatteryInfo.this.mPower.setText((CharSequence)BatteryInfo.this.getString(2131230780));
                        break;
                    }
                    case 1: {
                        BatteryInfo.this.mPower.setText((CharSequence)BatteryInfo.this.getString(2131230781));
                        break;
                    }
                    case 2: {
                        BatteryInfo.this.mPower.setText((CharSequence)BatteryInfo.this.getString(2131230782));
                        break;
                    }
                    case 3: {
                        BatteryInfo.this.mPower.setText((CharSequence)BatteryInfo.this.getString(2131230783));
                        break;
                    }
                    default: {
                        BatteryInfo.this.mPower.setText((CharSequence)BatteryInfo.this.getString(2131230784));
                    }
                }
                int health = intent.getIntExtra("health", 1);
                String healthString = health == 2 ? BatteryInfo.this.getString(2131230786) : (health == 3 ? BatteryInfo.this.getString(2131230787) : (health == 4 ? BatteryInfo.this.getString(2131230788) : (health == 5 ? BatteryInfo.this.getString(2131230789) : (health == 6 ? BatteryInfo.this.getString(2131230790) : BatteryInfo.this.getString(2131230785)))));
                BatteryInfo.this.mHealth.setText((CharSequence)healthString);
            }
        }
    };

    private final String tenthsToFixedString(int x) {
        int tens = x / 10;
        return Integer.toString(tens) + "." + (x - 10 * tens);
    }

    public void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.setContentView(2130903042);
        this.mIntentFilter = new IntentFilter();
        this.mIntentFilter.addAction("android.intent.action.BATTERY_CHANGED");
    }

    public void onResume() {
        super.onResume();
        this.mStatus = (TextView)this.findViewById(2131427329);
        this.mPower = (TextView)this.findViewById(2131427330);
        this.mLevel = (TextView)this.findViewById(2131427331);
        this.mScale = (TextView)this.findViewById(2131427332);
        this.mHealth = (TextView)this.findViewById(2131427333);
        this.mTechnology = (TextView)this.findViewById(2131427336);
        this.mVoltage = (TextView)this.findViewById(2131427334);
        this.mTemperature = (TextView)this.findViewById(2131427335);
        this.mUptime = (TextView)this.findViewById(2131427337);
        this.mBatteryStats = IBatteryStats.Stub.asInterface((IBinder)ServiceManager.getService((String)"batteryinfo"));
        this.mScreenStats = IPowerManager.Stub.asInterface((IBinder)ServiceManager.getService((String)"power"));
        this.mHandler.sendEmptyMessageDelayed(1, 1000L);
        this.registerReceiver(this.mIntentReceiver, this.mIntentFilter);
    }

    public void onPause() {
        super.onPause();
        this.mHandler.removeMessages(1);
        this.unregisterReceiver(this.mIntentReceiver);
    }

    private void updateBatteryStats() {
        long uptime = SystemClock.elapsedRealtime();
        this.mUptime.setText((CharSequence)DateUtils.formatElapsedTime((long)(uptime / 1000L)));
    }
}

