/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.AsyncResult;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneFactory;

public class BandMode
extends Activity {
    private static final String LOG_TAG = "phone";
    private static final boolean DBG = false;
    private static final int EVENT_BAND_SCAN_COMPLETED = 100;
    private static final int EVENT_BAND_SELECTION_DONE = 200;
    private static final String[] BAND_NAMES = new String[]{"Automatic", "EURO Band", "USA Band", "JAPAN Band", "AUS Band", "AUS2 Band"};
    private ListView mBandList;
    private ArrayAdapter mBandListAdapter;
    private BandListItem mTargetBand = null;
    private DialogInterface mProgressPanel;
    private Phone mPhone = null;
    private AdapterView.OnItemClickListener mBandSelectionHandler = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView parent, View v, int position, long id2) {
            BandMode.this.getWindow().setFeatureInt(5, -1);
            BandMode.this.mTargetBand = (BandListItem)parent.getAdapter().getItem(position);
            Message msg = BandMode.this.mHandler.obtainMessage(200);
            BandMode.this.mPhone.setBandMode(BandMode.this.mTargetBand.getBand(), msg);
        }
    };
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 100: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    BandMode.this.bandListLoaded(ar);
                    break;
                }
                case 200: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    BandMode.this.getWindow().setFeatureInt(5, -2);
                    BandMode.this.displayBandSelectionResult(ar.exception);
                }
            }
        }
    };

    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.requestWindowFeature(5);
        this.setContentView(2130903041);
        this.setTitle(this.getString(2131230892));
        this.getWindow().setLayout(-1, -2);
        this.mPhone = PhoneFactory.getDefaultPhone();
        this.mBandList = (ListView)this.findViewById(2131427328);
        this.mBandListAdapter = new ArrayAdapter((Context)this, 17367043);
        this.mBandList.setAdapter((ListAdapter)this.mBandListAdapter);
        this.mBandList.setOnItemClickListener(this.mBandSelectionHandler);
        this.loadBandList();
    }

    private void loadBandList() {
        String str = this.getString(2131230893);
        this.mProgressPanel = new AlertDialog.Builder((Context)this).setMessage((CharSequence)str).show();
        Message msg = this.mHandler.obtainMessage(100);
        this.mPhone.queryAvailableBandMode(msg);
    }

    private void bandListLoaded(AsyncResult result) {
        BandListItem item;
        int[] bands;
        int size;
        if (this.mProgressPanel != null) {
            this.mProgressPanel.dismiss();
        }
        this.clearList();
        boolean addBandSuccess = false;
        if (result.result != null && (size = (bands = (int[])result.result)[0]) > 0) {
            for (int i = 1; i < size; ++i) {
                item = new BandListItem(bands[i]);
                this.mBandListAdapter.add((Object)item);
            }
            addBandSuccess = true;
        }
        if (!addBandSuccess) {
            for (int i = 0; i < 6; ++i) {
                item = new BandListItem(i);
                this.mBandListAdapter.add((Object)item);
            }
        }
        this.mBandList.requestFocus();
    }

    private void displayBandSelectionResult(Throwable ex) {
        String status = this.getString(2131230894) + " [" + this.mTargetBand.toString() + "] ";
        status = ex != null ? status + this.getString(2131230895) : status + this.getString(2131230896);
        this.mProgressPanel = new AlertDialog.Builder((Context)this).setMessage((CharSequence)status).setPositiveButton(17039370, null).show();
    }

    private void clearList() {
        while (this.mBandListAdapter.getCount() > 0) {
            this.mBandListAdapter.remove(this.mBandListAdapter.getItem(0));
        }
    }

    private void log(String msg) {
        Log.d((String)LOG_TAG, (String)("[BandsList] " + msg));
    }

    private static class BandListItem {
        private int mBandMode = 0;

        public BandListItem(int bm) {
            this.mBandMode = bm;
        }

        public int getBand() {
            return this.mBandMode;
        }

        public String toString() {
            return BAND_NAMES[this.mBandMode];
        }
    }
}

