/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.app.AlertDialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.preference.CheckBoxPreference;
import android.preference.ListPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceScreen;
import android.provider.Settings;

public class ApplicationSettings
extends PreferenceActivity
implements DialogInterface.OnClickListener {
    private static final String KEY_TOGGLE_INSTALL_APPLICATIONS = "toggle_install_applications";
    private static final String KEY_APP_INSTALL_LOCATION = "app_install_location";
    private static final String KEY_QUICK_LAUNCH = "quick_launch";
    private static final int APP_INSTALL_AUTO = 0;
    private static final int APP_INSTALL_DEVICE = 1;
    private static final int APP_INSTALL_SDCARD = 2;
    private static final String APP_INSTALL_DEVICE_ID = "device";
    private static final String APP_INSTALL_SDCARD_ID = "sdcard";
    private static final String APP_INSTALL_AUTO_ID = "auto";
    private CheckBoxPreference mToggleAppInstallation;
    private ListPreference mInstallLocation;
    private DialogInterface mWarnInstallApps;

    protected void onCreate(Bundle icicle) {
        boolean userSetInstLocation;
        super.onCreate(icicle);
        this.addPreferencesFromResource(2130968579);
        this.mToggleAppInstallation = (CheckBoxPreference)this.findPreference(KEY_TOGGLE_INSTALL_APPLICATIONS);
        this.mToggleAppInstallation.setChecked(this.isNonMarketAppsAllowed());
        this.mInstallLocation = (ListPreference)this.findPreference(KEY_APP_INSTALL_LOCATION);
        boolean bl = userSetInstLocation = Settings.System.getInt((ContentResolver)this.getContentResolver(), (String)"set_install_location", (int)0) != 0;
        if (!userSetInstLocation) {
            this.getPreferenceScreen().removePreference((Preference)this.mInstallLocation);
        } else {
            this.mInstallLocation.setValue(this.getAppInstallLocation());
            this.mInstallLocation.setOnPreferenceChangeListener(new Preference.OnPreferenceChangeListener(){

                public boolean onPreferenceChange(Preference preference, Object newValue) {
                    String value = (String)newValue;
                    ApplicationSettings.this.handleUpdateAppInstallLocation(value);
                    return false;
                }
            });
        }
        if (this.getResources().getConfiguration().keyboard == 1) {
            Preference quickLaunchSetting = this.findPreference(KEY_QUICK_LAUNCH);
            this.getPreferenceScreen().removePreference(quickLaunchSetting);
        }
    }

    protected void handleUpdateAppInstallLocation(String value) {
        if (APP_INSTALL_DEVICE_ID.equals(value)) {
            Settings.System.putInt((ContentResolver)this.getContentResolver(), (String)"default_install_location", (int)1);
        } else if (APP_INSTALL_SDCARD_ID.equals(value)) {
            Settings.System.putInt((ContentResolver)this.getContentResolver(), (String)"default_install_location", (int)2);
        } else if (APP_INSTALL_AUTO_ID.equals(value)) {
            Settings.System.putInt((ContentResolver)this.getContentResolver(), (String)"default_install_location", (int)0);
        } else {
            Settings.System.putInt((ContentResolver)this.getContentResolver(), (String)"default_install_location", (int)0);
        }
        this.mInstallLocation.setValue(value);
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mWarnInstallApps != null) {
            this.mWarnInstallApps.dismiss();
        }
    }

    public boolean onPreferenceTreeClick(PreferenceScreen preferenceScreen, Preference preference) {
        if (preference == this.mToggleAppInstallation) {
            if (this.mToggleAppInstallation.isChecked()) {
                this.mToggleAppInstallation.setChecked(false);
                this.warnAppInstallation();
            } else {
                this.setNonMarketAppsAllowed(false);
            }
        }
        return super.onPreferenceTreeClick(preferenceScreen, preference);
    }

    public void onClick(DialogInterface dialog, int which) {
        if (dialog == this.mWarnInstallApps && which == -1) {
            this.setNonMarketAppsAllowed(true);
            this.mToggleAppInstallation.setChecked(true);
        }
    }

    private void setNonMarketAppsAllowed(boolean enabled) {
        Settings.Secure.putInt((ContentResolver)this.getContentResolver(), (String)"install_non_market_apps", (int)(enabled ? 1 : 0));
    }

    private boolean isNonMarketAppsAllowed() {
        return Settings.Secure.getInt((ContentResolver)this.getContentResolver(), (String)"install_non_market_apps", (int)0) > 0;
    }

    private String getAppInstallLocation() {
        int selectedLocation = Settings.System.getInt((ContentResolver)this.getContentResolver(), (String)"default_install_location", (int)0);
        if (selectedLocation == 1) {
            return APP_INSTALL_DEVICE_ID;
        }
        if (selectedLocation == 2) {
            return APP_INSTALL_SDCARD_ID;
        }
        if (selectedLocation == 0) {
            return APP_INSTALL_AUTO_ID;
        }
        return APP_INSTALL_AUTO_ID;
    }

    private void warnAppInstallation() {
        this.mWarnInstallApps = new AlertDialog.Builder((Context)this).setTitle((CharSequence)this.getString(2131231322)).setIcon(17301543).setMessage((CharSequence)this.getResources().getString(2131231443)).setPositiveButton(17039379, (DialogInterface.OnClickListener)this).setNegativeButton(17039369, null).show();
    }
}

