/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.appwidget.AppWidgetManager;
import android.appwidget.AppWidgetProviderInfo;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import com.android.settings.ActivityPicker;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppWidgetPickActivity
extends ActivityPicker {
    private static final String TAG = "AppWidgetPickActivity";
    private static final boolean LOGD = false;
    private PackageManager mPackageManager;
    private AppWidgetManager mAppWidgetManager;
    private int mAppWidgetId;

    @Override
    public void onCreate(Bundle icicle) {
        this.mPackageManager = this.getPackageManager();
        this.mAppWidgetManager = AppWidgetManager.getInstance((Context)this);
        super.onCreate(icicle);
        this.setResultData(0, null);
        Intent intent = this.getIntent();
        if (intent.hasExtra("appWidgetId")) {
            this.mAppWidgetId = intent.getIntExtra("appWidgetId", 0);
        } else {
            this.finish();
        }
    }

    void putCustomAppWidgets(List<ActivityPicker.PickAdapter.Item> items) {
        ArrayList customExtras;
        ArrayList customInfo;
        block8: {
            Bundle extras = this.getIntent().getExtras();
            customInfo = null;
            customExtras = null;
            customInfo = extras.getParcelableArrayList("customInfo");
            if (customInfo == null || customInfo.size() == 0) {
                Log.i((String)TAG, (String)"EXTRA_CUSTOM_INFO not present.");
            } else {
                int customInfoSize = customInfo.size();
                for (int i = 0; i < customInfoSize; ++i) {
                    Parcelable p = (Parcelable)customInfo.get(i);
                    if (p != null && p instanceof AppWidgetProviderInfo) continue;
                    customInfo = null;
                    Log.e((String)TAG, (String)("error using EXTRA_CUSTOM_INFO index=" + i));
                    break block8;
                }
                customExtras = extras.getParcelableArrayList("customExtras");
                if (customExtras == null) {
                    customInfo = null;
                    Log.e((String)TAG, (String)"EXTRA_CUSTOM_INFO without EXTRA_CUSTOM_EXTRAS");
                } else {
                    int customExtrasSize = customExtras.size();
                    if (customInfoSize != customExtrasSize) {
                        Log.e((String)TAG, (String)("list size mismatch: EXTRA_CUSTOM_INFO: " + customInfoSize + " EXTRA_CUSTOM_EXTRAS: " + customExtrasSize));
                    } else {
                        for (int i = 0; i < customExtrasSize; ++i) {
                            Parcelable p = (Parcelable)customExtras.get(i);
                            if (p != null && p instanceof Bundle) continue;
                            customInfo = null;
                            customExtras = null;
                            Log.e((String)TAG, (String)("error using EXTRA_CUSTOM_EXTRAS index=" + i));
                            break;
                        }
                    }
                }
            }
        }
        this.putAppWidgetItems(customInfo, customExtras, items);
    }

    @Override
    public void onClick(DialogInterface dialog, int which) {
        Intent intent = this.getIntentForPosition(which);
        if (intent.getExtras() != null) {
            this.setResultData(-1, intent);
        } else {
            int result;
            try {
                this.mAppWidgetManager.bindAppWidgetId(this.mAppWidgetId, intent.getComponent());
                result = -1;
            }
            catch (IllegalArgumentException e) {
                result = 0;
            }
            this.setResultData(result, null);
        }
        this.finish();
    }

    void putAppWidgetItems(List<AppWidgetProviderInfo> appWidgets, List<Bundle> customExtras, List<ActivityPicker.PickAdapter.Item> items) {
        if (appWidgets == null) {
            return;
        }
        int size = appWidgets.size();
        for (int i = 0; i < size; ++i) {
            AppWidgetProviderInfo info = appWidgets.get(i);
            String label = info.label;
            Drawable icon = null;
            if (info.icon != 0 && (icon = this.mPackageManager.getDrawable(info.provider.getPackageName(), info.icon, null)) == null) {
                Log.w((String)TAG, (String)("Can't load icon drawable 0x" + Integer.toHexString(info.icon) + " for provider: " + info.provider));
            }
            ActivityPicker.PickAdapter.Item item = new ActivityPicker.PickAdapter.Item((Context)this, label, icon);
            item.packageName = info.provider.getPackageName();
            item.className = info.provider.getClassName();
            if (customExtras != null) {
                item.extras = customExtras.get(i);
            }
            items.add(item);
        }
    }

    @Override
    protected List<ActivityPicker.PickAdapter.Item> getItems() {
        ArrayList<ActivityPicker.PickAdapter.Item> items = new ArrayList<ActivityPicker.PickAdapter.Item>();
        this.putInstalledAppWidgets(items);
        this.putCustomAppWidgets(items);
        Collections.sort(items, new Comparator<ActivityPicker.PickAdapter.Item>(){
            Collator mCollator = Collator.getInstance();

            @Override
            public int compare(ActivityPicker.PickAdapter.Item lhs, ActivityPicker.PickAdapter.Item rhs) {
                return this.mCollator.compare(lhs.label, rhs.label);
            }
        });
        return items;
    }

    void putInstalledAppWidgets(List<ActivityPicker.PickAdapter.Item> items) {
        List installed = this.mAppWidgetManager.getInstalledProviders();
        this.putAppWidgetItems(installed, null, items);
    }

    void setResultData(int code, Intent intent) {
        Intent result = intent != null ? intent : new Intent();
        result.putExtra("appWidgetId", this.mAppWidgetId);
        this.setResult(code, result);
    }
}

