/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.SystemProperties;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceGroup;
import android.preference.PreferenceScreen;
import android.provider.Telephony;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.Toast;
import com.android.internal.telephony.Phone;
import com.android.settings.ApnPreference;
import java.util.ArrayList;

public class ApnSettings
extends PreferenceActivity
implements Preference.OnPreferenceChangeListener {
    static final String TAG = "ApnSettings";
    public static final String EXTRA_POSITION = "position";
    public static final String RESTORE_CARRIERS_URI = "content://telephony/carriers/restore";
    public static final String PREFERRED_APN_URI = "content://telephony/carriers/preferapn";
    public static final String APN_ID = "apn_id";
    private static final int ID_INDEX = 0;
    private static final int NAME_INDEX = 1;
    private static final int APN_INDEX = 2;
    private static final int TYPES_INDEX = 3;
    private static final int MENU_NEW = 1;
    private static final int MENU_RESTORE = 2;
    private static final int EVENT_RESTORE_DEFAULTAPN_START = 1;
    private static final int EVENT_RESTORE_DEFAULTAPN_COMPLETE = 2;
    private static final int DIALOG_RESTORE_DEFAULTAPN = 1001;
    private static final Uri DEFAULTAPN_URI = Uri.parse((String)"content://telephony/carriers/restore");
    private static final Uri PREFERAPN_URI = Uri.parse((String)"content://telephony/carriers/preferapn");
    private static boolean mRestoreDefaultApnMode;
    private RestoreApnUiHandler mRestoreApnUiHandler;
    private RestoreApnProcessHandler mRestoreApnProcessHandler;
    private String mSelectedKey;
    private IntentFilter mMobileStateFilter;
    private final BroadcastReceiver mMobileStateReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.ANY_DATA_STATE")) {
                Phone.DataState state = ApnSettings.getMobileDataState(intent);
                switch (state) {
                    case CONNECTED: {
                        if (!mRestoreDefaultApnMode) {
                            ApnSettings.this.fillList();
                            break;
                        }
                        ApnSettings.this.showDialog(1001);
                    }
                }
            }
        }
    };

    private static Phone.DataState getMobileDataState(Intent intent) {
        String str = intent.getStringExtra("state");
        if (str != null) {
            return Enum.valueOf(Phone.DataState.class, str);
        }
        return Phone.DataState.DISCONNECTED;
    }

    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.addPreferencesFromResource(2130968578);
        this.getListView().setItemsCanFocus(true);
        this.mMobileStateFilter = new IntentFilter("android.intent.action.ANY_DATA_STATE");
    }

    protected void onResume() {
        super.onResume();
        this.registerReceiver(this.mMobileStateReceiver, this.mMobileStateFilter);
        if (!mRestoreDefaultApnMode) {
            this.fillList();
        } else {
            this.showDialog(1001);
        }
    }

    protected void onPause() {
        super.onPause();
        this.unregisterReceiver(this.mMobileStateReceiver);
    }

    private void fillList() {
        String where = "numeric=\"" + SystemProperties.get((String)"gsm.sim.operator.numeric", (String)"") + "\"";
        Cursor cursor = this.managedQuery(Telephony.Carriers.CONTENT_URI, new String[]{"_id", "name", "apn", "type"}, where, "name ASC");
        PreferenceGroup apnList = (PreferenceGroup)this.findPreference("apn_list");
        apnList.removeAll();
        ArrayList<ApnPreference> mmsApnList = new ArrayList<ApnPreference>();
        this.mSelectedKey = this.getSelectedApnKey();
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            String name = cursor.getString(1);
            String string2 = cursor.getString(2);
            String key = cursor.getString(0);
            String type = cursor.getString(3);
            ApnPreference pref = new ApnPreference((Context)this);
            pref.setKey(key);
            pref.setTitle(name);
            pref.setSummary(string2);
            pref.setPersistent(false);
            pref.setOnPreferenceChangeListener(this);
            boolean selectable = type == null || !type.equals("mms");
            pref.setSelectable(selectable);
            if (selectable) {
                if (this.mSelectedKey != null && this.mSelectedKey.equals(key)) {
                    pref.setChecked();
                }
                apnList.addPreference((Preference)pref);
            } else {
                mmsApnList.add(pref);
            }
            cursor.moveToNext();
        }
        cursor.close();
        for (Preference preference : mmsApnList) {
            apnList.addPreference(preference);
        }
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);
        menu.add(0, 1, 0, (CharSequence)this.getResources().getString(2131231319)).setIcon(17301555);
        menu.add(0, 2, 0, (CharSequence)this.getResources().getString(2131231328)).setIcon(17301589);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 1: {
                this.addNewApn();
                return true;
            }
            case 2: {
                this.restoreDefaultApn();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private void addNewApn() {
        this.startActivity(new Intent("android.intent.action.INSERT", Telephony.Carriers.CONTENT_URI));
    }

    public boolean onPreferenceTreeClick(PreferenceScreen preferenceScreen, Preference preference) {
        int pos = Integer.parseInt(preference.getKey());
        Uri url = ContentUris.withAppendedId((Uri)Telephony.Carriers.CONTENT_URI, (long)pos);
        this.startActivity(new Intent("android.intent.action.EDIT", url));
        return true;
    }

    public boolean onPreferenceChange(Preference preference, Object newValue) {
        Log.d((String)TAG, (String)("onPreferenceChange(): Preference - " + preference + ", newValue - " + newValue + ", newValue type - " + newValue.getClass()));
        if (newValue instanceof String) {
            this.setSelectedApnKey((String)newValue);
        }
        return true;
    }

    private void setSelectedApnKey(String key) {
        this.mSelectedKey = key;
        ContentResolver resolver = this.getContentResolver();
        ContentValues values = new ContentValues();
        values.put(APN_ID, this.mSelectedKey);
        resolver.update(PREFERAPN_URI, values, null, null);
    }

    private String getSelectedApnKey() {
        String key = null;
        Cursor cursor = this.managedQuery(PREFERAPN_URI, new String[]{"_id"}, null, "name ASC");
        if (cursor.getCount() > 0) {
            cursor.moveToFirst();
            key = cursor.getString(0);
        }
        cursor.close();
        return key;
    }

    private boolean restoreDefaultApn() {
        this.showDialog(1001);
        mRestoreDefaultApnMode = true;
        if (this.mRestoreApnUiHandler == null) {
            this.mRestoreApnUiHandler = new RestoreApnUiHandler();
        }
        if (this.mRestoreApnProcessHandler == null) {
            HandlerThread restoreDefaultApnThread = new HandlerThread("Restore default APN Handler: Process Thread");
            restoreDefaultApnThread.start();
            this.mRestoreApnProcessHandler = new RestoreApnProcessHandler(restoreDefaultApnThread.getLooper(), this.mRestoreApnUiHandler);
        }
        this.mRestoreApnProcessHandler.sendEmptyMessage(1);
        return true;
    }

    protected Dialog onCreateDialog(int id2) {
        if (id2 == 1001) {
            ProgressDialog dialog = new ProgressDialog((Context)this);
            dialog.setMessage((CharSequence)this.getResources().getString(2131231327));
            dialog.setCancelable(false);
            return dialog;
        }
        return null;
    }

    protected void onPrepareDialog(int id2, Dialog dialog) {
        if (id2 == 1001) {
            this.getPreferenceScreen().setEnabled(false);
        }
    }

    private class RestoreApnProcessHandler
    extends Handler {
        private Handler mRestoreApnUiHandler;

        public RestoreApnProcessHandler(Looper looper, Handler restoreApnUiHandler) {
            super(looper);
            this.mRestoreApnUiHandler = restoreApnUiHandler;
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    ContentResolver resolver = ApnSettings.this.getContentResolver();
                    resolver.delete(DEFAULTAPN_URI, null, null);
                    this.mRestoreApnUiHandler.sendEmptyMessage(2);
                }
            }
        }
    }

    private class RestoreApnUiHandler
    extends Handler {
        private RestoreApnUiHandler() {
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 2: {
                    ApnSettings.this.fillList();
                    ApnSettings.this.getPreferenceScreen().setEnabled(true);
                    mRestoreDefaultApnMode = false;
                    ApnSettings.this.dismissDialog(1001);
                    Toast.makeText((Context)ApnSettings.this, (CharSequence)ApnSettings.this.getResources().getString(2131231329), (int)1).show();
                }
            }
        }
    }
}

