/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.content.ContentUris;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.preference.Preference;
import android.provider.Telephony;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.RadioButton;
import android.widget.RelativeLayout;

public class ApnPreference
extends Preference
implements CompoundButton.OnCheckedChangeListener,
View.OnClickListener {
    static final String TAG = "ApnPreference";
    private static String mSelectedKey = null;
    private static CompoundButton mCurrentChecked = null;
    private boolean mProtectFromCheckedChange = false;
    private boolean mSelectable = true;

    public ApnPreference(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public ApnPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ApnPreference(Context context) {
        super(context);
        this.init();
    }

    public View getView(View convertView, ViewGroup parent) {
        View textLayout;
        View view = super.getView(convertView, parent);
        View widget = view.findViewById(0x1010001);
        if (widget != null && widget instanceof RadioButton) {
            RadioButton rb = (RadioButton)widget;
            if (this.mSelectable) {
                rb.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
                boolean isChecked = this.getKey().equals(mSelectedKey);
                if (isChecked) {
                    mCurrentChecked = rb;
                    mSelectedKey = this.getKey();
                }
                this.mProtectFromCheckedChange = true;
                rb.setChecked(isChecked);
                this.mProtectFromCheckedChange = false;
            } else {
                rb.setVisibility(8);
            }
        }
        if ((textLayout = view.findViewById(0x1010000)) != null && textLayout instanceof RelativeLayout) {
            textLayout.setOnClickListener((View.OnClickListener)this);
        }
        return view;
    }

    private void init() {
        this.setLayoutResource(2130903040);
    }

    public boolean isChecked() {
        return this.getKey().equals(mSelectedKey);
    }

    public void setChecked() {
        mSelectedKey = this.getKey();
    }

    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        Log.i((String)TAG, (String)("ID: " + this.getKey() + " :" + isChecked));
        if (this.mProtectFromCheckedChange) {
            return;
        }
        if (isChecked) {
            if (mCurrentChecked != null) {
                mCurrentChecked.setChecked(false);
            }
            mCurrentChecked = buttonView;
            mSelectedKey = this.getKey();
            this.callChangeListener(mSelectedKey);
        } else {
            mCurrentChecked = null;
            mSelectedKey = null;
        }
    }

    public void onClick(View v) {
        Context context;
        if (v != null && 0x1010000 == v.getId() && (context = this.getContext()) != null) {
            int pos = Integer.parseInt(this.getKey());
            Uri url = ContentUris.withAppendedId((Uri)Telephony.Carriers.CONTENT_URI, (long)pos);
            context.startActivity(new Intent("android.intent.action.EDIT", url));
        }
    }

    public void setSelectable(boolean selectable) {
        this.mSelectable = selectable;
    }

    public boolean getSelectable() {
        return this.mSelectable;
    }
}

