/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.app.AlertDialog;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.SystemProperties;
import android.preference.EditTextPreference;
import android.preference.ListPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.provider.Telephony;
import android.util.Log;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;

public class ApnEditor
extends PreferenceActivity
implements SharedPreferences.OnSharedPreferenceChangeListener,
Preference.OnPreferenceChangeListener {
    private static final String TAG = ApnEditor.class.getSimpleName();
    private static final String SAVED_POS = "pos";
    private static final String KEY_AUTH_TYPE = "auth_type";
    private static final String KEY_PROTOCOL = "apn_protocol";
    private static final int MENU_DELETE = 1;
    private static final int MENU_SAVE = 2;
    private static final int MENU_CANCEL = 3;
    private static String sNotSet;
    private EditTextPreference mName;
    private EditTextPreference mApn;
    private EditTextPreference mProxy;
    private EditTextPreference mPort;
    private EditTextPreference mUser;
    private EditTextPreference mServer;
    private EditTextPreference mPassword;
    private EditTextPreference mMmsc;
    private EditTextPreference mMcc;
    private EditTextPreference mMnc;
    private EditTextPreference mMmsProxy;
    private EditTextPreference mMmsPort;
    private ListPreference mAuthType;
    private EditTextPreference mApnType;
    private ListPreference mProtocol;
    private String mCurMnc;
    private String mCurMcc;
    private Uri mUri;
    private Cursor mCursor;
    private boolean mNewApn;
    private boolean mFirstTime;
    private Resources mRes;
    private static final String[] sProjection;
    private static final int ID_INDEX = 0;
    private static final int NAME_INDEX = 1;
    private static final int APN_INDEX = 2;
    private static final int PROXY_INDEX = 3;
    private static final int PORT_INDEX = 4;
    private static final int USER_INDEX = 5;
    private static final int SERVER_INDEX = 6;
    private static final int PASSWORD_INDEX = 7;
    private static final int MMSC_INDEX = 8;
    private static final int MCC_INDEX = 9;
    private static final int MNC_INDEX = 10;
    private static final int MMSPROXY_INDEX = 12;
    private static final int MMSPORT_INDEX = 13;
    private static final int AUTH_TYPE_INDEX = 14;
    private static final int TYPE_INDEX = 15;
    private static final int PROTOCOL_INDEX = 16;

    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.addPreferencesFromResource(2130968577);
        sNotSet = this.getResources().getString(2131231298);
        this.mName = (EditTextPreference)this.findPreference("apn_name");
        this.mApn = (EditTextPreference)this.findPreference("apn_apn");
        this.mProxy = (EditTextPreference)this.findPreference("apn_http_proxy");
        this.mPort = (EditTextPreference)this.findPreference("apn_http_port");
        this.mUser = (EditTextPreference)this.findPreference("apn_user");
        this.mServer = (EditTextPreference)this.findPreference("apn_server");
        this.mPassword = (EditTextPreference)this.findPreference("apn_password");
        this.mMmsProxy = (EditTextPreference)this.findPreference("apn_mms_proxy");
        this.mMmsPort = (EditTextPreference)this.findPreference("apn_mms_port");
        this.mMmsc = (EditTextPreference)this.findPreference("apn_mmsc");
        this.mMcc = (EditTextPreference)this.findPreference("apn_mcc");
        this.mMnc = (EditTextPreference)this.findPreference("apn_mnc");
        this.mApnType = (EditTextPreference)this.findPreference("apn_type");
        this.mAuthType = (ListPreference)this.findPreference(KEY_AUTH_TYPE);
        this.mAuthType.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
        this.mProtocol = (ListPreference)this.findPreference(KEY_PROTOCOL);
        this.mProtocol.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
        this.mRes = this.getResources();
        Intent intent = this.getIntent();
        String action = intent.getAction();
        boolean bl = this.mFirstTime = icicle == null;
        if (action.equals("android.intent.action.EDIT")) {
            this.mUri = intent.getData();
        } else if (action.equals("android.intent.action.INSERT")) {
            this.mUri = this.mFirstTime || icicle.getInt(SAVED_POS) == 0 ? this.getContentResolver().insert(intent.getData(), new ContentValues()) : ContentUris.withAppendedId((Uri)Telephony.Carriers.CONTENT_URI, (long)icicle.getInt(SAVED_POS));
            this.mNewApn = true;
            if (this.mUri == null) {
                Log.w((String)TAG, (String)("Failed to insert new telephony provider into " + this.getIntent().getData()));
                this.finish();
                return;
            }
            this.setResult(-1, new Intent().setAction(this.mUri.toString()));
        } else {
            this.finish();
            return;
        }
        this.mCursor = this.managedQuery(this.mUri, sProjection, null, null);
        this.mCursor.moveToFirst();
        this.fillUi();
    }

    public void onResume() {
        super.onResume();
        this.getPreferenceScreen().getSharedPreferences().registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
    }

    public void onPause() {
        this.getPreferenceScreen().getSharedPreferences().unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
        super.onPause();
    }

    private void fillUi() {
        if (this.mFirstTime) {
            int authVal;
            String numeric;
            this.mFirstTime = false;
            this.mName.setText(this.mCursor.getString(1));
            this.mApn.setText(this.mCursor.getString(2));
            this.mProxy.setText(this.mCursor.getString(3));
            this.mPort.setText(this.mCursor.getString(4));
            this.mUser.setText(this.mCursor.getString(5));
            this.mServer.setText(this.mCursor.getString(6));
            this.mPassword.setText(this.mCursor.getString(7));
            this.mMmsProxy.setText(this.mCursor.getString(12));
            this.mMmsPort.setText(this.mCursor.getString(13));
            this.mMmsc.setText(this.mCursor.getString(8));
            this.mMcc.setText(this.mCursor.getString(9));
            this.mMnc.setText(this.mCursor.getString(10));
            this.mApnType.setText(this.mCursor.getString(15));
            if (this.mNewApn && (numeric = SystemProperties.get((String)"gsm.sim.operator.numeric")) != null && numeric.length() > 4) {
                String mcc = numeric.substring(0, 3);
                String mnc = numeric.substring(3);
                this.mMcc.setText(mcc);
                this.mMnc.setText(mnc);
                this.mCurMnc = mnc;
                this.mCurMcc = mcc;
            }
            if ((authVal = this.mCursor.getInt(14)) != -1) {
                this.mAuthType.setValueIndex(authVal);
            }
            this.mProtocol.setValue(this.mCursor.getString(16));
        }
        this.mName.setSummary((CharSequence)this.checkNull(this.mName.getText()));
        this.mApn.setSummary((CharSequence)this.checkNull(this.mApn.getText()));
        this.mProxy.setSummary((CharSequence)this.checkNull(this.mProxy.getText()));
        this.mPort.setSummary((CharSequence)this.checkNull(this.mPort.getText()));
        this.mUser.setSummary((CharSequence)this.checkNull(this.mUser.getText()));
        this.mServer.setSummary((CharSequence)this.checkNull(this.mServer.getText()));
        this.mPassword.setSummary((CharSequence)this.starify(this.mPassword.getText()));
        this.mMmsProxy.setSummary((CharSequence)this.checkNull(this.mMmsProxy.getText()));
        this.mMmsPort.setSummary((CharSequence)this.checkNull(this.mMmsPort.getText()));
        this.mMmsc.setSummary((CharSequence)this.checkNull(this.mMmsc.getText()));
        this.mMcc.setSummary((CharSequence)this.checkNull(this.mMcc.getText()));
        this.mMnc.setSummary((CharSequence)this.checkNull(this.mMnc.getText()));
        this.mApnType.setSummary((CharSequence)this.checkNull(this.mApnType.getText()));
        String authVal = this.mAuthType.getValue();
        if (authVal != null) {
            int authValIndex = Integer.parseInt(authVal);
            this.mAuthType.setValueIndex(authValIndex);
            String[] values = this.mRes.getStringArray(2131034145);
            this.mAuthType.setSummary((CharSequence)values[authValIndex]);
        } else {
            this.mAuthType.setSummary((CharSequence)sNotSet);
        }
        this.mProtocol.setSummary((CharSequence)this.checkNull(this.protocolDescription(this.mProtocol.getValue())));
    }

    private String protocolDescription(String raw) {
        int protocolIndex = this.mProtocol.findIndexOfValue(raw);
        if (protocolIndex == -1) {
            return null;
        }
        String[] values = this.mRes.getStringArray(2131034147);
        try {
            return values[protocolIndex];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public boolean onPreferenceChange(Preference preference, Object newValue) {
        String key = preference.getKey();
        if (KEY_AUTH_TYPE.equals(key)) {
            try {
                int index = Integer.parseInt((String)newValue);
                this.mAuthType.setValueIndex(index);
                String[] values = this.mRes.getStringArray(2131034145);
                this.mAuthType.setSummary((CharSequence)values[index]);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }
        if (KEY_PROTOCOL.equals(key)) {
            String protocol = this.protocolDescription((String)newValue);
            if (protocol == null) {
                return false;
            }
            this.mProtocol.setSummary((CharSequence)protocol);
            this.mProtocol.setValue((String)newValue);
        }
        return true;
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);
        if (!this.mNewApn) {
            menu.add(0, 1, 0, 2131231318).setIcon(17301564);
        }
        menu.add(0, 2, 0, 2131231320).setIcon(17301582);
        menu.add(0, 3, 0, 2131231321).setIcon(17301560);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 1: {
                this.deleteApn();
                return true;
            }
            case 2: {
                if (this.validateAndSave(false)) {
                    this.finish();
                }
                return true;
            }
            case 3: {
                if (this.mNewApn) {
                    this.getContentResolver().delete(this.mUri, null, null);
                }
                this.finish();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 4: {
                if (this.validateAndSave(false)) {
                    this.finish();
                }
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    protected void onSaveInstanceState(Bundle icicle) {
        super.onSaveInstanceState(icicle);
        if (this.validateAndSave(true)) {
            icicle.putInt(SAVED_POS, this.mCursor.getInt(0));
        }
    }

    private boolean validateAndSave(boolean force) {
        String name = this.checkNotSet(this.mName.getText());
        String apn = this.checkNotSet(this.mApn.getText());
        String mcc = this.checkNotSet(this.mMcc.getText());
        String mnc = this.checkNotSet(this.mMnc.getText());
        String errorMsg = null;
        if (name.length() < 1) {
            errorMsg = this.mRes.getString(2131231323);
        } else if (apn.length() < 1) {
            errorMsg = this.mRes.getString(2131231324);
        } else if (mcc.length() != 3) {
            errorMsg = this.mRes.getString(2131231325);
        } else if ((mnc.length() & 0xFFFE) != 2) {
            errorMsg = this.mRes.getString(2131231326);
        }
        if (errorMsg != null && !force) {
            this.showErrorMessage(errorMsg);
            return false;
        }
        if (!this.mCursor.moveToFirst()) {
            Log.w((String)TAG, (String)"Could not go to the first row in the Cursor when saving data.");
            return false;
        }
        if (force && this.mNewApn && name.length() < 1 && apn.length() < 1) {
            this.getContentResolver().delete(this.mUri, null, null);
            return false;
        }
        ContentValues values = new ContentValues();
        values.put("name", name.length() < 1 ? this.getResources().getString(2131231874) : name);
        values.put("apn", apn);
        values.put("proxy", this.checkNotSet(this.mProxy.getText()));
        values.put("port", this.checkNotSet(this.mPort.getText()));
        values.put("mmsproxy", this.checkNotSet(this.mMmsProxy.getText()));
        values.put("mmsport", this.checkNotSet(this.mMmsPort.getText()));
        values.put("user", this.checkNotSet(this.mUser.getText()));
        values.put("server", this.checkNotSet(this.mServer.getText()));
        values.put("password", this.checkNotSet(this.mPassword.getText()));
        values.put("mmsc", this.checkNotSet(this.mMmsc.getText()));
        String authVal = this.mAuthType.getValue();
        if (authVal != null) {
            values.put("authtype", Integer.valueOf(Integer.parseInt(authVal)));
        }
        values.put("protocol", this.checkNotSet(this.mProtocol.getValue()));
        values.put("roaming_protocol", "IP");
        values.put("type", this.checkNotSet(this.mApnType.getText()));
        values.put("mcc", mcc);
        values.put("mnc", mnc);
        values.put("numeric", mcc + mnc);
        if (this.mCurMnc != null && this.mCurMcc != null && this.mCurMnc.equals(mnc) && this.mCurMcc.equals(mcc)) {
            values.put("current", Integer.valueOf(1));
        }
        this.getContentResolver().update(this.mUri, values, null, null);
        return true;
    }

    private void showErrorMessage(String message) {
        new AlertDialog.Builder((Context)this).setTitle(2131231322).setMessage((CharSequence)message).setPositiveButton(17039370, null).show();
    }

    private void deleteApn() {
        this.getContentResolver().delete(this.mUri, null, null);
        this.finish();
    }

    private String starify(String value) {
        if (value == null || value.length() == 0) {
            return sNotSet;
        }
        char[] password = new char[value.length()];
        for (int i = 0; i < password.length; ++i) {
            password[i] = 42;
        }
        return new String(password);
    }

    private String checkNull(String value) {
        if (value == null || value.length() == 0) {
            return sNotSet;
        }
        return value;
    }

    private String checkNotSet(String value) {
        if (value == null || value.equals(sNotSet)) {
            return "";
        }
        return value;
    }

    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
        Preference pref = this.findPreference(key);
        if (pref != null) {
            if (pref.equals(this.mPassword)) {
                pref.setSummary((CharSequence)this.starify(sharedPreferences.getString(key, "")));
            } else {
                pref.setSummary((CharSequence)this.checkNull(sharedPreferences.getString(key, "")));
            }
        }
    }

    static {
        sProjection = new String[]{"_id", "name", "apn", "proxy", "port", "user", "server", "password", "mmsc", "mcc", "mnc", "numeric", "mmsproxy", "mmsport", "authtype", "type", "protocol"};
    }
}

