/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Message;
import android.os.SystemProperties;
import android.preference.CheckBoxPreference;
import android.preference.Preference;
import android.provider.Settings;
import android.telephony.ServiceState;
import com.android.internal.telephony.PhoneStateIntentReceiver;

public class AirplaneModeEnabler
implements Preference.OnPreferenceChangeListener {
    private final Context mContext;
    private PhoneStateIntentReceiver mPhoneStateReceiver;
    private final CheckBoxPreference mCheckBoxPref;
    private static final int EVENT_SERVICE_STATE_CHANGED = 3;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 3: {
                    AirplaneModeEnabler.this.onAirplaneModeChanged();
                }
            }
        }
    };

    public AirplaneModeEnabler(Context context, CheckBoxPreference airplaneModeCheckBoxPreference) {
        this.mContext = context;
        this.mCheckBoxPref = airplaneModeCheckBoxPreference;
        airplaneModeCheckBoxPreference.setPersistent(false);
        this.mPhoneStateReceiver = new PhoneStateIntentReceiver(this.mContext, this.mHandler);
        this.mPhoneStateReceiver.notifyServiceState(3);
    }

    public void resume() {
        this.mCheckBoxPref.setEnabled(true);
        this.mCheckBoxPref.setChecked(AirplaneModeEnabler.isAirplaneModeOn(this.mContext));
        this.mPhoneStateReceiver.registerIntent();
        this.mCheckBoxPref.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
    }

    public void pause() {
        this.mPhoneStateReceiver.unregisterIntent();
        this.mCheckBoxPref.setOnPreferenceChangeListener(null);
    }

    public static boolean isAirplaneModeOn(Context context) {
        return Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"airplane_mode_on", (int)0) != 0;
    }

    private void setAirplaneModeOn(boolean enabling) {
        this.mCheckBoxPref.setEnabled(false);
        this.mCheckBoxPref.setSummary(enabling ? 2131230925 : 2131230926);
        Settings.System.putInt((ContentResolver)this.mContext.getContentResolver(), (String)"airplane_mode_on", (int)(enabling ? 1 : 0));
        Intent intent = new Intent("android.intent.action.AIRPLANE_MODE");
        intent.putExtra("state", enabling);
        this.mContext.sendBroadcast(intent);
    }

    private void onAirplaneModeChanged() {
        ServiceState serviceState = this.mPhoneStateReceiver.getServiceState();
        boolean airplaneModeEnabled = serviceState.getState() == 3;
        this.mCheckBoxPref.setChecked(airplaneModeEnabled);
        this.mCheckBoxPref.setSummary(airplaneModeEnabled ? null : this.mContext.getString(2131230924));
        this.mCheckBoxPref.setEnabled(true);
    }

    public boolean onPreferenceChange(Preference preference, Object newValue) {
        if (!Boolean.parseBoolean(SystemProperties.get((String)"ril.cdma.inecmmode"))) {
            this.setAirplaneModeOn((Boolean)newValue);
        }
        return true;
    }

    public void setAirplaneModeInECM(boolean isECMExit, boolean isAirplaneModeOn) {
        if (isECMExit) {
            this.setAirplaneModeOn(isAirplaneModeOn);
        } else {
            this.onAirplaneModeChanged();
        }
    }
}

