/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.DrawFilter;
import android.graphics.PaintFlagsDrawFilter;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.PaintDrawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.android.internal.app.AlertActivity;
import com.android.internal.app.AlertController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityPicker
extends AlertActivity
implements DialogInterface.OnClickListener,
DialogInterface.OnCancelListener {
    private PickAdapter mAdapter;
    private Intent mBaseIntent;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        Parcelable parcel = intent.getParcelableExtra("android.intent.extra.INTENT");
        if (parcel instanceof Intent) {
            this.mBaseIntent = (Intent)parcel;
        } else {
            this.mBaseIntent = new Intent("android.intent.action.MAIN", null);
            this.mBaseIntent.addCategory("android.intent.category.DEFAULT");
        }
        AlertController.AlertParams params = this.mAlertParams;
        params.mOnClickListener = this;
        params.mOnCancelListener = this;
        params.mTitle = intent.hasExtra("android.intent.extra.TITLE") ? intent.getStringExtra("android.intent.extra.TITLE") : this.getTitle();
        List<PickAdapter.Item> items = this.getItems();
        this.mAdapter = new PickAdapter((Context)this, items);
        params.mAdapter = this.mAdapter;
        this.setupAlert();
    }

    public void onClick(DialogInterface dialog, int which) {
        Intent intent = this.getIntentForPosition(which);
        this.setResult(-1, intent);
        this.finish();
    }

    public void onCancel(DialogInterface dialog) {
        this.setResult(0);
        this.finish();
    }

    protected Intent getIntentForPosition(int position) {
        PickAdapter.Item item = (PickAdapter.Item)this.mAdapter.getItem(position);
        return item.getIntent(this.mBaseIntent);
    }

    protected List<PickAdapter.Item> getItems() {
        PackageManager packageManager = this.getPackageManager();
        ArrayList<PickAdapter.Item> items = new ArrayList<PickAdapter.Item>();
        Intent intent = this.getIntent();
        ArrayList labels = intent.getStringArrayListExtra("android.intent.extra.shortcut.NAME");
        ArrayList icons = intent.getParcelableArrayListExtra("android.intent.extra.shortcut.ICON_RESOURCE");
        if (labels != null && icons != null && labels.size() == icons.size()) {
            for (int i = 0; i < labels.size(); ++i) {
                String label = (String)labels.get(i);
                Drawable icon = null;
                try {
                    Intent.ShortcutIconResource iconResource = (Intent.ShortcutIconResource)icons.get(i);
                    Resources res = packageManager.getResourcesForApplication(iconResource.packageName);
                    icon = res.getDrawable(res.getIdentifier(iconResource.resourceName, null, null));
                }
                catch (PackageManager.NameNotFoundException e) {
                    // empty catch block
                }
                items.add(new PickAdapter.Item((Context)this, label, icon));
            }
        }
        if (this.mBaseIntent != null) {
            this.putIntentItems(this.mBaseIntent, items);
        }
        return items;
    }

    protected void putIntentItems(Intent baseIntent, List<PickAdapter.Item> items) {
        PackageManager packageManager = this.getPackageManager();
        List list = packageManager.queryIntentActivities(baseIntent, 0);
        Collections.sort(list, new ResolveInfo.DisplayNameComparator(packageManager));
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            ResolveInfo resolveInfo = (ResolveInfo)list.get(i);
            items.add(new PickAdapter.Item((Context)this, packageManager, resolveInfo));
        }
    }

    private static class EmptyDrawable
    extends Drawable {
        private final int mWidth;
        private final int mHeight;

        EmptyDrawable(int width, int height) {
            this.mWidth = width;
            this.mHeight = height;
        }

        public int getIntrinsicWidth() {
            return this.mWidth;
        }

        public int getIntrinsicHeight() {
            return this.mHeight;
        }

        public int getMinimumWidth() {
            return this.mWidth;
        }

        public int getMinimumHeight() {
            return this.mHeight;
        }

        public void draw(Canvas canvas) {
        }

        public void setAlpha(int alpha) {
        }

        public void setColorFilter(ColorFilter cf) {
        }

        public int getOpacity() {
            return -3;
        }
    }

    private static class IconResizer {
        private final int mIconWidth;
        private final int mIconHeight;
        private final DisplayMetrics mMetrics;
        private final Rect mOldBounds = new Rect();
        private final Canvas mCanvas = new Canvas();

        public IconResizer(int width, int height, DisplayMetrics metrics) {
            this.mCanvas.setDrawFilter((DrawFilter)new PaintFlagsDrawFilter(4, 2));
            this.mMetrics = metrics;
            this.mIconWidth = width;
            this.mIconHeight = height;
        }

        public Drawable createIconThumbnail(Drawable icon) {
            int width = this.mIconWidth;
            int height = this.mIconHeight;
            if (icon == null) {
                return new EmptyDrawable(width, height);
            }
            try {
                BitmapDrawable bitmapDrawable;
                Bitmap bitmap;
                if (icon instanceof PaintDrawable) {
                    PaintDrawable painter = (PaintDrawable)icon;
                    painter.setIntrinsicWidth(width);
                    painter.setIntrinsicHeight(height);
                } else if (icon instanceof BitmapDrawable && (bitmap = (bitmapDrawable = (BitmapDrawable)icon).getBitmap()).getDensity() == 0) {
                    bitmapDrawable.setTargetDensity(this.mMetrics);
                }
                int iconWidth = icon.getIntrinsicWidth();
                int iconHeight = icon.getIntrinsicHeight();
                if (iconWidth > 0 && iconHeight > 0) {
                    if (width < iconWidth || height < iconHeight) {
                        float ratio = (float)iconWidth / (float)iconHeight;
                        if (iconWidth > iconHeight) {
                            height = (int)((float)width / ratio);
                        } else if (iconHeight > iconWidth) {
                            width = (int)((float)height * ratio);
                        }
                        Bitmap.Config c = icon.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
                        Bitmap thumb = Bitmap.createBitmap((int)this.mIconWidth, (int)this.mIconHeight, (Bitmap.Config)c);
                        Canvas canvas = this.mCanvas;
                        canvas.setBitmap(thumb);
                        this.mOldBounds.set(icon.getBounds());
                        int x = (this.mIconWidth - width) / 2;
                        int y = (this.mIconHeight - height) / 2;
                        icon.setBounds(x, y, x + width, y + height);
                        icon.draw(canvas);
                        icon.setBounds(this.mOldBounds);
                        icon = new BitmapDrawable(thumb);
                        ((BitmapDrawable)icon).setTargetDensity(this.mMetrics);
                    } else if (iconWidth < width && iconHeight < height) {
                        Bitmap.Config c = Bitmap.Config.ARGB_8888;
                        Bitmap thumb = Bitmap.createBitmap((int)this.mIconWidth, (int)this.mIconHeight, (Bitmap.Config)c);
                        Canvas canvas = this.mCanvas;
                        canvas.setBitmap(thumb);
                        this.mOldBounds.set(icon.getBounds());
                        int x = (width - iconWidth) / 2;
                        int y = (height - iconHeight) / 2;
                        icon.setBounds(x, y, x + iconWidth, y + iconHeight);
                        icon.draw(canvas);
                        icon.setBounds(this.mOldBounds);
                        icon = new BitmapDrawable(thumb);
                        ((BitmapDrawable)icon).setTargetDensity(this.mMetrics);
                    }
                }
            }
            catch (Throwable t) {
                icon = new EmptyDrawable(width, height);
            }
            return icon;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PickAdapter
    extends BaseAdapter {
        private final LayoutInflater mInflater;
        private final List<Item> mItems;

        public PickAdapter(Context context, List<Item> items) {
            this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
            this.mItems = items;
        }

        public int getCount() {
            return this.mItems.size();
        }

        public Object getItem(int position) {
            return this.mItems.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                convertView = this.mInflater.inflate(2130903075, parent, false);
            }
            Item item = (Item)this.getItem(position);
            TextView textView = (TextView)convertView;
            textView.setText(item.label);
            textView.setCompoundDrawablesWithIntrinsicBounds(item.icon, null, null, null);
            return convertView;
        }

        public static class Item {
            protected static IconResizer sResizer;
            CharSequence label;
            Drawable icon;
            String packageName;
            String className;
            Bundle extras;

            protected IconResizer getResizer(Context context) {
                if (sResizer == null) {
                    Resources resources = context.getResources();
                    int size = (int)resources.getDimension(0x1050000);
                    sResizer = new IconResizer(size, size, resources.getDisplayMetrics());
                }
                return sResizer;
            }

            Item(Context context, CharSequence label, Drawable icon) {
                this.label = label;
                this.icon = this.getResizer(context).createIconThumbnail(icon);
            }

            Item(Context context, PackageManager pm, ResolveInfo resolveInfo) {
                this.label = resolveInfo.loadLabel(pm);
                if (this.label == null && resolveInfo.activityInfo != null) {
                    this.label = resolveInfo.activityInfo.name;
                }
                this.icon = this.getResizer(context).createIconThumbnail(resolveInfo.loadIcon(pm));
                this.packageName = resolveInfo.activityInfo.applicationInfo.packageName;
                this.className = resolveInfo.activityInfo.name;
            }

            Intent getIntent(Intent baseIntent) {
                Intent intent = new Intent(baseIntent);
                if (this.packageName != null && this.className != null) {
                    intent.setClassName(this.packageName, this.className);
                    if (this.extras != null) {
                        intent.putExtras(this.extras);
                    }
                } else {
                    intent.setAction("android.intent.action.CREATE_SHORTCUT");
                    intent.putExtra("android.intent.extra.shortcut.NAME", this.label);
                }
                return intent;
            }
        }
    }
}

